/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class GlobalVariableTests
extends TestCase {
    private static final String TEST_NAME = "Test Global Field Variables JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public GlobalVariableTests() {
        super(TEST_NAME);
    }

    public GlobalVariableTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.GlobalVariableTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testFindGlobalVariables_OtherFile_BeforeOpen_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 0, 0, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_BeforeOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 1, 1, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_BeforeOpen_NegativeTest_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 3, 7, expectedProposals, true, false);
    }

    public void testFindGlobalVariables_OtherFile_BeforeOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 3, 7, expectedProposals);
    }

    public void testFindGlobalVariables_ThisFile_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_0.js", 10, 0, expectedProposals);
    }

    public void testFindGlobalVariables_ThisFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_0.js", 9, 1, expectedProposals);
    }

    public void testFindGlobalVariables_ThisFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_0.js", 11, 7, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_AfterOpen_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 0, 0, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_AfterOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 1, 1, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_AfterOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 3, 7, expectedProposals);
    }

    public void testFindGlobalVariables_OtherFile_AfterOpen_Negativetest_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 3, 7, expectedProposals, true, false);
    }

    public void testFindVariable_OtherFile_FromJAR_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"s : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test14_0.js", 2, 1, expectedProposals);
    }

    public void testFindAdditionalInfoFromJAR() throws Exception {
        final byte[] found = new byte[1];
        new SearchEngine().search(SearchPattern.createPattern((String)"num", (int)4, (int)0, (int)1), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{JavaScriptCore.create((IProject)fTestProjectSetup.getProject())}, (int)2), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                found[0] = (byte)(found[0] + 1);
                GlobalVariableTests.assertNotNull((Object)JSdocContentAccess.getContentReader((IJavaScriptElement)((IJavaScriptElement)match.getElement()), (boolean)true));
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        GlobalVariableTests.assertTrue((found[0] > 0 ? 1 : 0) != 0);
    }

    public void testFindAdditionalInfoFromLIB() throws Exception {
        final byte[] found = new byte[1];
        new SearchEngine().search(SearchPattern.createPattern((String)"num2", (int)4, (int)0, (int)1), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{JavaScriptCore.create((IProject)fTestProjectSetup.getProject())}, (int)2), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                found[0] = (byte)(found[0] + 1);
                GlobalVariableTests.assertNotNull((Object)JSdocContentAccess.getContentReader((IJavaScriptElement)((IJavaScriptElement)match.getElement()), (boolean)true));
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        GlobalVariableTests.assertTrue((found[0] > 0 ? 1 : 0) != 0);
    }
}

