/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestJSPViewDefnAdapter
extends TestCase {
    private final String ENV_JSF_VERSION = "jsfRuntimeVersion";
    private JSFVersion _jsfVersion;
    private WebProjectTestEnvironment _webProjectTestEnv;
    private IFile _jspFile;
    private IStructuredModel _structuredModel;
    private static final ELData EMPTY_EXPR = new ELData("   ", 566);
    private static final ELData VAR_EXPR = new ELData("myBean", 599);
    private static final ELData BEAN_PROP_EXPR = new ELData("myBean.property", 635);
    private static final ELData BUILTIN_PROP_EXPR = new ELData("paramValues.foo", 680);
    private static final ELData METHOD_EXPR = new ELData("myBean.actionMethod", 729);

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        String version = System.getProperty("jsfRuntimeVersion");
        this._jsfVersion = version == null ? JSFVersion.V1_1 : JSFVersion.valueOfString((String)version);
        TestJSPViewDefnAdapter.assertTrue((this._jsfVersion == JSFVersion.V1_1 || this._jsfVersion == JSFVersion.V1_2 ? 1 : 0) != 0);
        String jst_web_version = this._jsfVersion == JSFVersion.V1_1 ? "2.4" : (this._jsfVersion == JSFVersion.V1_2 ? "2.5" : null);
        TestJSPViewDefnAdapter.assertNotNull((Object)jst_web_version);
        String jst_jsf_version = this._jsfVersion.toString();
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName(), JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion(jst_web_version));
        this._webProjectTestEnv.createProject(false);
        TestJSPViewDefnAdapter.assertNotNull((Object)this._webProjectTestEnv);
        TestJSPViewDefnAdapter.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        TestJSPViewDefnAdapter.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacetedTestEnv = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        jsfFacetedTestEnv.initialize(jst_jsf_version);
        this._jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata2.jsp.data", "testdata2.jsp");
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._jspFile);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._structuredModel.releaseFromRead();
    }

    public final void testSanity() {
        IStructuredDocument sdoc = this._structuredModel.getStructuredDocument();
        TestJSPViewDefnAdapter.assertNotNull((Object)sdoc);
        EMPTY_EXPR.assertELText(sdoc);
        VAR_EXPR.assertELText(sdoc);
        BEAN_PROP_EXPR.assertELText(sdoc);
        BUILTIN_PROP_EXPR.assertELText(sdoc);
        METHOD_EXPR.assertELText(sdoc);
    }

    public final void testGetELExpressionIModelContext() throws Exception {
        TestJSPViewDefnAdapter.assertTrue((boolean)DesignTimeApplicationManager.hasJSFDesignTime((IProject)this._webProjectTestEnv.getTestProject()));
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._webProjectTestEnv.getTestProject());
        TestJSPViewDefnAdapter.assertNotNull((Object)manager);
        IDTViewHandler handler = manager.getViewHandler();
        DTFacesContext facesContext = manager.getFacesContext(this._jspFile);
        TestJSPViewDefnAdapter.assertNotNull((Object)facesContext);
        TestJSPViewDefnAdapter.assertTrue((boolean)handler.supportsViewDefinition(this._jspFile));
        XMLViewDefnAdapter adapter = (XMLViewDefnAdapter)handler.getViewMetadataAdapterFactory(facesContext).createAdapter(facesContext, "");
        IStructuredDocument sdoc = this._structuredModel.getStructuredDocument();
        this.checkELExpression(adapter, sdoc, EMPTY_EXPR);
        this.checkELExpression(adapter, sdoc, VAR_EXPR);
        this.checkELExpression(adapter, sdoc, BEAN_PROP_EXPR);
        this.checkELExpression(adapter, sdoc, BUILTIN_PROP_EXPR);
        this.checkELExpression(adapter, sdoc, METHOD_EXPR);
    }

    private void checkELExpression(XMLViewDefnAdapter adapter, IStructuredDocument sdoc, ELData elData) throws Exception {
        String expectedText = elData._expectedText;
        int offset = elData._offset;
        int i = 0;
        while (i < expectedText.length()) {
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)sdoc, offset + i);
            XMLViewDefnAdapter.DTELExpression elExpr = adapter.getELExpression((IModelContext)context);
            TestJSPViewDefnAdapter.assertEquals((String)expectedText.trim(), (String)elExpr.getText().trim());
            TestJSPViewDefnAdapter.assertEquals((int)offset, (int)elExpr.getDocumentContext().getDocumentPosition());
            ++i;
        }
    }

    private static class ELData {
        private final String _expectedText;
        private final int _offset;

        ELData(String expectedText, int offset) {
            this._expectedText = expectedText;
            this._offset = offset;
        }

        IStructuredDocumentContext getContext(IStructuredDocument sdoc) {
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)sdoc, this._offset);
            TestJSPViewDefnAdapter.assertNotNull((Object)context);
            return context;
        }

        String getELText(IStructuredDocument sdoc) {
            ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(this.getContext(sdoc));
            TestJSPViewDefnAdapter.assertEquals((String)"JSP_VBL_CONTENT", (String)resolver.getRegionType());
            return resolver.getRegionText();
        }

        void assertELText(IStructuredDocument sdoc) {
            TestJSPViewDefnAdapter.assertEquals((String)this._expectedText, (String)this.getELText(sdoc));
        }
    }
}

