/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class CamelCasingTests
extends TestCase {
    private static final String TEST_NAME = "Test Camel Casing JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public CamelCasingTests() {
        super(TEST_NAME);
    }

    public CamelCasingTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.CamelCasingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false){

            public void additionalSetUp() throws Exception {
                Thread.sleep(1000L);
            }
        };
        return fTestProjectSetup;
    }

    public void testCamelCasing_OtherFile_BeforeOpen_Expression1() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam", "iGotMessage(param1) - iGotMessage"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 0, 6, expectedProposals);
    }

    public void testCamelCasing_OtherFile_BeforeOpen_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 2, 7, expectedProposals);
    }

    public void testMustFail_OtherFile_Expression2_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"iGotMessage(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 2, 7, expectedProposals, true, false);
    }

    public void testCamelCasing_OtherFile_BeforeOpen_Expression3() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 4, 8, expectedProposals);
    }

    public void testCamelCasing_ThisFile_Expression1() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam", "iGotMessage(param1) - iGotMessage"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_0.js", 17, 6, expectedProposals);
    }

    public void testCamelCasing_ThisFile_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_0.js", 19, 7, expectedProposals);
    }

    public void testCamelCasing_ThisFile_Expression3() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_0.js", 21, 8, expectedProposals);
    }

    public void testCamelCasing_OtherFile_AfterEdit_Expression3_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"iGotMessage(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 4, 8, expectedProposals, true, false);
    }

    public void testCamelCasing_OtherFile_AfterOpen_Expression1() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam", "iGotMessage(param1) - iGotMessage"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 0, 6, expectedProposals);
    }

    public void testCamelCasing_OtherFile_AfterOpen_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 2, 7, expectedProposals);
    }

    public void testCamelCasing_OtherFile_AfterOpen_Expression3() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestConstructorCamelCase_1.js", 4, 8, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_OtherFile_BeforeOpen_Expresssion1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 5, 3, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_OtherFile_BeforeOpen_Expresssion2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVar - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 7, 2, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_Thisfile_Expresssion1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_0.js", 15, 3, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_ThisFile_Expresssion2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVar - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_0.js", 17, 2, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_OtherFile_AfterOpen_Expresssion1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 5, 3, expectedProposals);
    }

    public void testGlobalVar_CamelCasing_OtherFile_AfterOpen_Expresssion2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVar - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test11_1.js", 7, 2, expectedProposals);
    }

    public void testDoublyNestedFunc_CamelCasing_OtherFile_BeforeOpen_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 2, 2, expectedProposals);
    }

    public void testDoublyNestedFunc_CamelCasing_ThisFile_AfterOpen_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 2, 2, expectedProposals);
    }

    public void testDoublyNestedFunc_CamelCasing_OtherFile_AfterOpen_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 2, 2, expectedProposals);
    }
}

