/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.java.EscapedTextUtil;
import org.eclipse.jst.jsp.core.internal.java.IJSPProblem;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPIncludeRegionHelper;
import org.eclipse.jst.jsp.core.internal.java.StackMap;
import org.eclipse.jst.jsp.core.internal.java.XMLJSPRegionHelper;
import org.eclipse.jst.jsp.core.internal.taglib.CustomTag;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelper;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperManager;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibVariable;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.util.ZeroStructuredDocumentRegion;
import org.eclipse.jst.jsp.core.jspel.IJSPELTranslator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMDocumentTracker;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPTranslator
implements Externalizable {
    private static final long serialVersionUID = 3L;
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspjavamapping"));
    private static final String JSP_CORE_PLUGIN_ID = "org.eclipse.jst.jsp.core";
    private static final String DEFAULT_JSP_EL_TRANSLATOR_ID = "org.eclipse.jst.jsp.defaultJSP20";
    private static final String EL_TRANSLATOR_EXTENSION_NAME = "elTranslator";
    private static final String ELTRANSLATOR_PROP_NAME = "ELTranslator";
    public static final String ENDL = "\n";
    private static final String FOOTER = "}}";
    private static final String EXCEPTION = "Throwable exception = new Throwable();";
    public static final String EXPRESSION_PREFIX = "out.print(";
    public static final String EXPRESSION_SUFFIX = ");";
    private static final String TRY_CATCH_START = "\ntry {\n";
    private static final String TRY_CATCH_END = " } catch (java.lang.Exception e) {} \n";
    static final String JSP_PREFIX = "jsp:";
    protected static final int STANDARD_JSP = 0;
    protected static final int EMBEDDED_JSP = 1;
    protected static final int DECLARATION = 2;
    protected static final int EXPRESSION = 4;
    protected static final int SCRIPTLET = 8;
    String fClassHeader = null;
    String fClassname = null;
    String fSuperclass = null;
    String fImplicitImports = null;
    String fServiceHeader = null;
    String fContext = null;
    String fSession = null;
    private StringBuffer fUserImports = new StringBuffer();
    IDOMModel fStructuredModel = null;
    IStructuredDocument fStructuredDocument = null;
    private IJSPELTranslator fELTranslator = null;
    private List fTranslationProblems = new ArrayList();
    private int fSourcePosition = -1;
    private int fRelativeOffset = -1;
    private int fCursorPosition = -1;
    private boolean fIsErrorPage = false;
    private boolean fCursorInExpression = false;
    private boolean fIsInASession = true;
    private StringBuffer fUserCode = new StringBuffer();
    private StringBuffer fUserELExpressions = new StringBuffer();
    private StringBuffer fUserDeclarations = new StringBuffer();
    private StackMap fTagToVariableMap = null;
    private Stack fUseBeansStack = new Stack();
    private StringBuffer fResult;
    private StringBuffer fCursorOwner = null;
    private IStructuredDocumentRegion fCurrentNode;
    private boolean fInCodeRegion = false;
    private Stack fIncludes = null;
    private Set fIncludedPaths = new HashSet(2);
    private boolean fProcessIncludes = true;
    private ArrayList fBlockMarkers = null;
    private int fOffsetInUserImports = 0;
    private int fOffsetInUserDeclarations = 0;
    private int fOffsetInUserCode = 0;
    private HashMap fJava2JspRanges = new HashMap();
    private HashMap fImportRanges = new HashMap();
    private HashMap fCodeRanges = new HashMap();
    private HashMap fDeclarationRanges = new HashMap();
    private HashMap fUseBeanRanges = new HashMap();
    private HashMap fUserELRanges = new HashMap();
    private HashMap fIndirectRanges = new HashMap();
    private IProgressMonitor fProgressMonitor = null;
    private StringBuffer fJspTextBuffer = new StringBuffer();
    private String fELTranslatorID;
    private boolean fFoundNonTranslatedCode;
    private boolean fCodeTranslated;
    private IPath fSavedModelPath = null;
    private int fLastJSPType = 8;

    public JSPTranslator() {
        this.init();
    }

    private void configure(IDOMNode node, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        this.fStructuredModel = node.getModel();
        String baseLocation = this.fStructuredModel.getBaseLocation();
        this.fELTranslatorID = this.getELTranslatorProperty(baseLocation);
        this.fStructuredDocument = this.fStructuredModel.getStructuredDocument();
        String className = this.createClassname(node);
        if (className.length() > 0) {
            this.setClassname(className);
            this.fClassHeader = "public class " + className + " extends ";
        }
    }

    private void configure(IFile jspFile, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        this.fELTranslatorID = this.getELTranslatorProperty(jspFile);
        String className = this.createClassname(jspFile);
        if (className.length() > 0) {
            this.setClassname(className);
            this.fClassHeader = "public class " + className + " extends ";
        }
    }

    private void setJspText(IFile jspFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(jspFile.getContents());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.fJspTextBuffer.append(line);
                this.fJspTextBuffer.append(ENDL);
            }
            reader.close();
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private String getELTranslatorProperty(String baseLocation) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String elTranslatorValue = null;
        IFile file = workspaceRoot.getFile((IPath)new Path(baseLocation));
        if (file != null) {
            elTranslatorValue = this.getELTranslatorProperty(file);
        }
        return elTranslatorValue;
    }

    private String getELTranslatorProperty(IFile file) {
        String elTranslatorValue = null;
        if (file != null && file.exists()) {
            try {
                elTranslatorValue = file.getPersistentProperty(new QualifiedName(JSP_CORE_PLUGIN_ID, ELTRANSLATOR_PROP_NAME));
                if (elTranslatorValue == null) {
                    elTranslatorValue = file.getProject().getPersistentProperty(new QualifiedName(JSP_CORE_PLUGIN_ID, ELTRANSLATOR_PROP_NAME));
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return elTranslatorValue;
    }

    private String createClassname(IDOMNode node) {
        String classname = "";
        if (node != null) {
            String base = node.getModel().getBaseLocation();
            classname = JSP2ServletNameUtil.mangle(base);
        }
        return classname;
    }

    private String createClassname(IFile jspFile) {
        String classname = "";
        if (jspFile != null) {
            classname = JSP2ServletNameUtil.mangle(jspFile.getFullPath().toString());
        }
        return classname;
    }

    private IJSPProblem createJSPProblem(final int problemEID, final int problemID, final String message, final int start, final int end) {
        final int line = this.fStructuredDocument.getLineOfOffset(start);
        final char[] classname = this.fClassname.toCharArray();
        return new IJSPProblem(){

            public void setSourceStart(int sourceStart) {
            }

            public void setSourceLineNumber(int lineNumber) {
            }

            public void setSourceEnd(int sourceEnd) {
            }

            public boolean isWarning() {
                return false;
            }

            public boolean isError() {
                return true;
            }

            public int getSourceStart() {
                return start;
            }

            public int getSourceLineNumber() {
                return line;
            }

            public int getSourceEnd() {
                return end;
            }

            public char[] getOriginatingFileName() {
                return classname;
            }

            public String getMessage() {
                return message;
            }

            public int getID() {
                return problemID;
            }

            public String[] getArguments() {
                return new String[0];
            }

            public int getEID() {
                return problemEID;
            }
        };
    }

    public void setClassname(String classname) {
        this.fClassname = classname;
    }

    public String getClassname() {
        return this.fClassname != null ? this.fClassname : "GenericJspServlet";
    }

    public void reset(IDOMNode node, IProgressMonitor progress) {
        this.configure(node, progress);
        this.reset();
        this.fJspTextBuffer.append(this.fStructuredDocument.get());
    }

    public void reset(IFile jspFile, IProgressMonitor progress) {
        this.configure(jspFile, progress);
        this.reset();
        this.setJspText(jspFile);
    }

    void reset() {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.setCanceled(false);
        }
        this.fSourcePosition = -1;
        this.fRelativeOffset = -1;
        this.fCursorPosition = -1;
        this.fCursorInExpression = false;
        this.fIsErrorPage = false;
        this.fIsInASession = true;
        this.fUserCode = new StringBuffer();
        this.fUserDeclarations = new StringBuffer();
        this.fUserImports = new StringBuffer();
        this.fUserELExpressions = new StringBuffer();
        this.fResult = null;
        this.fCursorOwner = null;
        this.fCurrentNode = null;
        this.fInCodeRegion = false;
        if (this.fIncludes != null) {
            this.fIncludes.clear();
        }
        this.fBlockMarkers = null;
        this.fOffsetInUserImports = 0;
        this.fOffsetInUserDeclarations = 0;
        this.fOffsetInUserCode = 0;
        this.fJava2JspRanges.clear();
        this.fImportRanges.clear();
        this.fCodeRanges.clear();
        this.fUseBeanRanges.clear();
        this.fDeclarationRanges.clear();
        this.fUserELRanges.clear();
        this.fIndirectRanges.clear();
        this.fIncludedPaths.clear();
        this.fJspTextBuffer = new StringBuffer();
        this.fFoundNonTranslatedCode = false;
        this.fCodeTranslated = false;
    }

    public final StringBuffer getEmptyTranslation() {
        this.reset();
        this.buildResult(true);
        return this.getTranslation();
    }

    private final void buildResult(boolean updateRanges) {
        this.fResult = new StringBuffer(this.fImplicitImports.length() + this.fUserImports.length() + this.fClassHeader.length() + this.fUserDeclarations.length() + this.fServiceHeader.length() + TRY_CATCH_START.length() + this.fUserCode.length() + TRY_CATCH_END.length() + FOOTER.length());
        int javaOffset = 0;
        this.fResult.append(this.fImplicitImports);
        javaOffset += this.fImplicitImports.length();
        if (updateRanges) {
            this.updateRanges(this.fImportRanges, javaOffset);
        }
        this.append(this.fUserImports);
        javaOffset += this.fUserImports.length();
        this.fResult.append(this.fClassHeader);
        javaOffset += this.fClassHeader.length();
        this.fResult.append(String.valueOf(this.fSuperclass) + "{" + ENDL);
        javaOffset += this.fSuperclass.length() + 2;
        ArrayList errorTypeNames = new ArrayList(2);
        if (!this.isTypeFound(this.decodeType(this.fSuperclass), errorTypeNames)) {
            int i = 0;
            while (i < errorTypeNames.size()) {
                IJSPProblem problem = this.createJSPProblem(-1610612736, 0x1000002, MessageFormat.format((String)JSPCoreMessages.JSPDirectiveValidator_8, (Object[])new String[]{errorTypeNames.get(i).toString()}), 0, 1);
                this.fTranslationProblems.add(problem);
                ++i;
            }
        }
        if (updateRanges) {
            this.updateRanges(this.fDeclarationRanges, javaOffset);
        }
        this.append(this.fUserDeclarations);
        javaOffset += this.fUserDeclarations.length();
        if (updateRanges) {
            this.updateRanges(this.fUserELRanges, javaOffset);
        }
        this.append(this.fUserELExpressions);
        javaOffset += this.fUserELExpressions.length();
        this.fResult.append(this.fServiceHeader);
        javaOffset += this.fServiceHeader.length();
        if (this.fIsInASession) {
            String sessionVariableDeclaration = "javax.servlet.http.HttpSession session = " + this.fSession + ENDL;
            this.fResult.append(sessionVariableDeclaration);
            javaOffset += sessionVariableDeclaration.length();
        }
        if (this.fIsErrorPage) {
            this.fResult.append(EXCEPTION);
            javaOffset += EXCEPTION.length();
        }
        this.fResult.append(TRY_CATCH_START);
        javaOffset += TRY_CATCH_START.length();
        if (updateRanges) {
            this.updateRanges(this.fCodeRanges, javaOffset);
        }
        this.append(this.fUserCode);
        javaOffset += this.fUserCode.length();
        this.fResult.append(TRY_CATCH_END);
        javaOffset += TRY_CATCH_END.length();
        this.fResult.append(FOOTER);
        javaOffset += FOOTER.length();
        this.fJava2JspRanges.putAll(this.fImportRanges);
        this.fJava2JspRanges.putAll(this.fDeclarationRanges);
        this.fJava2JspRanges.putAll(this.fCodeRanges);
        this.fJava2JspRanges.putAll(this.fUserELRanges);
    }

    private void updateRanges(HashMap rangeMap, int offsetInJava) {
        Iterator it = rangeMap.keySet().iterator();
        while (it.hasNext()) {
            ((Position)it.next()).offset += offsetInJava;
        }
    }

    public HashMap getJava2JspRanges() {
        return this.fJava2JspRanges;
    }

    public HashMap getJsp2JavaRanges() {
        if (this.fJava2JspRanges == null) {
            return null;
        }
        HashMap flipFlopped = new HashMap();
        Iterator keys = this.fJava2JspRanges.keySet().iterator();
        Object range = null;
        while (keys.hasNext()) {
            range = keys.next();
            flipFlopped.put(this.fJava2JspRanges.get(range), range);
        }
        return flipFlopped;
    }

    public HashMap getJava2JspImportRanges() {
        return this.fImportRanges;
    }

    public HashMap getJava2JspUseBeanRanges() {
        return this.fUseBeanRanges;
    }

    public HashMap getJava2JspIndirectRanges() {
        return this.fIndirectRanges;
    }

    protected void addImports(String value) {
        this.addImports(value, true);
    }

    protected void addImports(String value, boolean addToMap) {
        StringTokenizer st = new StringTokenizer(value, ",", false);
        String tok = "";
        while (st.hasMoreTokens()) {
            tok = st.nextToken();
            this.appendImportToBuffer(tok, (ITextRegionCollection)this.fCurrentNode, addToMap);
        }
    }

    protected void append(StringBuffer buf) {
        if (this.getCursorOwner() == buf) {
            this.fCursorPosition = this.fResult.length() + this.getRelativeOffset();
        }
        this.fResult.append(buf.toString());
    }

    public final StringBuffer getTranslation() {
        if (DEBUG) {
            StringBuffer debugString = new StringBuffer();
            try {
                Iterator it = this.fJava2JspRanges.keySet().iterator();
                while (it.hasNext()) {
                    debugString.append("--------------------------------------------------------------\n");
                    Position java = (Position)it.next();
                    debugString.append("Java range:[" + java.offset + ":" + java.length + "]\n");
                    debugString.append("[" + this.fResult.toString().substring(java.offset, java.offset + java.length) + "]\n");
                    debugString.append("--------------------------------------------------------------\n");
                    debugString.append("|maps to...|\n");
                    debugString.append("==============================================================\n");
                    Position jsp = (Position)this.fJava2JspRanges.get(java);
                    debugString.append("JSP range:[" + jsp.offset + ":" + jsp.length + "]\n");
                    debugString.append("[" + this.fJspTextBuffer.toString().substring(jsp.offset, jsp.offset + jsp.length) + "]\n");
                    debugString.append("==============================================================\n");
                    debugString.append(ENDL);
                    debugString.append(ENDL);
                }
            }
            catch (Exception e) {
                Logger.logException("JSPTranslation error", e);
            }
            Logger.log(201, debugString.toString());
        }
        return this.fResult;
    }

    public List getTranslationProblems() {
        return this.fTranslationProblems;
    }

    public final String getJspText() {
        return this.fJspTextBuffer.toString();
    }

    protected void addTaglibVariables(String tagToAdd, ITextRegionCollection customTag) {
        this.addTaglibVariables(tagToAdd, customTag, -1);
    }

    protected void addTaglibVariables(String tagToAdd, ITextRegionCollection customTag, int index) {
        if (customTag.getFirstRegion().getType().equals("XML_TAG_OPEN")) {
            this.addStartTagVariable(tagToAdd, customTag, index);
        } else if (customTag.getFirstRegion().getType().equals("XML_END_TAG_OPEN")) {
            this.addEndTagVariable(tagToAdd, customTag);
        }
    }

    private void addEndTagVariable(String tagToAdd, ITextRegionCollection customTag) {
        IFile f = this.getFile();
        if (f == null || !f.exists()) {
            return;
        }
        String decl = "";
        RegionTags regionTag = (RegionTags)this.fTagToVariableMap.pop(tagToAdd);
        if (regionTag != null) {
            TaglibVariable[] taglibVars = regionTag.tag.getTagVariables();
            StringBuffer text = new StringBuffer();
            if (regionTag.tag.isIterationTag()) {
                this.doAfterBody(text, regionTag);
            }
            text.append("} // </");
            text.append(tagToAdd);
            text.append(">\n");
            this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
            int i = 0;
            while (i < taglibVars.length) {
                if (taglibVars[i].getScope() == 2) {
                    decl = taglibVars[i].getDeclarationString(this.fContext);
                    this.appendToBuffer(decl, this.fUserCode, true, customTag);
                }
                ++i;
            }
        } else {
            IJSPProblem missingStartTag = this.createJSPProblem(-1610612727, -1610612736, NLS.bind((String)JSPCoreMessages.JSPTranslator_4, (Object)tagToAdd), customTag.getStartOffset(), customTag.getEndOffset());
            this.fTranslationProblems.add(missingStartTag);
        }
    }

    private void addStartTagVariable(String tagToAdd, ITextRegionCollection customTag, int index) {
        IFile f = this.getFile();
        if (f == null || !f.exists()) {
            return;
        }
        TaglibHelper helper = TaglibHelperManager.getInstance().getTaglibHelper(f);
        String decl = "";
        ArrayList problems = new ArrayList();
        CustomTag tag = helper.getCustomTag(tagToAdd, this.getStructuredDocument(), customTag, problems);
        TaglibVariable[] taglibVars = tag.getTagVariables();
        this.fTranslationProblems.addAll(problems);
        int i = 0;
        while (i < taglibVars.length) {
            if (taglibVars[i].getScope() == 1) {
                decl = taglibVars[i].getDeclarationString(this.fContext);
                this.appendToBuffer(decl, this.fUserCode, true, customTag);
            }
            ++i;
        }
        boolean isEmptyTag = false;
        isEmptyTag = index != -1 ? this.isEmptyTag(customTag, index) : this.isEmptyTag(customTag);
        StringBuffer text = new StringBuffer();
        if (!isEmptyTag && tag.isIterationTag() && tag.getTagClassName() != null) {
            text.append("\nwhile(true) ");
        }
        text.append("{ // <");
        text.append(tagToAdd);
        if (isEmptyTag) {
            text.append("/>\n");
        } else {
            text.append(">\n");
        }
        this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
        int i2 = 0;
        while (i2 < taglibVars.length) {
            if (taglibVars[i2].getScope() == 0) {
                decl = taglibVars[i2].getDeclarationString(this.fContext);
                this.appendToBuffer(decl, this.fUserCode, true, customTag);
            }
            ++i2;
        }
        if (isEmptyTag) {
            text = new StringBuffer();
            text.append("} // <");
            text.append(tagToAdd);
            text.append("/>\n");
            this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
            i2 = 0;
            while (i2 < taglibVars.length) {
                if (taglibVars[i2].getScope() == 2) {
                    decl = taglibVars[i2].getDeclarationString(this.fContext);
                    this.appendToBuffer(decl, this.fUserCode, false, customTag);
                }
                ++i2;
            }
        } else {
            this.fTagToVariableMap.push(tagToAdd, new RegionTags(customTag, tag));
        }
    }

    private boolean isEmptyTag(ITextRegionCollection customTag, int index) {
        String type = null;
        ITextRegionList regions = customTag.getRegions();
        ITextRegion nextRegion = regions.get(index);
        int size = customTag.getNumberOfRegions();
        type = nextRegion.getType();
        while (!(index > size || "XML_EMPTY_TAG_CLOSE".equals(type) || "XML_TAG_NAME".equals(type) || "XML_TAG_CLOSE".equals(type))) {
            nextRegion = regions.get(++index);
            type = nextRegion.getType();
        }
        return "XML_EMPTY_TAG_CLOSE".equals(type);
    }

    private boolean isEmptyTag(ITextRegionCollection customTag) {
        ITextRegion lastRegion = customTag.getLastRegion();
        if (customTag instanceof ITextRegionContainer) {
            ITextRegionList regions = customTag.getRegions();
            int size = customTag.getNumberOfRegions() - 1;
            while (!(size <= 0 || "XML_EMPTY_TAG_CLOSE".equals(lastRegion.getType()) || "XML_TAG_NAME".equals(lastRegion.getType()) || "XML_TAG_CLOSE".equals(lastRegion.getType()))) {
                lastRegion = regions.get(--size);
            }
        }
        return "XML_EMPTY_TAG_CLOSE".equals(lastRegion.getType());
    }

    private void addCustomTaglibVariables(String tagToAdd, ITextRegionCollection customTag, ITextRegion prevRegion, int index) {
        if (prevRegion != null && prevRegion.getType().equals("XML_END_TAG_OPEN")) {
            this.addEndTagVariable(tagToAdd, customTag);
        } else if (prevRegion != null && prevRegion.getType().equals("XML_TAG_OPEN")) {
            this.addStartTagVariable(tagToAdd, customTag, index);
        }
    }

    private void doAfterBody(StringBuffer buffer, RegionTags regionTag) {
        buffer.append("\tif ( (new ");
        buffer.append(regionTag.tag.getTagClassName());
        buffer.append("()).doAfterBody() != javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)\n\t\tbreak;\n");
    }

    private IFile getFile() {
        IFile f = null;
        ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)this.getStructuredDocument());
        if (buffer != null) {
            IPath path = buffer.getLocation();
            if (path.segmentCount() > 1) {
                f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            if (f != null && f.isAccessible()) {
                return f;
            }
        }
        return null;
    }

    public List getBlockMarkers() {
        if (this.fBlockMarkers == null) {
            this.fBlockMarkers = new ArrayList();
        }
        return this.fBlockMarkers;
    }

    public void translate() {
        if (this.fTagToVariableMap == null) {
            this.fTagToVariableMap = new StackMap();
        }
        this.fTranslationProblems.clear();
        this.setCurrentNode(new ZeroStructuredDocumentRegion(this.fStructuredDocument, 0));
        this.translatePreludes();
        this.setCurrentNode(this.fStructuredDocument.getFirstStructuredDocumentRegion());
        while (this.getCurrentNode() != null && !this.isCanceled()) {
            this.fCodeTranslated = false;
            if (this.getCurrentNode().getType() == "XML_COMMENT_TEXT" || this.getCurrentNode().getType() == "XML_CDATA_TEXT" || this.getCurrentNode().getType() == "UNDEFINED") {
                this.translateXMLCommentNode(this.getCurrentNode());
            } else {
                this.translateRegionContainer((ITextRegionCollection)this.getCurrentNode(), 0);
            }
            if (!this.fCodeTranslated) {
                this.fFoundNonTranslatedCode = true;
            }
            if (this.getCurrentNode() == null) continue;
            this.advanceNextNode();
        }
        this.writePlaceHolderForNonTranslatedCode();
        this.setCurrentNode(new ZeroStructuredDocumentRegion(this.fStructuredDocument, this.fStructuredDocument.getLength()));
        this.translateCodas();
        Iterator regionAndTaglibVariables = this.fTagToVariableMap.values().iterator();
        while (regionAndTaglibVariables.hasNext()) {
            RegionTags regionTag = (RegionTags)regionAndTaglibVariables.next();
            ITextRegionCollection extraStartRegion = regionTag.region;
            IJSPProblem missingEndTag = this.createJSPProblem(-1610612726, -1610612736, NLS.bind((String)JSPCoreMessages.JSPTranslator_5, (Object)regionTag.tag.getTagName()), extraStartRegion.getStartOffset(), extraStartRegion.getEndOffset());
            this.fTranslationProblems.add(missingEndTag);
            StringBuffer text = new StringBuffer();
            if (regionTag.tag.isIterationTag()) {
                this.doAfterBody(text, regionTag);
            }
            text.append("} // [</");
            text.append(regionTag.tag.getTagName());
            text.append(">]");
            this.appendToBuffer(text.toString(), this.fUserCode, false, (ITextRegionCollection)this.fStructuredDocument.getLastStructuredDocumentRegion());
        }
        this.fTagToVariableMap.clear();
        while (!this.fUseBeansStack.isEmpty()) {
            this.appendToBuffer("}", this.fUserCode, false, (ITextRegionCollection)this.fStructuredDocument.getLastStructuredDocumentRegion());
            ITextRegionCollection extraStartRegion = (ITextRegionCollection)this.fUseBeansStack.pop();
            IJSPProblem missingEndTag = this.createJSPProblem(-1610612724, -1610612736, NLS.bind((String)JSPCoreMessages.JSPTranslator_5, (Object)"jsp:useBean"), extraStartRegion.getStartOffset(), extraStartRegion.getEndOffset());
            this.fTranslationProblems.add(missingEndTag);
        }
        this.buildResult(true);
    }

    /*
     * Exception decompiling
     */
    protected void setDocumentContent(IDocument document, InputStream contentStream, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void init() {
        this.fClassname = "_JSPServlet";
        this.fClassHeader = "public class " + this.fClassname + " extends ";
        this.fImplicitImports = "import javax.servlet.*;\nimport javax.servlet.http.*;\nimport javax.servlet.jsp.*;\n\n";
        this.fServiceHeader = "public void _jspService(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response)\n\t\tthrows java.io.IOException, javax.servlet.ServletException {\njavax.servlet.jsp.PageContext pageContext = JspFactory.getDefaultFactory().getPageContext(this, request, response, null, true, JspWriter.DEFAULT_BUFFER, true);\njavax.servlet.ServletContext application = pageContext.getServletContext();\njavax.servlet.ServletConfig config = pageContext.getServletConfig();\njavax.servlet.jsp.JspWriter out = pageContext.getOut();\nObject page = this;\n";
        this.fSuperclass = "javax.servlet.http.HttpServlet";
        this.fContext = "pageContext";
        this.fSession = String.valueOf(this.fContext) + ".getSession();";
    }

    private boolean isCanceled() {
        return this.fProgressMonitor == null ? false : this.fProgressMonitor.isCanceled();
    }

    private void advanceNextNode() {
        this.setCurrentNode(this.getCurrentNode().getNext());
        if (this.getCurrentNode() != null) {
            this.setSourceReferencePoint();
        }
    }

    private void setSourceReferencePoint() {
        if (this.isJSP(this.getCurrentNode().getFirstRegion().getType())) {
            Iterator it = this.getCurrentNode().getRegions().iterator();
            ITextRegion r = null;
            while (it.hasNext()) {
                r = (ITextRegion)it.next();
                if (r.getType() == "JSP_CONTENT" || r.getType() == "XML_CONTENT" || r.getType() == "JSP_DIRECTIVE_NAME" || r.getType() == "XML_TAG_ATTRIBUTE_VALUE" && this.getCurrentNode().getFullText(r).trim().equals("import")) break;
            }
        }
    }

    protected void translateRegionContainer(ITextRegionCollection container, int JSPType) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext()) {
            region = (ITextRegion)regions.next();
            String type = region.getType();
            if ("BLOCK_TEXT" == type) {
                if (region instanceof ITextRegionContainer) {
                    Iterator regionIterator = ((ITextRegionCollection)region).getRegions().iterator();
                    this.translateJSPNode(region, regionIterator, type, 1);
                } else {
                    StringBuffer fullText = new StringBuffer(containerRegion.getFullText(region));
                    while (regions.hasNext()) {
                        region = (ITextRegion)regions.next();
                        if (region.getType() == "BLOCK_TEXT") {
                            fullText.append(containerRegion.getFullText(region));
                            continue;
                        }
                        type = region.getType();
                        break;
                    }
                    this.decodeScriptBlock(fullText.toString(), containerRegion.getStartOffset());
                }
            }
            if (type != null && this.isJSP(type)) {
                this.translateJSPNode((ITextRegion)containerRegion, regions, type, JSPType);
                continue;
            }
            if (type != null && (type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN")) {
                this.translateXMLNode(containerRegion, regions);
                continue;
            }
            if (type != null && type == "XML_CONTENT" && region instanceof ITextRegionContainer) {
                this.translateXMLContent((ITextRegionContainer)region);
                continue;
            }
            if (type != "JSP_DIRECTIVE_CLOSE" && type != "JSP_CLOSE") continue;
            this.fCodeTranslated = true;
        }
    }

    void decodeScriptBlock(String blockText, int startOfBlock) {
        XMLJSPRegionHelper helper = new XMLJSPRegionHelper(this, false);
        helper.addBlockMarker(new BlockMarker("jsp:scriptlet", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:expression", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:declaration", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:directive.include", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:directive.taglib", null, "JSP_CONTENT", false));
        helper.reset(blockText, startOfBlock);
        helper.forceParse();
    }

    public final String stripCDATA(String text) {
        String resultText = "";
        String CDATA_OPEN = "<![CDATA[";
        String CDATA_CLOSE = "]]>";
        int start = 0;
        int end = text.length();
        while (start < text.length()) {
            if (text.indexOf(CDATA_OPEN, start) > -1) {
                end = text.indexOf(CDATA_OPEN, start);
                resultText = String.valueOf(resultText) + text.substring(start, end);
                start = end + CDATA_OPEN.length();
                continue;
            }
            if (text.indexOf(CDATA_CLOSE, start) > -1) {
                end = text.indexOf(CDATA_CLOSE, start);
                resultText = String.valueOf(resultText) + text.substring(start, end);
                start = end + CDATA_CLOSE.length();
                continue;
            }
            end = text.length();
            resultText = String.valueOf(resultText) + text.substring(start, end);
            break;
        }
        return resultText;
    }

    protected boolean isJSP(String type) {
        return (type == "JSP_DIRECTIVE_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_DECLARATION_OPEN" || type == "JSP_SCRIPTLET_OPEN" || type == "JSP_CONTENT" || type == "JSP_EL_OPEN") && type != "XML_TAG_OPEN";
    }

    protected void translateXMLContent(ITextRegionContainer embeddedContainer) {
        ITextRegionList embeddedRegions = embeddedContainer.getRegions();
        int length = embeddedRegions.size();
        int i = 0;
        while (i < length) {
            ITextRegion delim = embeddedRegions.get(i);
            String type = delim.getType();
            if (i + 1 < length && (type == "JSP_EL_OPEN" || type == "JSP_VBL_OPEN")) {
                ITextRegion region = null;
                int start = delim.getEnd();
                while (++i < length) {
                    region = embeddedRegions.get(i);
                    if (region == null || !this.isELType(region.getType())) break;
                }
                this.fLastJSPType = 4;
                String elText = embeddedContainer.getFullText().substring(start, region != null ? region.getStart() : embeddedContainer.getLength() - 1);
                this.translateEL(elText, embeddedContainer.getText(delim), this.fCurrentNode, embeddedContainer.getEndOffset(delim), elText.length());
            }
            ++i;
        }
    }

    private boolean isELType(String type) {
        return "JSP_EL_CONTENT".equals(type) || "JSP_VBL_CONTENT".equals(type) || "JSP_EL_DQUOTE".equals(type) || "JSP_VBL_DQUOTE".equals(type) || "JSP_EL_QUOTED_CONTENT".equals(type) || "JSP_VBL_QUOTED_CONTENT".equals(type) || "JSP_EL_SQUOTE".equals(type) || "JSP_VBL_SQUOTE".equals(type);
    }

    protected void translateXMLNode(ITextRegionCollection container, Iterator regions) {
        ITextRegion r = null;
        if (regions.hasNext() && ((r = (ITextRegion)regions.next()).getType() == "XML_TAG_NAME" || r.getType() == "JSP_DIRECTIVE_NAME")) {
            StringTokenizer st;
            String fullTagName = container.getText(r);
            if (fullTagName.indexOf(58) > -1 && !fullTagName.startsWith(JSP_PREFIX)) {
                this.addTaglibVariables(fullTagName, container, -1);
            }
            if ((st = new StringTokenizer(fullTagName, ":.", false)).hasMoreTokens() && st.nextToken().equals("jsp")) {
                if (st.hasMoreTokens()) {
                    String jspTagName = st.nextToken();
                    if (jspTagName.equals("scriptlet")) {
                        this.translateXMLJSPContent(8);
                    } else if (jspTagName.equals("expression")) {
                        this.translateXMLJSPContent(4);
                    } else if (jspTagName.equals("declaration")) {
                        this.translateXMLJSPContent(2);
                    } else if (jspTagName.equals("directive")) {
                        if (st.hasMoreTokens()) {
                            String directiveName = st.nextToken();
                            if (directiveName.equals("taglib")) {
                                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                                    String prefix;
                                    r = (ITextRegion)regions.next();
                                    if (!container.getText(r).equals("prefix") || (prefix = this.getAttributeValue(r, regions)) == null) continue;
                                    this.handleTaglib(prefix);
                                }
                                return;
                            }
                            if (directiveName.equals("include")) {
                                String fileLocation = "";
                                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                                    r = (ITextRegion)regions.next();
                                }
                                fileLocation = this.getAttributeValue(r, regions);
                                if (fileLocation != null) {
                                    this.handleIncludeFile(fileLocation);
                                }
                            } else if (directiveName.equals("page")) {
                                if (this.getCurrentNode() != null) {
                                    this.translatePageDirectiveAttributes(regions, this.getCurrentNode());
                                }
                            } else if (directiveName.equals("tag")) {
                                this.translatePageDirectiveAttributes(regions, this.getCurrentNode());
                            } else if (directiveName.equals("variable")) {
                                this.translateVariableDirectiveAttributes(regions);
                            }
                        }
                    } else if (jspTagName.equals("include")) {
                        this.checkAttributeValueContainer(regions, "page");
                    } else if (jspTagName.equals("forward")) {
                        this.checkAttributeValueContainer(regions, "page");
                    } else if (jspTagName.equals("param")) {
                        this.checkAttributeValueContainer(regions, "value");
                    } else if (jspTagName.equals("setProperty")) {
                        this.checkAttributeValueContainer(regions, "value");
                    } else if (jspTagName.equals("useBean")) {
                        this.checkAttributeValueContainer(regions, "name");
                        if (this.getCurrentNode() != null) {
                            this.translateUseBean(container);
                        }
                    }
                }
            } else {
                this.checkAllAttributeValueContainers(container, regions);
            }
        }
    }

    private void checkAllAttributeValueContainers(ITextRegionCollection container, Iterator regions) {
        ITextRegion embedded = null;
        ITextRegion prevRegion = null;
        while (regions.hasNext()) {
            embedded = (ITextRegion)regions.next();
            if (embedded.getType() == "XML_TAG_NAME" || embedded.getType() == "JSP_DIRECTIVE_NAME") {
                String fullTagName = container.getText(embedded);
                if (fullTagName.indexOf(58) > -1 && !fullTagName.startsWith(JSP_PREFIX) && prevRegion != null) {
                    this.addCustomTaglibVariables(fullTagName, container, prevRegion, -1);
                }
            } else if (embedded instanceof ITextRegionContainer) {
                this.translateEmbeddedJSPInAttribute((ITextRegionCollection)((ITextRegionContainer)embedded));
            }
            prevRegion = embedded;
        }
    }

    private void checkAttributeValueContainer(Iterator regions, String attrName) {
        ITextRegion r = null;
        while (regions.hasNext()) {
            r = (ITextRegion)regions.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME" || !this.getCurrentNode().getText(r).equals(attrName)) continue;
            while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null) {
                if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") break;
            }
            if (!(r instanceof ContextRegionContainer)) break;
            this.translateEmbeddedJSPInAttribute((ITextRegionCollection)((ContextRegionContainer)r));
            break;
        }
    }

    private void translateXMLJSPContent(int type) {
        IStructuredDocumentRegion sdr = this.getCurrentNode().getNext();
        int start = sdr.getStartOffset();
        int end = sdr.getEndOffset();
        String sdrText = "";
        StringBuffer regionText = new StringBuffer();
        while (sdr != null && sdr.getType() != "XML_TAG_NAME") {
            if (regionText.length() == 0) {
                start = sdr.getStartOffset();
            }
            sdrText = sdr.getText();
            if (sdr.getType() == "XML_CDATA_TEXT") {
                if (regionText.length() > 0) {
                    this.writeToBuffer(type, regionText.toString(), start, end);
                    regionText = new StringBuffer();
                }
                if (sdrText.startsWith("<![CDATA[") && sdrText.endsWith("]]>")) {
                    start = sdr.getStartOffset() + 9;
                    end = sdr.getEndOffset() - 3;
                    sdrText = sdrText.substring(9, sdrText.length() - 3);
                    this.writeToBuffer(type, sdrText, start, end);
                }
            } else {
                regionText.append(EscapedTextUtil.getUnescapedText(sdrText));
                end = sdr.getEndOffset();
            }
            sdr = sdr.getNext();
        }
        if (regionText.length() > 0) {
            this.writeToBuffer(type, regionText.toString(), start, end);
        }
        this.setCurrentNode(sdr);
        this.setSourceReferencePoint();
    }

    private void writeToBuffer(int type, String content, int jspStart, int jspEnd) {
        switch (type) {
            case 8: {
                this.translateScriptletString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
                break;
            }
            case 4: {
                this.translateExpressionString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
                break;
            }
            case 2: {
                this.translateDeclarationString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
            }
        }
    }

    protected void translateXMLCommentNode(IStructuredDocumentRegion node) {
        Iterator it = node.getRegions().iterator();
        ITextRegion commentRegion = null;
        while (it != null && it.hasNext()) {
            commentRegion = (ITextRegion)it.next();
            if (commentRegion instanceof ITextRegionContainer) {
                this.translateRegionContainer((ITextRegionCollection)((ITextRegionContainer)commentRegion), 1);
                continue;
            }
            if (!"XML_COMMENT_TEXT".equals(commentRegion.getType())) continue;
            this.decodeScriptBlock(node.getFullText(commentRegion), node.getStartOffset(commentRegion));
        }
    }

    protected void translateJSPNode(ITextRegion region, Iterator regions, String type, int JSPType) {
        if (type == "JSP_DIRECTIVE_OPEN" && regions != null) {
            this.translateDirective(regions);
        } else {
            IStructuredDocumentRegion contentRegion = null;
            if (JSPType == 0 && this.setCurrentNode(this.getCurrentNode().getNext()) != null) {
                contentRegion = this.getCurrentNode();
            } else if (JSPType == 1 && region instanceof ITextRegionCollection) {
                this.translateEmbeddedJSPInBlock((ITextRegionCollection)region, regions);
            }
            if (contentRegion != null && contentRegion.getType() != "JSP_CLOSE") {
                if (type == "JSP_EXPRESSION_OPEN") {
                    this.translateExpression((ITextRegionCollection)contentRegion);
                } else if (type == "JSP_DECLARATION_OPEN") {
                    this.translateDeclaration((ITextRegionCollection)contentRegion);
                } else if (type == "JSP_CONTENT" || type == "JSP_SCRIPTLET_OPEN") {
                    this.translateScriptlet((ITextRegionCollection)contentRegion);
                }
            } else {
                this.setCursorOwner(this.getJSPTypeForRegion(region));
            }
        }
    }

    private void translateEL(String elText, String delim, IStructuredDocumentRegion currentNode, int contentStart, int contentLength) {
        IJSPELTranslator translator = this.getELTranslator();
        if (translator != null) {
            List elProblems = translator.translateEL(elText, delim, currentNode, contentStart, contentLength, this.fUserELExpressions, this.fUserELRanges, this.fStructuredDocument);
            this.fTranslationProblems.addAll(elProblems);
        }
    }

    public IJSPELTranslator getELTranslator() {
        if (this.fELTranslator == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JSP_CORE_PLUGIN_ID, EL_TRANSLATOR_EXTENSION_NAME);
            IConfigurationElement bestTranslator = null;
            IExtension[] extensions = extensionPoint.getExtensions();
            int curExtension = 0;
            while (curExtension < extensions.length) {
                IExtension extension = extensions[curExtension];
                IConfigurationElement[] translators = extension.getConfigurationElements();
                int curTranslator = 0;
                while (curTranslator < translators.length) {
                    String idString;
                    IConfigurationElement elTranslator = translators[curTranslator];
                    if (EL_TRANSLATOR_EXTENSION_NAME.equals(elTranslator.getName()) && ((idString = elTranslator.getAttribute("id")) != null && idString.equals(this.fELTranslatorID) || bestTranslator == null && DEFAULT_JSP_EL_TRANSLATOR_ID.equals(idString))) {
                        bestTranslator = elTranslator;
                    }
                    ++curTranslator;
                }
                ++curExtension;
            }
            if (bestTranslator != null) {
                try {
                    Object execExt = bestTranslator.createExecutableExtension("class");
                    if (execExt instanceof IJSPELTranslator) {
                        this.fELTranslator = (IJSPELTranslator)execExt;
                        return this.fELTranslator;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return this.fELTranslator;
    }

    private void translateEmbeddedJSPInBlock(ITextRegionCollection collection, Iterator regions) {
        ITextRegion region = null;
        while (regions.hasNext()) {
            region = (ITextRegion)regions.next();
            if (this.isJSP(region.getType())) break;
            region = null;
        }
        if (region != null) {
            this.translateEmbeddedJSPInAttribute(collection);
            while (regions.hasNext()) {
                regions.next();
            }
        }
    }

    private void translateEmbeddedJSPInAttribute(ITextRegionCollection embeddedContainer) {
        ITextRegionList embeddedRegions = embeddedContainer.getRegions();
        ITextRegion delim = null;
        ITextRegion content = null;
        String type = null;
        String quotetype = null;
        int length = embeddedRegions.size();
        int i = 0;
        while (i < length) {
            String regionType;
            String fullTagName;
            delim = embeddedRegions.get(i);
            type = delim.getType();
            if (type == "XML_TAG_NAME" && (fullTagName = embeddedContainer.getText(delim)).indexOf(58) > -1 && !fullTagName.startsWith(JSP_PREFIX)) {
                ITextRegion prevRegion = null;
                if (i > 0) {
                    prevRegion = embeddedRegions.get(i - 1);
                }
                this.addCustomTaglibVariables(fullTagName, embeddedContainer, prevRegion, i + 1);
            }
            if (type == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || type == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" || type == "JSP_TAG_ATTRIBUTE_VALUE_DQUOTE" || type == "JSP_TAG_ATTRIBUTE_VALUE_SQUOTE") {
                quotetype = type;
            }
            if (i + 1 < embeddedRegions.size() && ((regionType = embeddedRegions.get(i + 1).getType()) == "JSP_CONTENT" || regionType == "JSP_EL_CONTENT")) {
                content = embeddedRegions.get(i + 1);
            }
            if (content != null) {
                boolean inThisRegion;
                int contentStart = embeddedContainer.getStartOffset(content);
                int rStart = this.fCurrentNode.getStartOffset() + contentStart;
                int rEnd = this.fCurrentNode.getStartOffset() + embeddedContainer.getEndOffset(content);
                boolean bl = inThisRegion = rStart <= this.fSourcePosition && rEnd >= this.fSourcePosition;
                if (type == "JSP_EXPRESSION_OPEN") {
                    this.fLastJSPType = 4;
                    this.translateExpressionString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), quotetype);
                } else if (type == "JSP_SCRIPTLET_OPEN") {
                    this.fLastJSPType = 8;
                    this.translateScriptletString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), false);
                } else if (type == "JSP_DECLARATION_OPEN") {
                    this.fLastJSPType = 2;
                    this.translateDeclarationString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), false);
                } else if (type == "JSP_EL_OPEN" || type == "JSP_VBL_OPEN") {
                    this.fLastJSPType = 4;
                    ITextRegion region = null;
                    int start = delim.getEnd();
                    while (++i < length) {
                        region = embeddedRegions.get(i);
                        if (region == null || !this.isELType(region.getType())) break;
                    }
                    String elText = embeddedContainer.getFullText().substring(start, region != null ? region.getStart() : embeddedContainer.getLength() - 1);
                    this.translateEL(elText, embeddedContainer.getText(delim), this.fCurrentNode, embeddedContainer.getEndOffset(delim), elText.length());
                }
                if (inThisRegion) {
                    this.setCursorOwner(this.fLastJSPType);
                    int currentBufferLength = this.getCursorOwner().length();
                    this.setRelativeOffset(this.fSourcePosition - contentStart + currentBufferLength);
                    if (this.fLastJSPType == 4) {
                        this.setCursorInExpression(true);
                        this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                    }
                }
            } else {
                type = null;
            }
            ++i;
        }
    }

    private int getJSPTypeForRegion(ITextRegion region) {
        String regionType = region.getType();
        int type = 8;
        if (regionType == "JSP_SCRIPTLET_OPEN") {
            type = 8;
        } else if (regionType == "JSP_EXPRESSION_OPEN") {
            type = 4;
        } else if (regionType == "JSP_DECLARATION_OPEN") {
            type = 2;
        } else if (regionType == "JSP_CONTENT") {
            type = this.fLastJSPType;
        }
        this.fLastJSPType = type;
        return type;
    }

    protected void translateDirective(Iterator regions) {
        ITextRegion r = null;
        String attrValue = "";
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "JSP_DIRECTIVE_NAME") {
            String regionText = this.getCurrentNode().getText(r);
            if (regionText.equals("taglib")) {
                this.handleTaglib();
                return;
            }
            if (regionText.equals("include")) {
                String fileLocation = "";
                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                    r = (ITextRegion)regions.next();
                }
                fileLocation = this.getAttributeValue(r, regions);
                if (attrValue == null) continue;
                this.handleIncludeFile(fileLocation);
                continue;
            }
            if (regionText.equals("page")) {
                this.translatePageDirectiveAttributes(regions, this.getCurrentNode());
                continue;
            }
            if (regionText.equals("tag")) {
                this.translatePageDirectiveAttributes(regions, this.getCurrentNode());
                continue;
            }
            if (regionText.equals("variable")) {
                this.translateVariableDirectiveAttributes(regions);
                continue;
            }
            if (!regionText.equals("attribute")) continue;
            this.translateAttributeDirectiveAttributes(regions);
        }
    }

    private void translateAttributeDirectiveAttributes(Iterator regions) {
        ITextRegion r = null;
        String varType = "java.lang.String";
        String varName = null;
        String description = "";
        boolean isFragment = false;
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() != "JSP_CLOSE") {
            String attrValue = null;
            String attrName = null;
            if (!r.getType().equals("XML_TAG_ATTRIBUTE_NAME") || (attrName = this.getCurrentNode().getText(r).trim()).length() <= 0) continue;
            if (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValue = StringUtils.strip((String)this.getCurrentNode().getText(r));
            }
            if (attrName.equals("type")) {
                varType = attrValue;
                continue;
            }
            if (attrName.equals("fragment")) {
                isFragment = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.equals("name")) {
                varName = attrValue;
                continue;
            }
            if (!attrName.equals("description")) continue;
            description = attrValue;
        }
        if (varName != null) {
            if (isFragment) {
                varType = "javax.servlet.jsp.tagext.JspFragment";
            }
            String declaration = new TaglibVariable(varType, varName, "", description).getDeclarationString(true, this.fContext, 1);
            this.appendToBuffer(declaration, this.fUserDeclarations, false, (ITextRegionCollection)this.fCurrentNode);
        }
    }

    private void translateVariableDirectiveAttributes(Iterator regions) {
    }

    protected void handleTaglib() {
        TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
        if (mgr != null) {
            List trackers = mgr.getCMDocumentTrackers(this.getCurrentNode().getEnd());
            Iterator it = trackers.iterator();
            CMDocumentTracker tracker = null;
            Iterator taglibRegions = null;
            IStructuredDocumentRegion sdRegion = null;
            ITextRegion r = null;
            while (it.hasNext()) {
                tracker = (CMDocumentTracker)it.next();
                sdRegion = tracker.getStructuredDocumentRegion();
                if (sdRegion == null || sdRegion.isDeleted()) continue;
                taglibRegions = sdRegion.getRegions().iterator();
                while (!sdRegion.isDeleted() && taglibRegions.hasNext()) {
                    String text;
                    r = (ITextRegion)taglibRegions.next();
                    if (!r.getType().equals("JSP_DIRECTIVE_NAME") || !"taglib".equals(text = sdRegion.getText(r)) && !"jsp:directive.taglib".equals(text)) continue;
                    this.addBlockMarkers(tracker.getDocument());
                }
            }
        }
    }

    private void handleTaglib(String prefix) {
        TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
        if (mgr != null) {
            List trackers = mgr.getCMDocumentTrackers(this.getCurrentNode().getEnd());
            Iterator it = trackers.iterator();
            CMDocumentTracker tracker = null;
            while (it.hasNext()) {
                tracker = (CMDocumentTracker)it.next();
                this.addBlockMarkers(String.valueOf(prefix) + ":", tracker.getDocument());
            }
        }
    }

    protected void addBlockMarkers(CMDocument doc) {
        if (doc.getElements().getLength() > 0) {
            Iterator elements = doc.getElements().iterator();
            CMNode node = null;
            while (elements.hasNext()) {
                node = (CMNode)elements.next();
                this.getBlockMarkers().add(new BlockMarker(node.getNodeName(), null, "JSP_CONTENT", true));
            }
        }
    }

    protected void addBlockMarkers(String prefix, CMDocument doc) {
        if (doc.getElements().getLength() > 0) {
            Iterator elements = doc.getElements().iterator();
            CMNode node = null;
            while (elements.hasNext()) {
                node = (CMNode)elements.next();
                if (node instanceof TLDElementDeclaration && ((TLDElementDeclaration)node).getBodycontent().equals("tagdependent")) {
                    this.getBlockMarkers().add(new BlockMarker(String.valueOf(prefix) + node.getNodeName(), null, "BLOCK_TEXT", true));
                    continue;
                }
                this.getBlockMarkers().add(new BlockMarker(String.valueOf(prefix) + node.getNodeName(), null, "JSP_CONTENT", true));
            }
        }
    }

    protected String getAttributeValue(ITextRegion r, Iterator remainingRegions) {
        if (r.getType().equals("XML_TAG_ATTRIBUTE_NAME") && remainingRegions.hasNext() && (r = (ITextRegion)remainingRegions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && remainingRegions.hasNext() && (r = (ITextRegion)remainingRegions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
            return StringUtils.stripQuotes((String)this.getCurrentNode().getText(r));
        }
        return null;
    }

    protected void translatePageDirectiveAttributes(Iterator regions, IStructuredDocumentRegion documentRegion) {
        ITextRegion r = null;
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() != "JSP_CLOSE") {
            String attrValue = null;
            String attrName = null;
            if (!r.getType().equals("XML_TAG_ATTRIBUTE_NAME") || (attrName = documentRegion.getText(r).trim()).length() <= 0) continue;
            if (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValue = StringUtils.strip((String)documentRegion.getText(r));
            }
            this.setDirectiveAttribute(attrName, attrValue);
        }
    }

    protected void setDirectiveAttribute(String attrName, String attrValue) {
        if (attrValue == null) {
            return;
        }
        if (attrName.equals("extends")) {
            this.fSuperclass = attrValue;
        } else if (attrName.equals("import")) {
            this.addImports(attrValue);
        } else if (attrName.equals("session")) {
            this.fIsInASession = Boolean.valueOf(attrValue);
        } else if (!attrName.equals("buffer") && !attrName.equals("autoFlush") && !attrName.equals("isThreadSafe") && attrName.equals("isErrorPage")) {
            this.fIsErrorPage = Boolean.valueOf(attrValue);
        }
    }

    protected void handleIncludeFile(String filename) {
        IPath modelPath;
        IPath basePath;
        if (filename != null && this.fProcessIncludes && (basePath = (modelPath = this.getModelPath())) != null) {
            if (!this.getIncludes().isEmpty()) {
                basePath = new Path((String)this.getIncludes().peek());
            }
            String filePathString = FacetModuleCoreSupport.resolve(basePath, filename).toString();
            this.fIncludedPaths.add(filePathString);
            if (!this.getIncludes().contains(filePathString) && !filePathString.equals(modelPath.toString())) {
                this.getIncludes().push(filePathString);
                JSPIncludeRegionHelper helper = new JSPIncludeRegionHelper(this, true);
                helper.parse(filePathString);
                this.getIncludes().pop();
            }
        }
    }

    private Stack getIncludes() {
        if (this.fIncludes == null) {
            this.fIncludes = new Stack();
        }
        return this.fIncludes;
    }

    public Collection getIncludedPaths() {
        return this.fIncludedPaths;
    }

    protected void translateExpressionString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, embeddedContainer, true);
        this.appendToBuffer(newText, this.fUserCode, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect, true);
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, embeddedContainer);
    }

    protected void translateExpressionString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, String quotetype) {
        if (quotetype == null || quotetype == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || quotetype == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE") {
            this.translateExpressionString(newText, embeddedContainer, jspPositionStart, jspPositionLength, false);
            return;
        }
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, embeddedContainer, true);
        int length = newText.length();
        int runStart = 0;
        int i = 0;
        while (i < length) {
            char c = newText.charAt(i);
            if (c == '\\') {
                int runLength = i - runStart;
                if (runLength > 0) {
                    this.appendToBuffer(newText.substring(runStart, i), this.fUserCode, true, embeddedContainer, jspPositionStart, runLength, false, true);
                    jspPositionStart += runLength + 1;
                    jspPositionLength -= runLength + 1;
                }
                runStart = ++i;
                if (i >= length) break;
                c = newText.charAt(i);
            }
            ++i;
        }
        int runLength = i - runStart;
        if (runLength > 0) {
            this.appendToBuffer(newText.substring(runStart, i), this.fUserCode, true, embeddedContainer, jspPositionStart, runLength, false, false);
        }
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, embeddedContainer);
    }

    protected void translateDeclarationString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, this.fUserDeclarations, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect);
        this.appendToBuffer(ENDL, this.fUserDeclarations, false, embeddedContainer);
    }

    protected void translateScriptletString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, this.fUserCode, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect);
    }

    protected void translateExpression(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 4);
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, region, true);
        this.appendToBuffer(newText, this.fUserCode, true, region, true);
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, region);
    }

    protected void translateDeclaration(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 2);
        this.appendToBuffer(newText, this.fUserDeclarations, true, region);
        this.appendToBuffer(ENDL, this.fUserDeclarations, false, region);
    }

    protected void translateScriptlet(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 8);
        this.appendToBuffer(newText, this.fUserCode, true, region);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion) {
        int start = 0;
        int length = 0;
        if (jspReferenceRegion != null) {
            start = jspReferenceRegion.getStartOffset();
            length = jspReferenceRegion.getLength();
        }
        this.appendToBuffer(newText, buffer, addToMap, jspReferenceRegion, start, length, false);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion, boolean nonl) {
        int start = 0;
        int length = 0;
        if (jspReferenceRegion != null) {
            start = jspReferenceRegion.getStartOffset();
            length = jspReferenceRegion.getLength();
        }
        this.appendToBuffer(newText, buffer, addToMap, jspReferenceRegion, start, length, false, nonl);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, buffer, addToMap, jspReferenceRegion, jspPositionStart, jspPositionLength, isIndirect, false);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion, int jspPositionStart, int jspPositionLength, boolean isIndirect, boolean nonl) {
        int origNewTextLength = newText.length();
        if (jspReferenceRegion == null) {
            return;
        }
        if (!nonl && !newText.endsWith(ENDL)) {
            newText = String.valueOf(newText) + ENDL;
        }
        this.writePlaceHolderForNonTranslatedCode();
        this.fCodeTranslated = true;
        if (buffer == this.fUserCode) {
            buffer.append(newText);
            if (addToMap) {
                if (this.isUsebeanTag(jspReferenceRegion)) {
                    try {
                        this.appendUseBeanToBuffer(newText, jspReferenceRegion, isIndirect);
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                } else {
                    Position javaRange = new Position(this.fOffsetInUserCode, origNewTextLength);
                    Position jspRange = new Position(jspPositionStart, jspPositionLength);
                    this.fCodeRanges.put(javaRange, jspRange);
                    if (isIndirect) {
                        this.fIndirectRanges.put(javaRange, jspRange);
                    }
                }
            }
            this.fOffsetInUserCode += newText.length();
        } else if (buffer == this.fUserDeclarations) {
            buffer.append(newText);
            if (addToMap) {
                Position javaRange = new Position(this.fOffsetInUserDeclarations, newText.length());
                Position jspRange = new Position(jspPositionStart, jspPositionLength);
                this.fDeclarationRanges.put(javaRange, jspRange);
                if (isIndirect) {
                    this.fIndirectRanges.put(javaRange, jspRange);
                }
            }
            this.fOffsetInUserDeclarations += newText.length();
        }
    }

    private boolean isUsebeanTag(ITextRegionCollection jspReferenceRegion) {
        ITextRegionList regions = jspReferenceRegion.getRegions();
        ITextRegion r = null;
        boolean isUseBean = false;
        int i = 0;
        while (i < regions.size()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                if (r.getTextLength() != 11 || !jspReferenceRegion.getText(r).equals("jsp:useBean")) break;
                isUseBean = true;
                break;
            }
            ++i;
        }
        return isUseBean;
    }

    private void appendImportToBuffer(String importName, ITextRegionCollection jspReferenceRegion, boolean addToMap) {
        String javaImportString = "import " + importName + ";" + ENDL;
        this.fUserImports.append(javaImportString);
        if (addToMap) {
            this.addImportToMap(importName, jspReferenceRegion);
        }
        this.fOffsetInUserImports += javaImportString.length();
    }

    private void addImportToMap(String importName, ITextRegionCollection jspReferenceRegion) {
        Position javaRange = new Position(this.fOffsetInUserImports + 7, 1);
        Position jspRange = new Position(jspReferenceRegion.getStart(), jspReferenceRegion.getLength());
        ITextRegionList regions = jspReferenceRegion.getRegions();
        int size = regions.size();
        int start = -1;
        int length = -1;
        ITextRegion r = null;
        int i = 0;
        while (i < size) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && jspReferenceRegion.getText(r).trim().equals("import") && size > i + 2 && (r = regions.get(i + 2)).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                String jspImportText = jspReferenceRegion.getText(r);
                start = jspImportText.indexOf(importName);
                length = importName.length();
                if (start == -1 || length < 1) break;
                jspRange.setOffset(jspReferenceRegion.getStartOffset(r) + start);
                jspRange.setLength(length);
                javaRange.setLength(length);
                break;
            }
            ++i;
        }
        if (start != -1 && length > 1) {
            this.fImportRanges.put(javaRange, jspRange);
        }
    }

    private void appendUseBeanToBuffer(String newText, ITextRegionCollection jspReferenceRegion, boolean isIndirect) throws Exception {
        StringTokenizer st = new StringTokenizer(newText, " ", false);
        int i = 0;
        String[] parsedJava = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            parsedJava[i++] = st.nextToken();
        }
        String type = parsedJava[0] != null ? parsedJava[0] : "";
        String id = parsedJava[1] != null ? parsedJava[1] : "";
        String className = parsedJava.length > 4 ? parsedJava[4] : "";
        Position javaTypeRange = new Position(this.fOffsetInUserCode, type.length());
        Position javaIdRange = new Position(this.fOffsetInUserCode + type.length() + 1, id.length());
        Position javaClassRange = new Position(this.fOffsetInUserCode + type.length() + 1 + id.length() + 7, 0);
        int parenPos = -1;
        if (className.length() >= 4 && (parenPos = className.indexOf(40)) >= 0) {
            int classNameLength = className.substring(0, parenPos).length();
            javaClassRange = new Position(this.fOffsetInUserCode + type.length() + 1 + id.length() + 7, classNameLength);
        }
        ITextRegionList regions = jspReferenceRegion.getRegions();
        ITextRegion r = null;
        String attrName = "";
        String attrValue = "";
        int quoteOffset = 0;
        Position jspTypeRange = null;
        Position jspIdRange = null;
        Position jspClassRange = null;
        int j = 0;
        while (j < regions.size()) {
            r = regions.get(j);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = jspReferenceRegion.getText(r);
                if (regions.size() > j + 2 && regions.get(j + 2).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    r = regions.get(j + 2);
                    attrValue = jspReferenceRegion.getText(r);
                    int n = quoteOffset = attrValue.startsWith("\"") || attrValue.startsWith("'") ? 1 : 0;
                    if (attrName.equals("type")) {
                        jspTypeRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    } else if (attrName.equals("id")) {
                        jspIdRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    } else if (attrName.equals("class")) {
                        jspClassRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    }
                }
            }
            ++j;
        }
        if (!type.equals("") && jspTypeRange != null) {
            this.fCodeRanges.put(javaTypeRange, jspTypeRange);
            this.fUseBeanRanges.put(javaTypeRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaTypeRange, jspTypeRange);
            }
        }
        if (!id.equals("") && jspIdRange != null) {
            this.fCodeRanges.put(javaIdRange, jspIdRange);
            this.fUseBeanRanges.put(javaIdRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaIdRange, jspTypeRange);
            }
        }
        if (!className.equals("") && jspClassRange != null) {
            this.fCodeRanges.put(javaClassRange, jspClassRange);
            this.fUseBeanRanges.put(javaClassRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaClassRange, jspTypeRange);
            }
        }
    }

    protected void setCursorOwner(int JSPType) {
        switch (JSPType) {
            case 2: {
                this.setCursorOwner(this.fUserDeclarations);
                break;
            }
            case 4: 
            case 8: {
                this.setCursorOwner(this.fUserCode);
                break;
            }
            default: {
                this.setCursorOwner(this.fUserCode);
            }
        }
    }

    protected String getUnescapedRegionText(ITextRegionCollection stRegion, int JSPType) {
        StringBuffer buffer = new StringBuffer();
        int start = stRegion.getStartOffset();
        int end = stRegion.getEndOffset();
        if (stRegion instanceof ITextRegionContainer && stRegion.getType() == "BLOCK_TEXT" && stRegion.getRegions() != null && stRegion.getRegions().size() > 1) {
            ITextRegion jspContent = stRegion.getRegions().get(1);
            start = stRegion.getStartOffset(jspContent);
            end = stRegion.getEndOffset(jspContent);
        }
        int CDATAOffset = 0;
        int bufferSize = 0;
        if (stRegion.getType() == "JSP_CONTENT" || stRegion.getType() == "BLOCK_TEXT" || stRegion.getType() == "XML_TAG_NAME") {
            boolean bl = this.fInCodeRegion = start <= this.fSourcePosition && this.fSourcePosition <= end;
            if (this.fInCodeRegion) {
                this.setCursorOwner(JSPType);
                this.setRelativeOffset(this.fSourcePosition - start + this.getCursorOwner().length());
                if (JSPType == 4) {
                    this.setCursorInExpression(true);
                    this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                }
            }
            ITextRegion jspContent = null;
            if (stRegion.getRegions() != null && stRegion.getRegions().size() > 1) {
                jspContent = stRegion.getRegions().get(1);
            }
            return jspContent != null ? stRegion.getFullText(jspContent) : stRegion.getFullText();
        }
        if (stRegion.getType() == "JSP_CLOSE") {
            this.setCursorOwner(JSPType);
        }
        while (this.getCurrentNode() != null && this.getCurrentNode().getType() != "XML_TAG_NAME" && this.getCurrentNode().getType() != "JSP_CLOSE") {
            start = this.getCurrentNode().getStartOffset();
            end = this.getCurrentNode().getEndOffset();
            bufferSize = buffer.length();
            CDATAOffset = this.unescapeRegion((ITextRegion)this.getCurrentNode(), buffer);
            boolean bl = this.fInCodeRegion = start <= this.fSourcePosition && this.fSourcePosition <= end;
            if (this.fInCodeRegion) {
                this.setCursorOwner(JSPType);
                this.setRelativeOffset(this.fSourcePosition - this.getCurrentNode().getStartOffset() + this.getCursorOwner().length() - CDATAOffset + bufferSize);
                if (JSPType == 4) {
                    this.setCursorInExpression(true);
                    this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                }
            }
            if (this.getCurrentNode() == null) continue;
            this.advanceNextNode();
        }
        return buffer.toString();
    }

    protected int unescapeRegion(ITextRegion r, StringBuffer sb) {
        String s = "";
        int lengthBefore = 0;
        int lengthAfter = 0;
        int cdata_tags_length = 0;
        if (r != null && (r.getType() == "XML_CONTENT" || r.getType() == "XML_ENTITY_REFERENCE")) {
            lengthBefore = this.getCurrentNode() != r ? this.getCurrentNode().getFullText(r).length() : this.getCurrentNode().getFullText().length();
            s = EscapedTextUtil.getUnescapedText(this.getCurrentNode(), r);
            lengthAfter = s.length();
            sb.append(s);
        } else if (r != null && r.getType() == "XML_CDATA_TEXT" && r instanceof ITextRegionContainer) {
            Iterator it = ((ITextRegionContainer)r).getRegions().iterator();
            ITextRegion temp = null;
            while (it.hasNext()) {
                temp = (ITextRegion)it.next();
                if (temp instanceof ITextRegionContainer || temp.getType() == "XML_CDATA_TEXT") {
                    sb.append(this.getCurrentNode().getFullText(temp));
                    continue;
                }
                if (temp.getType() != "XML_CDATA_OPEN" && temp.getType() != "XML_CDATA_CLOSE") continue;
                cdata_tags_length += temp.getLength();
            }
        }
        return lengthBefore - lengthAfter + cdata_tags_length;
    }

    protected void translateUseBean(ITextRegionCollection container) {
        ITextRegion r = null;
        String attrName = null;
        String attrValue = null;
        String id = null;
        ITextRegion idRegion = null;
        String type = null;
        ITextRegion typeRegion = null;
        String className = null;
        ITextRegion classnameRegion = null;
        String beanName = null;
        ITextRegion beanNameRegion = null;
        if ("XML_END_TAG_OPEN".equals(container.getFirstRegion().getType())) {
            if (!this.fUseBeansStack.isEmpty()) {
                this.fUseBeansStack.pop();
                this.appendToBuffer("}", this.fUserCode, false, (ITextRegionCollection)this.fCurrentNode);
            } else {
                ITextRegionCollection extraEndRegion = container;
                IJSPProblem missingStartTag = this.createJSPProblem(-1610612725, -1610612736, NLS.bind((String)JSPCoreMessages.JSPTranslator_4, (Object)"jsp:useBean"), extraEndRegion.getStartOffset(), extraEndRegion.getEndOffset());
                this.fTranslationProblems.add(missingStartTag);
            }
            return;
        }
        Iterator regions = container.getRegions().iterator();
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && (r.getType() != "XML_TAG_CLOSE" || r.getType() != "XML_EMPTY_TAG_CLOSE")) {
            attrValue = null;
            attrName = null;
            if (r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                attrName = container.getText(r).trim();
                if (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    attrValue = StringUtils.stripQuotes((String)container.getText(r));
                }
            }
            if (attrName == null || attrValue == null) continue;
            if (attrName.equals("id")) {
                id = attrValue;
                idRegion = r;
                continue;
            }
            if (attrName.equals("class")) {
                className = attrValue;
                classnameRegion = r;
                continue;
            }
            if (attrName.equals("type")) {
                type = attrValue;
                typeRegion = r;
                continue;
            }
            if (!attrName.equals("beanName")) continue;
            beanName = attrValue;
            beanNameRegion = r;
        }
        if (id != null) {
            IJSPProblem problem;
            if (!this.isValidJavaIdentifier(id) && idRegion != null) {
                problem = this.createJSPProblem(-1610612730, 1610612971, MessageFormat.format((String)JSPCoreMessages.JSPTranslator_0, (Object[])new String[]{id}), container.getStartOffset(idRegion), container.getTextEndOffset(idRegion) - 1);
                this.fTranslationProblems.add(problem);
            }
            if ((type == null && className == null || type == null && beanName != null) && idRegion != null) {
                problem = this.createJSPProblem(-1610612729, 0x1000002, NLS.bind((String)JSPCoreMessages.JSPTranslator_3, (Object[])new String[]{id}), container.getStartOffset(idRegion), container.getTextEndOffset(idRegion) - 1);
                this.fTranslationProblems.add(problem);
            }
            if (className != null && beanName != null && beanNameRegion != null) {
                ITextRegion nameRegion = container.getRegions().get(1);
                IJSPProblem problem2 = this.createJSPProblem(-1610612728, 0x1000004, JSPCoreMessages.JSPTranslator_2, container.getStartOffset(nameRegion), container.getTextEndOffset(nameRegion) - 1);
                this.fTranslationProblems.add(problem2);
            }
            if (type != null || className != null) {
                if (className != null) {
                    className = this.decodeType(className);
                }
                if (type == null) {
                    type = className;
                    typeRegion = classnameRegion;
                } else {
                    type = this.decodeType(type);
                }
                ArrayList errorTypeNames = new ArrayList(2);
                if (!this.isTypeFound(type, errorTypeNames)) {
                    int i = 0;
                    while (i < errorTypeNames.size()) {
                        IJSPProblem problem3 = this.createJSPProblem(-1610612736, 0x1000002, MessageFormat.format((String)JSPCoreMessages.JSPTranslator_1, (Object[])new String[]{errorTypeNames.get(i).toString()}), container.getStartOffset(typeRegion), container.getTextEndOffset(typeRegion) - 1);
                        this.fTranslationProblems.add(problem3);
                        ++i;
                    }
                } else {
                    String prefix = String.valueOf(type) + " " + id + " = ";
                    String suffix = "null;\n";
                    if (className != null) {
                        suffix = "new " + className + "();" + ENDL;
                    } else if (beanName != null) {
                        suffix = "(" + type + ") java.beans.Beans.instantiate(getClass().getClassLoader(), \"" + beanName + "\");" + ENDL;
                    }
                    this.appendToBuffer(String.valueOf(prefix) + suffix, this.fUserCode, true, (ITextRegionCollection)this.fCurrentNode);
                }
            }
        }
        if (!"XML_EMPTY_TAG_CLOSE".equals(container.getLastRegion().getType())) {
            this.fUseBeansStack.push(container);
            this.appendToBuffer("{", this.fUserCode, false, (ITextRegionCollection)this.fCurrentNode);
        }
    }

    private String decodeType(String type) {
        int length = type.length();
        StringBuffer buffer = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            String code;
            boolean isGt;
            char c = type.charAt(i);
            if (c == '&' && length > i + 3 && ((isGt = "gt;".equals(code = type.substring(i + 1, i + 4))) || "lt;".equals(code))) {
                i += 3;
                buffer.append(isGt ? (char)'>' : '<');
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private boolean isTypeFound(String rawTypeValue, List errorTypeNames) {
        IFile file;
        Object object = this.getStructuredDocument() != null ? this.getFile() : (file = this.fSavedModelPath != null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.fSavedModelPath) : null);
        if (file == null) {
            return true;
        }
        IProject project = file.getProject();
        IJavaProject p = JavaCore.create((IProject)project);
        if (p.exists()) {
            ArrayList<String> types = new ArrayList<String>();
            if (rawTypeValue.indexOf(60) > 0) {
                try {
                    StringTokenizer toker = new StringTokenizer(rawTypeValue);
                    String token = toker.nextToken("<,>/\"");
                    while (token != null) {
                        types.add(token);
                        token = toker.nextToken("<,>/\"");
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    return true;
                }
            } else {
                types.add(rawTypeValue);
            }
            int i = 0;
            while (i < types.size()) {
                String typeName = types.get(i).toString();
                if (typeName.indexOf(91) > 0 && typeName.indexOf(93) > typeName.indexOf(91)) {
                    typeName = typeName.substring(0, typeName.indexOf(91));
                }
                if (typeName.indexOf("extends") > 0) {
                    typeName = StringUtils.strip((String)typeName.substring(typeName.indexOf("extends")));
                }
                this.addNameToListIfTypeNotFound(p, typeName, errorTypeNames);
                ++i;
            }
        }
        return errorTypeNames.isEmpty();
    }

    private void addNameToListIfTypeNotFound(IJavaProject p, String typeName, List collectedNamesNotFound) {
        try {
            if (typeName != null) {
                IType type = p.findType(typeName);
                if (type == null || !type.exists()) {
                    collectedNamesNotFound.add(typeName);
                } else {
                    IResource iResource = type.getResource();
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private boolean isValidJavaIdentifier(String id) {
        char[] idChars = id.toCharArray();
        if (idChars.length < 1) {
            return false;
        }
        boolean isValid = Character.isJavaIdentifierStart(idChars[0]);
        int i = 1;
        while (i < idChars.length) {
            isValid = isValid && Character.isJavaIdentifierPart(idChars[i]);
            ++i;
        }
        return isValid;
    }

    public final int getCursorPosition() {
        return this.fCursorPosition;
    }

    protected boolean isCursorInExpression() {
        return this.fCursorInExpression;
    }

    protected void setCursorInExpression(boolean in) {
        this.fCursorInExpression = in;
    }

    public final void setSourceCursor(int i) {
        this.fSourcePosition = i;
    }

    public final int getSourcePosition() {
        return this.fSourcePosition;
    }

    public final TLDCMDocumentManager getTLDCMDocumentManager() {
        return TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
    }

    public final void setRelativeOffset(int relativeOffset) {
        this.fRelativeOffset = relativeOffset;
    }

    public final int getRelativeOffset() {
        return this.fRelativeOffset;
    }

    private void setCursorOwner(StringBuffer cursorOwner) {
        this.fCursorOwner = cursorOwner;
    }

    public final StringBuffer getCursorOwner() {
        return this.fCursorOwner;
    }

    private IStructuredDocumentRegion setCurrentNode(IStructuredDocumentRegion currentNode) {
        this.fCurrentNode = currentNode;
        return this.fCurrentNode;
    }

    public final IStructuredDocumentRegion getCurrentNode() {
        return this.fCurrentNode;
    }

    public IStructuredDocument getStructuredDocument() {
        return this.fStructuredDocument;
    }

    private IPath getModelPath() {
        IPath path = null;
        ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)this.getStructuredDocument());
        if (buffer != null) {
            path = buffer.getLocation();
        }
        return path;
    }

    private void translateCodas() {
        this.fProcessIncludes = false;
        IPath modelpath = this.getModelPath();
        if (modelpath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(modelpath);
            int j = 0;
            while (j < propertyGroups.length) {
                IPath[] codas = propertyGroups[j].getIncludeCoda();
                int i = 0;
                while (i < codas.length) {
                    if (!this.getIncludes().contains(codas[i].toString()) && !codas[i].equals((Object)modelpath)) {
                        this.getIncludes().push(codas[i]);
                        JSPIncludeRegionHelper helper = new JSPIncludeRegionHelper(this, true);
                        helper.parse(codas[i].toString());
                        this.getIncludes().pop();
                    }
                    ++i;
                }
                ++j;
            }
        }
        this.fProcessIncludes = true;
    }

    private void translatePreludes() {
        this.fProcessIncludes = false;
        IPath modelpath = this.getModelPath();
        if (modelpath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(modelpath);
            int j = 0;
            while (j < propertyGroups.length) {
                IPath[] preludes = propertyGroups[j].getIncludePrelude();
                int i = 0;
                while (i < preludes.length) {
                    if (!this.getIncludes().contains(preludes[i].toString()) && !preludes[i].equals((Object)modelpath)) {
                        this.getIncludes().push(preludes[i]);
                        JSPIncludeRegionHelper helper = new JSPIncludeRegionHelper(this, true);
                        helper.parse(preludes[i].toString());
                        this.getIncludes().pop();
                    }
                    ++i;
                }
                ++j;
            }
        }
        this.fProcessIncludes = true;
    }

    private void writePlaceHolderForNonTranslatedCode() {
        if (this.fFoundNonTranslatedCode) {
            String text = "{out.print(\"\");} //markup\n";
            this.fUserCode.append(text);
            this.fOffsetInUserCode += text.length();
            this.fFoundNonTranslatedCode = false;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        JSPTranslator.writeString(out, this.fClassHeader);
        JSPTranslator.writeString(out, this.fClassname);
        JSPTranslator.writeString(out, this.fSuperclass);
        JSPTranslator.writeString(out, this.fImplicitImports);
        JSPTranslator.writeString(out, this.fServiceHeader);
        JSPTranslator.writeBuffer(out, this.fUserImports);
        out.writeInt(this.fSourcePosition);
        out.writeInt(this.fRelativeOffset);
        out.writeInt(this.fCursorPosition);
        out.writeBoolean(this.fIsErrorPage);
        out.writeBoolean(this.fCursorInExpression);
        out.writeBoolean(this.fIsInASession);
        JSPTranslator.writeBuffer(out, this.fUserCode);
        JSPTranslator.writeBuffer(out, this.fUserELExpressions);
        JSPTranslator.writeBuffer(out, this.fUserDeclarations);
        JSPTranslator.writeBuffer(out, this.fCursorOwner);
        out.writeBoolean(this.fInCodeRegion);
        out.writeBoolean(this.fProcessIncludes);
        out.writeInt(this.fOffsetInUserImports);
        out.writeInt(this.fOffsetInUserDeclarations);
        out.writeInt(this.fOffsetInUserCode);
        out.writeInt(this.fIncludedPaths.size());
        Iterator iter = this.fIncludedPaths.iterator();
        while (iter.hasNext()) {
            JSPTranslator.writeString(out, (String)iter.next());
        }
        JSPTranslator.writeRanges(out, this.fImportRanges);
        JSPTranslator.writeRanges(out, this.fCodeRanges);
        JSPTranslator.writeRanges(out, this.fDeclarationRanges);
        JSPTranslator.writeRanges(out, this.fUseBeanRanges);
        JSPTranslator.writeRanges(out, this.fUserELRanges);
        JSPTranslator.writeRanges(out, this.fIndirectRanges);
        JSPTranslator.writeString(out, this.fELTranslatorID);
        IPath modelPath = this.getModelPath();
        JSPTranslator.writeString(out, modelPath != null && modelPath.segmentCount() > 1 ? modelPath.toString() : null);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fClassHeader = JSPTranslator.readString(in);
        this.fClassname = JSPTranslator.readString(in);
        this.fSuperclass = JSPTranslator.readString(in);
        this.fImplicitImports = JSPTranslator.readString(in);
        this.fServiceHeader = JSPTranslator.readString(in);
        this.fUserImports = new StringBuffer(JSPTranslator.readString(in));
        this.fSourcePosition = in.readInt();
        this.fRelativeOffset = in.readInt();
        this.fCursorPosition = in.readInt();
        this.fIsErrorPage = in.readBoolean();
        this.fCursorInExpression = in.readBoolean();
        this.fIsInASession = in.readBoolean();
        this.fUserCode = new StringBuffer(JSPTranslator.readString(in));
        this.fUserELExpressions = new StringBuffer(JSPTranslator.readString(in));
        this.fUserDeclarations = new StringBuffer(JSPTranslator.readString(in));
        this.fCursorOwner = new StringBuffer(JSPTranslator.readString(in));
        this.fInCodeRegion = in.readBoolean();
        this.fProcessIncludes = in.readBoolean();
        this.fOffsetInUserImports = in.readInt();
        this.fOffsetInUserDeclarations = in.readInt();
        this.fOffsetInUserCode = in.readInt();
        int size = in.readInt();
        this.fIncludedPaths = new HashSet(size);
        int i = 0;
        while (i < size) {
            this.fIncludedPaths.add(JSPTranslator.readString(in));
            ++i;
        }
        this.fImportRanges = JSPTranslator.readRanges(in);
        this.fCodeRanges = JSPTranslator.readRanges(in);
        this.fDeclarationRanges = JSPTranslator.readRanges(in);
        this.fUseBeanRanges = JSPTranslator.readRanges(in);
        this.fUserELRanges = JSPTranslator.readRanges(in);
        this.fIndirectRanges = JSPTranslator.readRanges(in);
        this.fELTranslatorID = JSPTranslator.readString(in);
        String path = JSPTranslator.readString(in);
        if (path != null && path.trim().length() > 0) {
            this.fSavedModelPath = new Path(path);
        }
        this.buildResult(false);
    }

    protected void postReadExternalSetup(IStructuredModel jspModel) {
        this.fStructuredDocument = jspModel.getStructuredDocument();
        this.fJspTextBuffer = new StringBuffer(this.fStructuredDocument.get());
        if (jspModel instanceof IDOMModel) {
            this.fStructuredModel = (IDOMModel)jspModel;
        }
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        if (s != null) {
            out.writeInt(s.length());
            out.writeChars(s);
        } else {
            out.writeInt(0);
        }
    }

    private static String readString(ObjectInput in) throws IOException {
        int length = in.readInt();
        char[] charArray = new char[length];
        int i = 0;
        while (i < length) {
            charArray[i] = in.readChar();
            ++i;
        }
        return new String(charArray);
    }

    private static void writeBuffer(ObjectOutput out, StringBuffer buff) throws IOException {
        if (buff != null && buff.length() > 0) {
            JSPTranslator.writeString(out, buff.toString());
        } else {
            JSPTranslator.writeString(out, null);
        }
    }

    private static void writeRanges(ObjectOutput out, HashMap ranges) throws IOException {
        HashMap temp = new HashMap();
        temp.putAll(ranges);
        Iterator iter = temp.keySet().iterator();
        out.writeInt(ranges.size());
        while (iter.hasNext()) {
            Position javaPos = (Position)iter.next();
            Position jspPos = (Position)temp.get(javaPos);
            out.writeInt(javaPos.offset);
            out.writeInt(javaPos.length);
            out.writeBoolean(javaPos.isDeleted);
            if (jspPos != null) {
                out.writeInt(jspPos.offset);
                out.writeInt(jspPos.length);
                out.writeBoolean(jspPos.isDeleted);
                continue;
            }
            out.writeInt(-1);
            out.writeInt(-1);
        }
    }

    private static HashMap readRanges(ObjectInput in) throws IOException {
        int size = in.readInt();
        HashMap<Position, Position> ranges = new HashMap<Position, Position>(size);
        int i = 0;
        while (i < size) {
            Position javaPos = new Position(in.readInt(), in.readInt());
            if (in.readBoolean()) {
                javaPos.delete();
            }
            Position jspPos = null;
            int jspPosOffset = in.readInt();
            int jspPosLength = in.readInt();
            if (jspPosOffset != -1 && jspPosLength != -1) {
                jspPos = new Position(jspPosOffset, jspPosLength);
            }
            if (jspPos != null && in.readBoolean()) {
                jspPos.delete();
            }
            ranges.put(javaPos, jspPos);
            ++i;
        }
        return ranges;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof JSPTranslator) {
            JSPTranslator other = (JSPTranslator)obj;
            equal = this.fClassHeader.equals(other.fClassHeader) && this.fClassname.equals(other.fClassname) && this.fSuperclass.equals(other.fSuperclass) && this.fImplicitImports.equals(other.fImplicitImports) && this.fServiceHeader.equals(other.fServiceHeader) && JSPTranslator.buffersEqual(this.fUserImports, other.fUserImports) && this.fSourcePosition == other.fSourcePosition && this.fRelativeOffset == other.fRelativeOffset && this.fCursorPosition == other.fCursorPosition && this.fIsErrorPage == other.fIsErrorPage && this.fCursorInExpression == other.fCursorInExpression && this.fIsInASession == other.fIsInASession && JSPTranslator.buffersEqual(this.fUserCode, other.fUserCode) && JSPTranslator.buffersEqual(this.fUserELExpressions, other.fUserELExpressions) && JSPTranslator.buffersEqual(this.fUserDeclarations, other.fUserDeclarations) && JSPTranslator.buffersEqual(this.fCursorOwner, other.fCursorOwner) && this.fInCodeRegion == other.fInCodeRegion && this.fProcessIncludes == other.fProcessIncludes && this.fOffsetInUserImports == other.fOffsetInUserImports && this.fOffsetInUserDeclarations == other.fOffsetInUserDeclarations && this.fOffsetInUserCode == other.fOffsetInUserCode && JSPTranslator.rangesEqual(this.fImportRanges, other.fImportRanges) && JSPTranslator.rangesEqual(this.fCodeRanges, other.fCodeRanges) && JSPTranslator.rangesEqual(this.fDeclarationRanges, other.fDeclarationRanges) && JSPTranslator.rangesEqual(this.fUseBeanRanges, other.fUseBeanRanges) && JSPTranslator.rangesEqual(this.fUserELRanges, other.fUserELRanges) && JSPTranslator.rangesEqual(this.fIndirectRanges, other.fIndirectRanges) && (this.fELTranslatorID != null && other.fELTranslatorID != null || this.fELTranslatorID == null && other.fELTranslatorID != null && other.fELTranslatorID.length() == 0 || this.fELTranslatorID != null && this.fELTranslatorID.length() == 0 && other.fELTranslatorID == null || this.fELTranslatorID.equals(other.fELTranslator));
        }
        return equal;
    }

    private static boolean buffersEqual(StringBuffer buff1, StringBuffer buff2) {
        return buff1 == null && buff2 == null || buff1 != null && buff2 != null && buff1.toString().equals(buff2.toString()) || buff1 == null && buff2 != null && buff2.length() == 0 || buff1 != null && buff1.length() == 0 && buff2 == null;
    }

    private static boolean rangesEqual(HashMap ranges1, HashMap ranges2) {
        HashMap temp = new HashMap();
        temp.putAll(ranges1);
        ranges1 = temp;
        boolean equal = false;
        if (ranges1 != null && ranges2 != null) {
            equal = true;
            Iterator ranges1Keys = ranges1.keySet().iterator();
            while (ranges1Keys.hasNext() && equal) {
                Position key = (Position)ranges1Keys.next();
                Position ranges1Value = (Position)ranges1.get(key);
                Position ranges2Value = (Position)ranges2.get(key);
                equal = ranges1Value.equals((Object)ranges2Value);
            }
        }
        return equal;
    }

    static class RegionTags {
        ITextRegionCollection region;
        CustomTag tag;

        RegionTags(ITextRegionCollection region, CustomTag tag) {
            this.region = region;
            this.tag = tag;
        }
    }
}

