/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.CharacterTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringBuilderTools {
    public static char[] convertToCharArray(StringBuilder sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static void center(StringBuilder sb, String string, int length) {
        StringBuilderTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, begin + length);
        } else {
            int begin = length - stringLength >> 1;
            StringBuilderTools.fill(sb, begin, c);
            sb.append(string);
            StringBuilderTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void center(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, length);
        } else {
            int begin = length - stringLength >> 1;
            StringBuilderTools.fill(sb, begin, c);
            sb.append(string);
            StringBuilderTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void pad(StringBuilder sb, String string, int length) {
        StringBuilderTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuilder sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void pad(StringBuilder sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuilder sb, String string, int length) {
        StringBuilderTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    private static void pad_(StringBuilder sb, String string, int stringLength, int length, char c) {
        sb.append(string);
        StringBuilderTools.fill(sb, stringLength, length, c);
    }

    private static void pad_(StringBuilder sb, char[] string, int stringLength, int length, char c) {
        sb.append(string);
        StringBuilderTools.fill(sb, stringLength, length, c);
    }

    private static void fill(StringBuilder sb, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, length - stringLength, c);
    }

    private static void fill(StringBuilder sb, int length, char c) {
        sb.append(ArrayTools.fill(new char[length], c));
    }

    public static void zeroPad(StringBuilder sb, String string, int length) {
        StringBuilderTools.frontPad(sb, string, length, '0');
    }

    public static void zeroPad(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.frontPad(sb, string, length, '0');
    }

    public static void frontPad(StringBuilder sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontPad(StringBuilder sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void zeroFit(StringBuilder sb, String string, int length) {
        StringBuilderTools.frontFit(sb, string, length, '0');
    }

    public static void zeroFit(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.frontFit(sb, string, length, '0');
    }

    public static void frontFit(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, stringLength);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontFit(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    private static void frontPad_(StringBuilder sb, String string, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    private static void frontPad_(StringBuilder sb, char[] string, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    public static void separate(StringBuilder sb, String string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length();
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBuilderTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuilder sb, String string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void separate(StringBuilder sb, char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBuilderTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuilder sb, char[] string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void quote(StringBuilder sb, String string) {
        StringBuilderTools.delimit(sb, string, '\"');
    }

    public static void quote(StringBuilder sb, char[] string) {
        StringBuilderTools.delimit(sb, string, '\"');
    }

    public static void delimit(StringBuilder sb, String string, char delimiter) {
        int stringLength = string.length();
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
    }

    static void delimit(StringBuilder sb, String string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuilder sb, char[] string, char delimiter) {
        int stringLength = string.length;
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
    }

    static void delimit(StringBuilder sb, char[] string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuilder sb, String string, String delimiter) {
        int delimiterLength = delimiter.length();
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBuilderTools.delimit(sb, string, delimiter.charAt(0));
                break;
            }
            default: {
                StringBuilderTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuilder sb, String string, String delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void delimit(StringBuilder sb, char[] string, char[] delimiter) {
        int delimiterLength = delimiter.length;
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBuilderTools.delimit(sb, string, delimiter[0]);
                break;
            }
            default: {
                StringBuilderTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuilder sb, char[] string, char[] delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void undelimit(StringBuilder sb, String string) {
        int stringLength = string.length();
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBuilderTools.undelimit_(sb, string, stringLength);
    }

    static void undelimit_(StringBuilder sb, String string, int stringLength) {
        char delimiter;
        char c = delimiter = string.charAt(0);
        char next = string.charAt(1);
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string.charAt(++i);
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string.charAt(++i);
        } while (i != last);
    }

    public static void undelimit(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBuilderTools.undelimit_(sb, string, stringLength);
    }

    static void undelimit_(StringBuilder sb, char[] string, int stringLength) {
        char delimiter;
        char c = delimiter = string[0];
        char next = string[1];
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimit(StringBuilder sb, String string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length() - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, count + resultLength);
    }

    public static void undelimit(StringBuilder sb, char[] string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, resultLength);
    }

    public static void removeFirstOccurrence(StringBuilder sb, String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBuilderTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuilder sb, String string, int index) {
        int stringLength = string.length();
        if (index == 0) {
            sb.append(string, 1, stringLength);
        } else {
            sb.append(string, 0, index);
            if (index != stringLength - 1) {
                sb.append(string, index + 1, stringLength);
            }
        }
    }

    public static void removeFirstOccurrence(StringBuilder sb, char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBuilderTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuilder sb, char[] string, int index) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static void removeAllOccurrences(StringBuilder sb, String string, char c) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    static void removeAllOccurrences(StringBuilder sb, String string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string.charAt(i);
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrences(StringBuilder sb, char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    static void removeAllOccurrences(StringBuilder sb, char[] string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllSpaces(StringBuilder sb, String string) {
        StringBuilderTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllSpaces(StringBuilder sb, char[] string) {
        StringBuilderTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllWhitespace(StringBuilder sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    static void removeAllWhitespace(StringBuilder sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespace(StringBuilder sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    static void removeAllWhitespace(StringBuilder sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void compressWhitespace(StringBuilder sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    static void compressWhitespace(StringBuilder sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string.charAt(i);
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string.charAt(i)));
                continue block0;
            }
            break;
        }
    }

    public static void compressWhitespace(StringBuilder sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    static void compressWhitespace(StringBuilder sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string[i];
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string[i];
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string[i]));
                continue block0;
            }
            break;
        }
    }

    public static void capitalize(StringBuilder sb, String string) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringBuilderTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuilder sb, String string) {
        sb.append(Character.toUpperCase(string.charAt(0)));
        sb.append(string, 1, string.length());
    }

    public static void capitalize(StringBuilder sb, char[] string) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringBuilderTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuilder sb, char[] string) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalize(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (StringTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBuilderTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuilder sb, String string, int stringLength) {
        sb.append(Character.toLowerCase(string.charAt(0)));
        sb.append(string, 1, stringLength);
    }

    public static void uncapitalize(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (CharArrayTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBuilderTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuilder sb, char[] string, int stringLength) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, stringLength - 1);
    }

    public static void convertToHexString(StringBuilder sb, byte[] bytes) {
        int bytesLength = bytes.length;
        if (bytesLength != 0) {
            sb.ensureCapacity(sb.length() + (bytesLength << 1));
            StringBuilderTools.convertToHexString(sb, bytes, bytesLength);
        }
    }

    static void convertToHexString(StringBuilder sb, byte[] bytes, int bytesLength) {
        char[] digits = CharacterTools.DIGITS;
        int i = 0;
        while (i < bytesLength) {
            int b = bytes[i] & 0xFF;
            sb.append(digits[b >> 4]);
            sb.append(digits[b & 0xF]);
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString) {
        int stringLength = camelCaseString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps_(StringBuilder sb, String camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString) {
        int stringLength = camelCaseString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps_(StringBuilder sb, char[] camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length()) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString) {
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString) {
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteral(StringBuilder sb, String string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteralContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToJavaStringLiteral(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteral(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteralContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToJavaStringLiteral(sb, string[i]);
            ++i;
        }
    }

    private static void convertToJavaStringLiteral(StringBuilder sb, char c) {
        switch (c) {
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlAttributeValue(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    static void convertToXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        int index = string.indexOf(34);
        if (index == -1) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = string.indexOf(39);
            if (index == -1) {
                StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        sb.append('\'');
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, String string) {
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, String string) {
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlAttributeValue(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    static void convertToXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        int index = ArrayTools.indexOf(string, '\"');
        if (index == -1) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = ArrayTools.indexOf(string, '\'');
            if (index == -1) {
                StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\'');
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, char[] string) {
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, char[] string) {
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char c) {
        switch (c) {
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char c) {
        switch (c) {
            case '\'': {
                sb.append("&apos;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementText(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    static void convertToXmlElementText(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToXmlElementText(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlElementText(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    static void convertToXmlElementText(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToXmlElementText(sb, string[i]);
            ++i;
        }
    }

    private static void convertToXmlElementText(StringBuilder sb, char c) {
        switch (c) {
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementCDATA(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATA(StringBuilder sb, String string, int stringLength) {
        sb.append("<![CDATA[");
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATAContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string.charAt(i);
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string.charAt(i);
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void convertToXmlElementCDATA(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATA(StringBuilder sb, char[] string, int stringLength) {
        sb.append("<![CDATA[");
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATAContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string[i];
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string[i];
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void append(StringBuilder sb, Object[] array) {
        sb.append('[');
        if (array.length > 0) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                sb.append(element);
                sb.append(", ");
                ++n2;
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
    }

    public static <T> void append(StringBuilder sb, Iterable<T> iterable) {
        StringBuilderTools.append(sb, iterable.iterator());
    }

    public static <T> void append(StringBuilder sb, Iterator<T> iterator) {
        sb.append('[');
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
    }

    public static void appendHashCodeToString(StringBuilder sb, Object object) {
        StringBuilderTools.appendToStringName(sb, object.getClass());
        sb.append('[');
        StringBuilderTools.separate(sb, StringBuilderTools.buildHashCode(object), '-', 2);
        sb.append(']');
    }

    private static String buildHashCode(Object object) {
        return StringTools.zeroPad(Integer.toHexString(System.identityHashCode(object)).toUpperCase(), 8);
    }

    public static void appendToStringName(StringBuilder sb, Class<?> javaClass) {
        ClassTools.appendToStringNameTo(javaClass, sb);
    }

    private StringBuilderTools() {
        throw new UnsupportedOperationException();
    }
}

