/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class CompositeWriter
extends Writer {
    private Writer[] writers;

    public CompositeWriter(Writer ... writers) {
        if (writers == null) {
            throw new NullPointerException();
        }
        this.writers = writers;
    }

    public CompositeWriter(Object lock, Writer ... writers) {
        super(lock);
        if (writers == null) {
            throw new NullPointerException();
        }
        this.writers = writers;
    }

    public void write(int c) throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.write(c);
            ++n2;
        }
    }

    public void write(char[] cbuf) throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.write(cbuf);
            ++n2;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.write(cbuf, off, len);
            ++n2;
        }
    }

    public void write(String str) throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.write(str);
            ++n2;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.write(str, off, len);
            ++n2;
        }
    }

    public void flush() throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.flush();
            ++n2;
        }
    }

    public void close() throws IOException {
        Writer[] writerArray = this.writers;
        int n = this.writers.length;
        int n2 = 0;
        while (n2 < n) {
            Writer writer = writerArray[n2];
            writer.close();
            ++n2;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, Arrays.toString(this.writers));
    }
}

