/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bind;

import java.util.Arrays;
import org.eclipse.jpt.common.ui.internal.swt.bind.BooleanButtonModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.BooleanStateController;
import org.eclipse.jpt.common.ui.internal.swt.bind.ButtonLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.CLabelLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.CaretLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.DropDownListBoxSelectionBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.FormLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.GroupLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.HyperlinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.ImageHyperlinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.ItemLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.LabelLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.LabelModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.LinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.ListBoxSelectionBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.ListWidgetModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.MultiControlBooleanStateController;
import org.eclipse.jpt.common.ui.internal.swt.bind.PageBookModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTComboAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTListAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.ScrolledFormLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.ShellLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.SimpleBooleanStateController;
import org.eclipse.jpt.common.ui.internal.swt.bind.TextFieldModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bind.WidgetLabelAdapter;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.model.value.ModifiablePropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.NullPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTBindTools {
    private static final BooleanStateController.Adapter ENABLED_ADAPTER = new BooleanStateController.Adapter(){

        public void setState(Control control, boolean b) {
            control.setEnabled(b);
        }
    };
    private static final BooleanStateController.Adapter VISIBLE_ADAPTER = new BooleanStateController.Adapter(){

        public void setState(Control control, boolean b) {
            control.setVisible(b);
        }
    };
    private static final BooleanStateController.Adapter EXPANDED_ADAPTER = new BooleanStateController.Adapter(){

        public void setState(Control section, boolean b) {
            ((Section)section).setExpanded(b);
        }
    };

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Button button) {
        SWTBindTools.bindImage(imageModel, new ButtonLabelAdapter(button));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Button button) {
        SWTBindTools.bindText(textModel, new ButtonLabelAdapter(button));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Button button) {
        SWTBindTools.bind(imageModel, textModel, new ButtonLabelAdapter(button));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, CLabel label) {
        SWTBindTools.bindImage(imageModel, new CLabelLabelAdapter(label));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, CLabel label) {
        SWTBindTools.bindText(textModel, new CLabelLabelAdapter(label));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, CLabel label) {
        SWTBindTools.bind(imageModel, textModel, new CLabelLabelAdapter(label));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Form form) {
        SWTBindTools.bindImage(imageModel, new FormLabelAdapter(form));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Form form) {
        SWTBindTools.bindText(textModel, new FormLabelAdapter(form));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Form form) {
        SWTBindTools.bind(imageModel, textModel, new FormLabelAdapter(form));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, ImageHyperlink hyperlink) {
        SWTBindTools.bindImage(imageModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, ImageHyperlink hyperlink) {
        SWTBindTools.bindText(textModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, ImageHyperlink hyperlink) {
        SWTBindTools.bind(imageModel, textModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Label label) {
        SWTBindTools.bindImage(imageModel, new LabelLabelAdapter(label));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Label label) {
        SWTBindTools.bindText(textModel, new LabelLabelAdapter(label));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Label label) {
        SWTBindTools.bind(imageModel, textModel, new LabelLabelAdapter(label));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, ScrolledForm form) {
        SWTBindTools.bindImage(imageModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, ScrolledForm form) {
        SWTBindTools.bindText(textModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, ScrolledForm form) {
        SWTBindTools.bind(imageModel, textModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Item item) {
        SWTBindTools.bindImage(imageModel, new ItemLabelAdapter(item));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Item item) {
        SWTBindTools.bindText(textModel, new ItemLabelAdapter(item));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Item item) {
        SWTBindTools.bind(imageModel, textModel, new ItemLabelAdapter(item));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Shell window) {
        SWTBindTools.bindImage(imageModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Shell window) {
        SWTBindTools.bindText(textModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Shell window) {
        SWTBindTools.bind(imageModel, textModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, Caret caret) {
        SWTBindTools.bindImage(imageModel, new CaretLabelAdapter(caret));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Group group) {
        SWTBindTools.bindText(textModel, new GroupLabelAdapter(group));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Hyperlink hyperlink) {
        SWTBindTools.bindText(textModel, new HyperlinkLabelAdapter(hyperlink));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Link link) {
        SWTBindTools.bindText(textModel, new LinkLabelAdapter(link));
    }

    public static void bindImage(PropertyValueModel<Image> imageModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding(imageModel, (PropertyValueModel<String>)new NullPropertyValueModel(), labelAdapter);
    }

    public static void bindText(PropertyValueModel<String> textModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding((PropertyValueModel<Image>)new NullPropertyValueModel(), textModel, labelAdapter);
    }

    public static void bind(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding(imageModel, textModel, labelAdapter);
    }

    public static void bind(ModifiablePropertyValueModel<Boolean> booleanModel, Button button) {
        SWTBindTools.bind(booleanModel, button, false);
    }

    public static void bind(ModifiablePropertyValueModel<Boolean> booleanModel, Button button, boolean defaultValue) {
        new BooleanButtonModelBinding(booleanModel, button, defaultValue);
    }

    public static <E> void bind(ModifiablePropertyValueModel<String> textModel, Text textField) {
        new TextFieldModelBinding(textModel, textField);
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox) {
        SWTBindTools.bind(listModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox, Transformer<E, String> transformer) {
        SWTBindTools.bind(listModel, new SWTListAdapter(listBox), transformer);
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, List listBox) {
        SWTBindTools.bind(listModel, selectedItemModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, List listBox, Transformer<E, String> transformer) {
        SWTBindTools.checkForSingleSelectionStyle(listBox);
        SWTBindTools.bind(listModel, new ModifiablePropertyCollectionValueModelAdapter(selectedItemModel), listBox, transformer);
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, List listBox) {
        SWTBindTools.bind(listModel, selectedItemsModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, List listBox, Transformer<E, String> transformer) {
        SWTBindTools.bind(listModel, new SWTListAdapter(listBox), transformer, new ListBoxSelectionBinding<E>(listModel, selectedItemsModel, listBox));
    }

    private static void checkForSingleSelectionStyle(List listBox) {
        if (!BitTools.flagIsSet((int)listBox.getStyle(), (int)4)) {
            throw new IllegalStateException("list box must be single-selection: " + listBox);
        }
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox) {
        SWTBindTools.bind(listModel, selectedItemModel, dropDownListBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox, Transformer<E, String> transformer) {
        SWTBindTools.checkForReadOnlyStyle((Widget)dropDownListBox);
        SWTComboAdapter comboAdapter = new SWTComboAdapter(dropDownListBox);
        SWTBindTools.bind(listModel, comboAdapter, transformer, new DropDownListBoxSelectionBinding<E>(listModel, selectedItemModel, comboAdapter));
    }

    private static void checkForReadOnlyStyle(Widget comboBox) {
        if (!BitTools.flagIsSet((int)comboBox.getStyle(), (int)8)) {
            throw new IllegalStateException("combo-box must be read-only: " + comboBox);
        }
    }

    private static <E> void bind(ListValueModel<E> listModel, ListWidgetModelBinding.ListWidget listWidget, Transformer<E, String> transformer) {
        SWTBindTools.bind(listModel, listWidget, transformer, ListWidgetModelBinding.SelectionBinding.Null.instance());
    }

    private static <E> void bind(ListValueModel<E> listModel, ListWidgetModelBinding.ListWidget listWidget, Transformer<E, String> transformer, ListWidgetModelBinding.SelectionBinding selectionBinding) {
        new ListWidgetModelBinding<E>(listModel, listWidget, transformer, selectionBinding);
    }

    public static void bind(PropertyValueModel<Control> controlModel, PageBook pageBook) {
        SWTBindTools.bind(controlModel, pageBook, null);
    }

    public static void bind(PropertyValueModel<Control> controlModel, PageBook pageBook, Control defaultPage) {
        SWTBindTools.bind(controlModel, TransformerTools.passThruTransformer(), pageBook, defaultPage);
    }

    public static <T> void bind(PropertyValueModel<T> valueModel, Transformer<? super T, Control> transformer, PageBook pageBook) {
        SWTBindTools.bind(valueModel, transformer, pageBook, null);
    }

    public static <T> void bind(PropertyValueModel<T> valueModel, Transformer<? super T, Control> transformer, PageBook pageBook, Control defaultPage) {
        new PageBookModelBinding<T>(valueModel, transformer, pageBook, defaultPage);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTBindTools.controlEnabledState(booleanModel, controls, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTBindTools.controlEnabledState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTBindTools.controlEnabledState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTBindTools.controlEnabledState(booleanModel, controls, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls, boolean defaultValue) {
        SWTBindTools.controlEnabledState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel(controls), defaultValue);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel) {
        SWTBindTools.controlEnabledState(booleanModel, controlsModel, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue) {
        SWTBindTools.control(booleanModel, controlsModel, defaultValue, ENABLED_ADAPTER);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTBindTools.control(booleanModel, control, defaultValue, ENABLED_ADAPTER);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTBindTools.controlVisibleState(booleanModel, controls, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTBindTools.controlVisibleState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTBindTools.controlVisibleState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTBindTools.controlVisibleState(booleanModel, controls, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls, boolean defaultValue) {
        SWTBindTools.controlVisibleState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel(controls), defaultValue);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel) {
        SWTBindTools.controlVisibleState(booleanModel, controlsModel, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue) {
        SWTBindTools.control(booleanModel, controlsModel, defaultValue, VISIBLE_ADAPTER);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTBindTools.control(booleanModel, control, defaultValue, VISIBLE_ADAPTER);
    }

    private static void control(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue, BooleanStateController.Adapter adapter) {
        new MultiControlBooleanStateController(booleanModel, controlsModel, defaultValue, adapter);
    }

    private static void control(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue, BooleanStateController.Adapter adapter) {
        new SimpleBooleanStateController(booleanModel, control, defaultValue, adapter);
    }

    public static void controlExpandedState(PropertyValueModel<Boolean> booleanModel, Section section) {
        SWTBindTools.controlExpandedState(booleanModel, section, false);
    }

    public static void controlExpandedState(PropertyValueModel<Boolean> booleanModel, Section section, boolean defaultValue) {
        SWTBindTools.control(booleanModel, section, defaultValue, EXPANDED_ADAPTER);
    }

    private static void control(PropertyValueModel<Boolean> booleanModel, Section section, boolean defaultValue, BooleanStateController.Adapter adapter) {
        new SimpleBooleanStateController(booleanModel, (Control)section, defaultValue, adapter);
    }

    private SWTBindTools() {
        throw new UnsupportedOperationException();
    }
}

