/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.orm;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.wizards.NewJptFileWizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.orm.MappingFileOptionsWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class MappingFileWizard
extends Wizard
implements INewWizard {
    protected IDataModel dataModel;
    protected IStructuredSelection initialSelection;
    protected IStructuredSelection mungedSelection;
    private IWizardPage firstPage;
    private IWizardPage secondPage;

    public MappingFileWizard() {
        this(null);
    }

    public MappingFileWizard(IDataModel dataModel) {
        this.dataModel = dataModel;
        this.setWindowTitle(JptJpaUiMessages.MappingFileWizard_title);
        this.setDefaultPageImageDescriptor(JptJpaUiImages.JPA_FILE_BANNER);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
        this.mungedSelection = selection;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object firstSelection = selection.getFirstElement();
        PersistenceUnit pUnit = this.extractPersistenceUnit(firstSelection);
        IContainer container = this.extractContainer(pUnit, firstSelection);
        if (container != null) {
            this.mungedSelection = new StructuredSelection((Object)container);
        }
        if (pUnit != null) {
            this.getDataModel().setBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", true);
            this.getDataModel().setStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", pUnit.getName());
        }
    }

    private PersistenceUnit extractPersistenceUnit(Object selection) {
        Persistence persistence;
        PersistenceXml persistenceXml;
        if (selection instanceof JpaContextModel) {
            return ((JpaContextModel)selection).getPersistenceUnit();
        }
        JpaProject jpaProject = this.getJpaProject(selection);
        if (jpaProject != null && (persistenceXml = jpaProject.getContextModelRoot().getPersistenceXml()) != null && (persistence = persistenceXml.getRoot()) != null && persistence.getPersistenceUnitsSize() > 0) {
            return persistence.getPersistenceUnit(0);
        }
        return null;
    }

    private JpaProject getJpaProject(Object selection) {
        IProject project = this.getProject(selection);
        return project == null ? null : this.getJpaProject(project);
    }

    private IProject getProject(Object selection) {
        if (selection instanceof IJavaProject) {
            return ((IJavaProject)selection).getProject();
        }
        if (selection instanceof IProject) {
            return (IProject)selection;
        }
        return null;
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    private IContainer extractContainer(PersistenceUnit pUnit, Object selection) {
        JpaContextModel node;
        if (pUnit != null) {
            return pUnit.getResource().getParent();
        }
        if (selection instanceof IProject) {
            return this.getDefaultContainer((IProject)selection);
        }
        if (selection instanceof IContainer) {
            return (IContainer)selection;
        }
        if (selection instanceof JpaContextModel) {
            return this.getDefaultContainer(((JpaContextModel)selection).getJpaProject().getProject());
        }
        IResource resource = (IResource)PlatformTools.getAdapter((Object)selection, IResource.class);
        if (resource != null) {
            if (resource instanceof IProject) {
                return this.getDefaultContainer((IProject)resource);
            }
            if (resource instanceof IContainer) {
                return (IContainer)resource;
            }
        }
        if ((node = (JpaContextModel)PlatformTools.getAdapter((Object)selection, JpaContextModel.class)) != null) {
            return this.getDefaultContainer(node.getJpaProject().getProject());
        }
        return null;
    }

    private IContainer getDefaultContainer(IProject project) {
        if (ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET)) {
            ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
            return locator.getDefaultLocation();
        }
        return project;
    }

    public void addPages() {
        super.addPages();
        this.firstPage = this.buildMappingFileNewFileWizardPage();
        this.secondPage = this.buildMappingFileOptionsWizardPage();
        this.addPage(this.firstPage);
        this.addPage(this.secondPage);
    }

    protected NewJptFileWizardPage buildMappingFileNewFileWizardPage() {
        return new NewJptFileWizardPage("Page_1", this.mungedSelection, this.getDataModel(), JptJpaUiMessages.MappingFileWizardPage_newFile_title, JptJpaUiMessages.MappingFileWizardPage_newFile_desc);
    }

    protected MappingFileOptionsWizardPage buildMappingFileOptionsWizardPage() {
        return new MappingFileOptionsWizardPage("Page_2", this.getDataModel(), JptJpaUiMessages.MappingFileWizardPage_options_title, JptJpaUiMessages.MappingFileWizardPage_options_desc);
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && this.getDataModel().isValid();
    }

    public IDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
        }
        return this.dataModel;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new OrmFileCreationDataModelProvider();
    }

    protected IDataModelPausibleOperation getOperation() {
        return (IDataModelPausibleOperation)this.getDataModel().getDefaultOperation();
    }

    public boolean performFinish() {
        this.createMappingFile();
        try {
            this.postPerformFinish();
        }
        catch (Exception e) {
            JptJpaUiPlugin.instance().logError(e);
        }
        return true;
    }

    protected boolean createMappingFile() {
        try {
            IStatus st = this.runOperations();
            if (st.getSeverity() == 4) {
                JptJpaUiPlugin.instance().getLog().log(st);
                Throwable t = st.getException() == null ? new CoreException(st) : st.getException();
                ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)t, (int)0, (boolean)false);
            } else if (st.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_2, (Object[])new Object[]{this.getWindowTitle()}), (String)st.getMessage(), (IStatus)st, (int)2);
            }
        }
        catch (Exception e) {
            JptJpaUiPlugin.instance().logError(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)e, (int)0, (boolean)false);
        }
        return true;
    }

    protected IStatus runOperations() {
        class CatchThrowableRunnableWithProgress
        implements IRunnableWithProgress {
            public IStatus status = null;
            public Throwable caught = null;

            CatchThrowableRunnableWithProgress() {
            }

            public void run(IProgressMonitor pm) {
                try {
                    this.status = MappingFileWizard.this.getOperation().execute(pm, null);
                }
                catch (Throwable e) {
                    this.caught = e;
                }
            }
        }
        CatchThrowableRunnableWithProgress runnable = new CatchThrowableRunnableWithProgress();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (Throwable e) {
            runnable.caught = e;
        }
        if (runnable.caught == null) {
            return runnable.status;
        }
        JptJpaUiPlugin.instance().logError(runnable.caught);
        ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)runnable.caught, (int)0, (boolean)false);
        return JptJpaUiPlugin.instance().buildErrorStatus(runnable.caught);
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            IPath containerPath = (IPath)this.getDataModel().getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
            String fileName = this.getDataModel().getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
            IContainer container = PathTools.getContainer((IPath)containerPath);
            IFile file = container.getFile((IPath)new Path(fileName));
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            throw new InvocationTargetException(cantOpen);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = WorkbenchTools.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        JptJpaUiPlugin.instance().logError(e);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.getDataModel().dispose();
    }

    public static IPath createNewMappingFile(IStructuredSelection selection, String xmlFileName) {
        MappingFileWizard wizard = new MappingFileWizard(DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider()));
        return MappingFileWizard.createMappingFile(selection, xmlFileName, wizard);
    }

    protected static IPath createMappingFile(IStructuredSelection selection, String xmlFileName, MappingFileWizard wizard) {
        wizard.getDataModel().setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)xmlFileName);
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(MappingFileWizard.getCurrentShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            IPath containerPath = (IPath)wizard.getDataModel().getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
            String fileName = wizard.getDataModel().getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
            IContainer container = PathTools.getContainer((IPath)containerPath);
            IPath filePath = container.getFullPath().append(fileName);
            IProject project = container.getProject();
            ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
            IPath runtimePath = locator.getRuntimePath(filePath);
            return runtimePath;
        }
        return null;
    }

    private static Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }
}

