/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.TypeVector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion region;

    public RegionBasedTypeHierarchy(IRegion region, IJavaScriptUnit[] workingCopies, IType type, boolean computeSubtypes) {
        super(type, workingCopies, (IJavaScriptSearchScope)null, computeSubtypes);
        Region newRegion = new Region(){

            public void add(IJavaScriptElement element) {
                if (!this.contains(element)) {
                    this.removeAllChildren(element);
                    this.fRootElements.add(element);
                    if (element.getElementType() == 2) {
                        try {
                            IPackageFragmentRoot[] roots = ((IJavaScriptProject)element).getPackageFragmentRoots();
                            int i = 0;
                            int length = roots.length;
                            while (i < length) {
                                if (roots[i].isArchive() && !this.fRootElements.contains(roots[i])) {
                                    this.fRootElements.add(roots[i]);
                                }
                                ++i;
                            }
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                    }
                    this.fRootElements.trimToSize();
                }
            }
        };
        IJavaScriptElement[] elements = region.getElements();
        int i = 0;
        int length = elements.length;
        while (i < length) {
            newRegion.add(elements[i]);
            ++i;
        }
        this.region = newRegion;
        if (elements.length > 0) {
            this.project = elements[0].getJavaScriptProject();
        }
    }

    protected void initializeRegions() {
        super.initializeRegions();
        IJavaScriptElement[] roots = this.region.getElements();
        int i = 0;
        while (i < roots.length) {
            IJavaScriptElement root = roots[i];
            if (root instanceof IOpenable) {
                this.files.put(root, new ArrayList());
            } else {
                Openable o = (Openable)((JavaElement)root).getOpenableParent();
                if (o != null) {
                    this.files.put(o, new ArrayList());
                }
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void compute() throws JavaScriptModelException, CoreException {
        RegionBasedHierarchyBuilder builder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)builder).build(this.computeSubtypes);
    }

    protected boolean isAffectedByOpenable(IJavaScriptElementDelta delta, IJavaScriptElement element) {
        if (element instanceof CompilationUnit && ((CompilationUnit)element).isWorkingCopy()) {
            return super.isAffectedByOpenable(delta, element);
        }
        if (this.focusType == null) {
            return this.region.contains(element);
        }
        return super.isAffectedByOpenable(delta, element);
    }

    public IJavaScriptProject javaProject() {
        return this.project;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses());
    }

    private boolean pruneDeadBranches(IType type) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            return true;
        }
        this.pruneDeadBranches(subtypes.copy().elements());
        subtypes = (TypeVector)this.typeToSubtypes.get(type.getDisplayName());
        return subtypes == null || subtypes.size == 0;
    }

    private void pruneDeadBranches(IType[] types) {
        int i = 0;
        int length = types.length;
        while (i < length) {
            IType type = types[i];
            if (this.pruneDeadBranches(type) && !this.region.contains(type)) {
                this.removeType(type);
            }
            ++i;
        }
    }

    protected void removeType(IType type) {
        TypeVector types;
        IType superclass;
        IType[] subtypes = this.getSubclasses(type);
        this.typeToSubtypes.remove(type.getDisplayName());
        if (subtypes != null) {
            int i = 0;
            while (i < subtypes.length) {
                this.removeType(subtypes[i]);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.remove(type)) != null && (types = (TypeVector)this.typeToSubtypes.get(superclass.getDisplayName())) != null) {
            types.remove(type);
        }
    }
}

