/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class IndexBinaryFolder
extends IndexRequest {
    IContainer folder;
    char[][] exclusionPatterns;

    public IndexBinaryFolder(IContainer folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)folder.getProject());
            IIncludePathEntry[] newResolvedClasspath = javaProject.getResolvedClasspath();
            IPath folderPath = folder.getFullPath();
            int i = 0;
            while (i < newResolvedClasspath.length) {
                boolean found = false;
                int entryKind = newResolvedClasspath[i].getEntryKind();
                switch (entryKind) {
                    case 1: {
                        IPath newPath = newResolvedClasspath[i].getPath();
                        if (!newPath.equals((Object)folderPath)) break;
                        this.exclusionPatterns = ((ClasspathEntry)newResolvedClasspath[i]).fullExclusionPatternChars();
                        found = true;
                    }
                }
                if (!found) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals((Object)((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            block23: {
                try {
                    monitor.enterRead();
                    String[] paths = index.queryDocumentNames("");
                    int max = paths == null ? 0 : paths.length;
                    final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    if (paths == null) {
                        this.folder.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) {
                                if (IndexBinaryFolder.this.isCancelled) {
                                    return false;
                                }
                                if (proxy.getType() == 1) {
                                    if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(proxy.getName())) {
                                        IFile file = (IFile)proxy.requestResource();
                                        if (IndexBinaryFolder.this.exclusionPatterns == null || !Util.isExcluded((IResource)file, null, IndexBinaryFolder.this.exclusionPatterns)) {
                                            String containerRelativePath = Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount());
                                            indexedFileNames.put(containerRelativePath, file);
                                        }
                                    }
                                    return false;
                                }
                                return true;
                            }
                        }, 0);
                    } else {
                        int i = 0;
                        while (true) {
                            if (i >= max) {
                                final long indexLastModified = index.getIndexFile().lastModified();
                                this.folder.accept(new IResourceProxyVisitor(){

                                    public boolean visit(IResourceProxy proxy) throws CoreException {
                                        if (IndexBinaryFolder.this.isCancelled) {
                                            return false;
                                        }
                                        if (proxy.getType() == 1) {
                                            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(proxy.getName())) {
                                                URI location;
                                                IFile file = (IFile)proxy.requestResource();
                                                if (!(IndexBinaryFolder.this.exclusionPatterns != null && Util.isExcluded((IResource)file, null, IndexBinaryFolder.this.exclusionPatterns) || (location = file.getLocationURI()) == null)) {
                                                    String containerRelativePath;
                                                    indexedFileNames.put(containerRelativePath, indexedFileNames.get(containerRelativePath = Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount())) == null || indexLastModified < EFS.getStore((URI)location).fetchInfo().getLastModified() ? file : "OK");
                                                }
                                            }
                                            return false;
                                        }
                                        return true;
                                    }
                                }, 0);
                                break;
                            }
                            indexedFileNames.put(paths[i], "DELETED");
                            ++i;
                        }
                    }
                    Object[] names = indexedFileNames.keyTable;
                    Object[] values = indexedFileNames.valueTable;
                    int i = 0;
                    int length = names.length;
                    while (true) {
                        if (i >= length) {
                            this.manager.request(new SaveIndex(this.containerPath, this.manager));
                            break block23;
                        }
                        String name = (String)names[i];
                        if (name != null) {
                            if (this.isCancelled) {
                                break;
                            }
                            Object value = values[i];
                            if (value != "OK") {
                                if (value == "DELETED") {
                                    this.manager.remove(name, this.containerPath);
                                } else {
                                    this.manager.addBinary((IFile)value, this.containerPath);
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    if (JobManager.VERBOSE) {
                        Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                        e.printStackTrace();
                    }
                    this.manager.removeIndex(this.containerPath);
                }
                catch (IOException e) {
                    if (JobManager.VERBOSE) {
                        Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                        e.printStackTrace();
                    }
                    this.manager.removeIndex(this.containerPath);
                }
                Object var13_17 = null;
                monitor.exitRead();
                return false;
            }
            Object var13_19 = null;
            monitor.exitRead();
            return true;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

