/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCachingEntity;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkEntityCachingPropertyComposite
extends Pane<EclipseLinkCachingEntity> {
    public EclipseLinkEntityCachingPropertyComposite(Pane<? extends EclipseLinkCaching> parentComposite, PropertyValueModel<EclipseLinkCachingEntity> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentComposite, subjectHolder, enabledModel, parent);
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_CACHE_TYPE_LABEL);
        new CacheTypeComboViewer(container);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.CACHE_SIZE_COMPOSITE_CACHE_SIZE);
        this.addCacheSizeCombo(container);
        TriStateCheckBox sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_LABEL, this.buildSharedCacheHolder(), this.buildSharedCacheStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        sharedCacheCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private String getSubjectName() {
        return ((EclipseLinkCachingEntity)this.getSubjectHolder().getValue()).getName();
    }

    private EclipseLinkCaching getSubjectParent() {
        return ((EclipseLinkCachingEntity)this.getSubjectHolder().getValue()).getParent();
    }

    private void addCacheSizeCombo(Composite container) {
        new IntegerCombo<EclipseLinkCachingEntity>((Pane)this, container){

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<EclipseLinkCaching, Integer>(EclipseLinkEntityCachingPropertyComposite.this.buildCachingHolder(), new String[]{"cacheSizeDefault"}){

                    protected Integer buildValue_() {
                        Integer value = ((EclipseLinkCaching)this.subject).getCacheSizeDefault();
                        if (value == null) {
                            value = ((EclipseLinkCaching)this.subject).getDefaultCacheSizeDefault();
                        }
                        return value;
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<EclipseLinkCachingEntity, Integer>(this.getSubjectHolder(), new String[]{"cacheSize"}){

                    protected Integer buildValue_() {
                        return EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().getCacheSizeOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName());
                    }

                    protected void setValue_(Integer value) {
                        EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().setCacheSizeOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName(), value);
                    }
                };
            }
        };
    }

    private PropertyValueModel<EclipseLinkCaching> buildCachingHolder() {
        return new TransformationPropertyValueModel<EclipseLinkCachingEntity, EclipseLinkCaching>(this.getSubjectHolder()){

            protected EclipseLinkCaching transform_(EclipseLinkCachingEntity value) {
                return value.getParent();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildSharedCacheHolder() {
        return new PropertyAspectAdapter<EclipseLinkCachingEntity, Boolean>(this.getSubjectHolder(), new String[]{"sharedCache"}){

            protected Boolean buildValue_() {
                return EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().getSharedCacheOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName());
            }

            protected void setValue_(Boolean value) {
                EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().setSharedCacheOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName(), value);
            }
        };
    }

    private PropertyValueModel<String> buildSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultAndNonDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_DEFAULT_SHARED_CACHE_LABEL, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheHolder() {
        return new ListPropertyValueModelAdapter<Boolean>(this.buildDefaultAndNonDefaultSharedCacheListHolder()){

            protected Boolean buildValue() {
                if (this.listModel.size() == 1) {
                    return (Boolean)this.listModel.listIterator().next();
                }
                return null;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheListHolder() {
        ArrayList<ListValueModel<Boolean>> holders = new ArrayList<ListValueModel<Boolean>>(2);
        holders.add(this.buildSharedCacheListHolder());
        holders.add(this.buildDefaultSharedCacheListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private ListValueModel<Boolean> buildSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildSharedCacheHolder());
    }

    private ListValueModel<Boolean> buildDefaultSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSharedCacheHolder());
    }

    private PropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<EclipseLinkCaching, Boolean>(this.buildCachingHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                Boolean value = ((EclipseLinkCaching)this.subject).getSharedCacheDefault();
                if (value == null) {
                    value = ((EclipseLinkCaching)this.subject).getDefaultSharedCacheDefault();
                }
                return value;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheTypeComboViewer
    extends EnumFormComboViewer<EclipseLinkCachingEntity, EclipseLinkCacheType> {
        private CacheTypeComboViewer(Composite parent) {
            super((Pane)EclipseLinkEntityCachingPropertyComposite.this, parent);
        }

        protected void addPropertyNames(Collection<String> propertyNames) {
            super.addPropertyNames(propertyNames);
            propertyNames.add("cacheType");
        }

        private PropertyValueModel<EclipseLinkCaching> buildCachingHolder() {
            return new TransformationPropertyValueModel<EclipseLinkCachingEntity, EclipseLinkCaching>(this.getSubjectHolder()){

                protected EclipseLinkCaching transform_(EclipseLinkCachingEntity value) {
                    return value.getParent();
                }
            };
        }

        private PropertyValueModel<EclipseLinkCacheType> buildDefaultCacheTypeHolder() {
            return new PropertyAspectAdapter<EclipseLinkCaching, EclipseLinkCacheType>(this.buildCachingHolder(), new String[]{"cacheTypeDefault"}){

                protected EclipseLinkCacheType buildValue_() {
                    EclipseLinkCacheType cacheType = ((EclipseLinkCaching)this.subject).getCacheTypeDefault();
                    if (cacheType == null) {
                        cacheType = ((EclipseLinkCaching)this.subject).getDefaultCacheTypeDefault();
                    }
                    return cacheType;
                }
            };
        }

        private PropertyChangeListener buildDefaultCachingTypePropertyChangeListener() {
            return new SWTPropertyChangeListenerWrapper(this.buildDefaultCachingTypePropertyChangeListener_());
        }

        private PropertyChangeListener buildDefaultCachingTypePropertyChangeListener_() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent e) {
                    if (e.getNewValue() != null && !CacheTypeComboViewer.this.getControl().isDisposed()) {
                        CacheTypeComboViewer.this.doPopulate();
                    }
                }
            };
        }

        protected EclipseLinkCacheType[] getChoices() {
            return EclipseLinkCacheType.values();
        }

        protected EclipseLinkCacheType getDefaultValue() {
            return EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().getDefaultCacheType();
        }

        protected String displayString(EclipseLinkCacheType value) {
            switch (value) {
                case full: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_FULL;
                }
                case weak: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_WEAK;
                }
                case soft: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_SOFT;
                }
                case soft_weak: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_SOFT_WEAK;
                }
                case hard_weak: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_HARD_WEAK;
                }
                case none: {
                    return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_NONE;
                }
            }
            throw new IllegalStateException();
        }

        protected void doPopulate() {
            super.doPopulate();
        }

        protected EclipseLinkCacheType getValue() {
            return EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().getCacheTypeOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName());
        }

        protected void initialize() {
            super.initialize();
            PropertyValueModel<EclipseLinkCacheType> defaultCacheTypeHolder = this.buildDefaultCacheTypeHolder();
            defaultCacheTypeHolder.addPropertyChangeListener("value", this.buildDefaultCachingTypePropertyChangeListener());
        }

        protected void setValue(EclipseLinkCacheType value) {
            EclipseLinkEntityCachingPropertyComposite.this.getSubjectParent().setCacheTypeOf(EclipseLinkEntityCachingPropertyComposite.this.getSubjectName(), value);
        }

        protected boolean sortChoices() {
            return false;
        }

        protected String getHelpId() {
            return EclipseLinkHelpContextIds.PERSISTENCE_CACHING;
        }
    }
}

