/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCachingEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkFlushClearCache;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCaching
extends EclipseLinkPersistenceUnitProperties
implements org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching {
    private EclipseLinkCacheType cacheTypeDefault;
    private Integer cacheSizeDefault;
    private Boolean sharedCacheDefault;
    private EclipseLinkFlushClearCache flushClearCache;
    private List<EclipseLinkCachingEntity> entities;

    public EclipseLinkCaching(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.entities = new ArrayList<EclipseLinkCachingEntity>();
        this.cacheTypeDefault = (EclipseLinkCacheType)this.getEnumValue("eclipselink.cache.type.default", EclipseLinkCacheType.values());
        this.cacheSizeDefault = this.getIntegerValue("eclipselink.cache.size.default");
        this.sharedCacheDefault = this.getBooleanValue("eclipselink.cache.shared.default");
        this.flushClearCache = (EclipseLinkFlushClearCache)this.getEnumValue("eclipselink.flush-clear.cache", EclipseLinkFlushClearCache.values());
        Set<PersistenceUnit.Property> cacheTypeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.type.");
        Set<PersistenceUnit.Property> cacheSizeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.size.");
        Set<PersistenceUnit.Property> sharedCacheProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.shared.");
        this.initializeEntitiesCacheType(cacheTypeProperties);
        this.initializeEntitiesCacheSize(cacheSizeProperties);
        this.initializeEntitiesSharedCache(sharedCacheProperties);
    }

    private void initializeEntitiesCacheType(Set<PersistenceUnit.Property> cacheTypeProperties) {
        for (PersistenceUnit.Property cacheTypeProperty : cacheTypeProperties) {
            this.setEntityCacheTypeOf(cacheTypeProperty);
        }
    }

    private void initializeEntitiesCacheSize(Set<PersistenceUnit.Property> cacheSizeProperties) {
        for (PersistenceUnit.Property cacheSizeProperty : cacheSizeProperties) {
            this.setEntityCacheSizeOf(cacheSizeProperty);
        }
    }

    private void initializeEntitiesSharedCache(Set<PersistenceUnit.Property> sharedCacheProperties) {
        for (PersistenceUnit.Property sharedCacheProperty : sharedCacheProperties) {
            this.setEntitySharedCacheOf(sharedCacheProperty);
        }
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.cache.type.default")) {
            this.cacheTypeDefaultChanged(newValue);
        } else if (propertyName.equals("eclipselink.cache.size.default")) {
            this.cacheSizeDefaultChanged(newValue);
        } else if (propertyName.equals("eclipselink.cache.shared.default")) {
            this.sharedCacheDefaultChanged(newValue);
        } else if (propertyName.startsWith("eclipselink.cache.type.")) {
            this.cacheTypeChanged(propertyName, newValue);
        } else if (propertyName.startsWith("eclipselink.cache.size.")) {
            this.cacheSizeChanged(propertyName, newValue);
        } else if (propertyName.startsWith("eclipselink.cache.shared.")) {
            this.sharedCacheChanged(propertyName, newValue);
        } else if (propertyName.equals("eclipselink.flush-clear.cache")) {
            this.flushClearCacheChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.cache.type.default")) {
            this.cacheTypeDefaultChanged(null);
        } else if (propertyName.equals("eclipselink.cache.size.default")) {
            this.cacheSizeDefaultChanged(null);
        } else if (propertyName.equals("eclipselink.cache.shared.default")) {
            this.sharedCacheDefaultChanged(null);
        } else if (propertyName.startsWith("eclipselink.cache.type.")) {
            this.cacheTypeChanged(propertyName, null);
        } else if (propertyName.startsWith("eclipselink.cache.size.")) {
            this.cacheSizeChanged(propertyName, null);
        } else if (propertyName.startsWith("eclipselink.cache.shared.")) {
            this.sharedCacheChanged(propertyName, null);
        } else if (propertyName.equals("eclipselink.flush-clear.cache")) {
            this.flushClearCacheChanged(null);
        }
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.cache.type.default", "cacheTypeDefault");
        propertyNames.put("eclipselink.cache.size.default", "cacheSizeDefault");
        propertyNames.put("eclipselink.cache.shared.default", "sharedCacheDefault");
        propertyNames.put("eclipselink.flush-clear.cache", "flushClearCache");
    }

    public boolean itemIsProperty(PersistenceUnit.Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && (item.getName().startsWith("eclipselink.cache.type.") || item.getName().startsWith("eclipselink.cache.size.") || item.getName().startsWith("eclipselink.cache.shared."))) {
            return true;
        }
        return isProperty;
    }

    public String propertyIdOf(PersistenceUnit.Property property) {
        try {
            return super.propertyIdOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.cache.type.")) {
                return "cacheType";
            }
            if (property.getName().startsWith("eclipselink.cache.size.")) {
                return "cacheSize";
            }
            if (property.getName().startsWith("eclipselink.cache.shared.")) {
                return "sharedCache";
            }
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
    }

    @Override
    public EclipseLinkCachingEntity addEntity(String entityName) {
        if (this.entityExists(entityName)) {
            throw new IllegalStateException("Duplicate entity: " + entityName);
        }
        EclipseLinkCachingEntity newEntity = this.buildEntity(entityName);
        this.addItemToList(newEntity, this.entities, "entities");
        return newEntity;
    }

    @Override
    public void removeEntity(String entityName) {
        if (!this.entityExists(entityName)) {
            return;
        }
        EclipseLinkCachingEntity entity = this.getEntityNamed(entityName);
        this.clearEntity(entity);
        this.removeEntity(entity);
    }

    @Override
    public EclipseLinkCacheType getCacheTypeOf(String entityName) {
        EclipseLinkCachingEntity entity = this.getEntityNamed(entityName);
        return entity == null ? null : entity.getCacheType();
    }

    @Override
    public void setCacheTypeOf(String entityName, EclipseLinkCacheType newCacheType) {
        EclipseLinkCachingEntity old = this.setEntityCacheTypeOf(entityName, newCacheType);
        this.putEnumValue("eclipselink.cache.type.", entityName, newCacheType, false);
        this.firePropertyChanged("cacheType", old, this.getEntityNamed(entityName));
    }

    private void cacheTypeChanged(String propertyName, String stringValue) {
        String entityName = this.extractEntityNameOf(propertyName);
        if (!StringTools.isBlank((String)entityName)) {
            EclipseLinkCachingEntity old = this.setEntityCacheTypeOf(entityName, stringValue);
            this.firePropertyChanged("cacheType", old, this.getEntityNamed(entityName));
        }
    }

    @Override
    public EclipseLinkCacheType getDefaultCacheType() {
        return this.cacheTypeDefault == null ? DEFAULT_CACHE_TYPE : this.cacheTypeDefault;
    }

    @Override
    public Integer getCacheSizeOf(String entityName) {
        EclipseLinkCachingEntity entity = this.getEntityNamed(entityName);
        return entity == null ? null : entity.getCacheSize();
    }

    @Override
    public void setCacheSizeOf(String entityName, Integer newCacheSize) {
        EclipseLinkCachingEntity old = this.setEntityCacheSizeOf(entityName, newCacheSize);
        this.putIntegerValue("eclipselink.cache.size." + entityName, newCacheSize);
        this.firePropertyChanged("cacheSize", old, this.getEntityNamed(entityName));
    }

    private void cacheSizeChanged(String propertyName, String stringValue) {
        String entityName = this.extractEntityNameOf(propertyName);
        if (!StringTools.isBlank((String)entityName)) {
            EclipseLinkCachingEntity old = this.setEntityCacheSizeOf(entityName, stringValue);
            this.firePropertyChanged("cacheSize", old, this.getEntityNamed(entityName));
        }
    }

    @Override
    public Integer getDefaultCacheSize() {
        return this.cacheSizeDefault == null ? DEFAULT_CACHE_SIZE : this.cacheSizeDefault;
    }

    @Override
    public Boolean getSharedCacheOf(String entityName) {
        EclipseLinkCachingEntity entity = this.getEntityNamed(entityName);
        return entity == null ? null : entity.cacheIsShared();
    }

    @Override
    public void setSharedCacheOf(String entityName, Boolean newSharedCache) {
        EclipseLinkCachingEntity old = this.setEntitySharedCacheOf(entityName, newSharedCache);
        this.putBooleanValue("eclipselink.cache.shared.", entityName, newSharedCache, false);
        this.firePropertyChanged("sharedCache", old, this.getEntityNamed(entityName));
    }

    private void sharedCacheChanged(String propertyName, String stringValue) {
        String entityName = this.extractEntityNameOf(propertyName);
        if (!StringTools.isBlank((String)entityName)) {
            EclipseLinkCachingEntity old = this.setEntitySharedCacheOf(entityName, stringValue);
            this.firePropertyChanged("sharedCache", old, this.getEntityNamed(entityName));
        }
    }

    @Override
    public Boolean getDefaultSharedCache() {
        return this.sharedCacheDefault == null ? DEFAULT_SHARED_CACHE : this.sharedCacheDefault;
    }

    @Override
    public EclipseLinkCacheType getCacheTypeDefault() {
        return this.cacheTypeDefault;
    }

    @Override
    public void setCacheTypeDefault(EclipseLinkCacheType newCacheTypeDefault) {
        EclipseLinkCacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newCacheTypeDefault;
        this.putProperty("cacheTypeDefault", newCacheTypeDefault);
        this.firePropertyChanged("cacheTypeDefault", (Object)old, (Object)newCacheTypeDefault);
    }

    private void cacheTypeDefaultChanged(String stringValue) {
        EclipseLinkCacheType newValue = (EclipseLinkCacheType)this.getEnumValueOf(stringValue, EclipseLinkCacheType.values());
        EclipseLinkCacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newValue;
        this.firePropertyChanged("cacheTypeDefault", (Object)old, (Object)newValue);
    }

    @Override
    public EclipseLinkCacheType getDefaultCacheTypeDefault() {
        return DEFAULT_CACHE_TYPE_DEFAULT;
    }

    @Override
    public Integer getCacheSizeDefault() {
        return this.cacheSizeDefault;
    }

    @Override
    public void setCacheSizeDefault(Integer newCacheSizeDefault) {
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newCacheSizeDefault;
        this.putProperty("cacheSizeDefault", newCacheSizeDefault);
        this.firePropertyChanged("cacheSizeDefault", old, newCacheSizeDefault);
    }

    private void cacheSizeDefaultChanged(String stringValue) {
        Integer newValue = this.getIntegerValueOf(stringValue);
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newValue;
        this.firePropertyChanged("cacheSizeDefault", old, newValue);
    }

    @Override
    public Integer getDefaultCacheSizeDefault() {
        return DEFAULT_CACHE_SIZE_DEFAULT;
    }

    @Override
    public Boolean getSharedCacheDefault() {
        return this.sharedCacheDefault;
    }

    @Override
    public void setSharedCacheDefault(Boolean newSharedCacheDefault) {
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newSharedCacheDefault;
        this.putProperty("sharedCacheDefault", newSharedCacheDefault);
        this.firePropertyChanged("sharedCacheDefault", old, newSharedCacheDefault);
    }

    private void sharedCacheDefaultChanged(String stringValue) {
        Boolean newValue = this.getBooleanValueOf(stringValue);
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newValue;
        this.firePropertyChanged("sharedCacheDefault", old, newValue);
    }

    @Override
    public Boolean getDefaultSharedCacheDefault() {
        return DEFAULT_SHARED_CACHE_DEFAULT;
    }

    @Override
    public EclipseLinkFlushClearCache getFlushClearCache() {
        return this.flushClearCache;
    }

    @Override
    public void setFlushClearCache(EclipseLinkFlushClearCache newFlushClearCache) {
        EclipseLinkFlushClearCache old = this.flushClearCache;
        this.flushClearCache = newFlushClearCache;
        this.putProperty("flushClearCache", newFlushClearCache);
        this.firePropertyChanged("flushClearCache", (Object)old, (Object)newFlushClearCache);
    }

    private void flushClearCacheChanged(String stringValue) {
        EclipseLinkFlushClearCache newValue = (EclipseLinkFlushClearCache)this.getEnumValueOf(stringValue, EclipseLinkFlushClearCache.values());
        EclipseLinkFlushClearCache old = this.flushClearCache;
        this.flushClearCache = newValue;
        this.firePropertyChanged("flushClearCache", (Object)old, (Object)newValue);
    }

    @Override
    public EclipseLinkFlushClearCache getDefaultFlushClearCache() {
        return DEFAULT_FLUSH_CLEAR_CACHE;
    }

    private EclipseLinkCachingEntity setEntityCacheTypeOf(String entityName, String stringValue) {
        if (!this.entityExists(entityName) && StringTools.isBlank((String)stringValue)) {
            return null;
        }
        EclipseLinkCacheType newValue = (EclipseLinkCacheType)this.getEnumValueOf(stringValue, EclipseLinkCacheType.values());
        return this.setEntityCacheTypeOf(entityName, newValue);
    }

    private EclipseLinkCachingEntity setEntityCacheTypeOf(String entityName, EclipseLinkCacheType cacheType) {
        EclipseLinkCachingEntity entity = this.entityExists(entityName) ? this.getEntityNamed(entityName) : this.addEntity(entityName);
        return this.setEntityCacheTypeOf(entity, cacheType);
    }

    private EclipseLinkCachingEntity setEntityCacheTypeOf(EclipseLinkCachingEntity entity, EclipseLinkCacheType cacheType) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        EclipseLinkCachingEntity old = entity.clone();
        entity.setCacheType(cacheType);
        return old;
    }

    private void setEntityCacheTypeOf(PersistenceUnit.Property cacheTypeProperty) {
        String entityName = this.extractEntityNameOf(cacheTypeProperty);
        this.setEntityCacheTypeOf(entityName, cacheTypeProperty.getValue());
    }

    private EclipseLinkCachingEntity setEntityCacheSizeOf(String entityName, String stringValue) {
        if (!this.entityExists(entityName) && StringTools.isBlank((String)stringValue)) {
            return null;
        }
        Integer newValue = this.getIntegerValueOf(stringValue);
        return this.setEntityCacheSizeOf(entityName, newValue);
    }

    private EclipseLinkCachingEntity setEntityCacheSizeOf(String entityName, Integer size) {
        EclipseLinkCachingEntity entity = this.entityExists(entityName) ? this.getEntityNamed(entityName) : this.addEntity(entityName);
        return this.setEntityCacheSizeOf(entity, size);
    }

    private EclipseLinkCachingEntity setEntityCacheSizeOf(EclipseLinkCachingEntity entity, Integer size) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        EclipseLinkCachingEntity old = entity.clone();
        entity.setCacheSize(size);
        return old;
    }

    private void setEntityCacheSizeOf(PersistenceUnit.Property cacheSizeProperty) {
        String entityName = this.extractEntityNameOf(cacheSizeProperty);
        this.setEntityCacheSizeOf(entityName, cacheSizeProperty.getValue());
    }

    private EclipseLinkCachingEntity setEntitySharedCacheOf(String entityName, String stringValue) {
        if (!this.entityExists(entityName) && StringTools.isBlank((String)stringValue)) {
            return null;
        }
        Boolean newValue = this.getBooleanValueOf(stringValue);
        return this.setEntitySharedCacheOf(entityName, newValue);
    }

    private EclipseLinkCachingEntity setEntitySharedCacheOf(String entityName, Boolean sharedCache) {
        EclipseLinkCachingEntity entity = this.entityExists(entityName) ? this.getEntityNamed(entityName) : this.addEntity(entityName);
        return this.setEntitySharedCacheOf(entity, sharedCache);
    }

    private EclipseLinkCachingEntity setEntitySharedCacheOf(EclipseLinkCachingEntity entity, Boolean sharedCache) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        EclipseLinkCachingEntity old = entity.clone();
        entity.setSharedCache(sharedCache);
        return old;
    }

    private void setEntitySharedCacheOf(PersistenceUnit.Property sharedCacheProperty) {
        String entityName = this.extractEntityNameOf(sharedCacheProperty);
        this.setEntitySharedCacheOf(entityName, sharedCacheProperty.getValue());
    }

    private void clearEntity(EclipseLinkCachingEntity entity) {
        if (entity.isEmpty()) {
            return;
        }
        String entityName = entity.getName();
        this.setCacheTypeOf(entityName, null);
        this.setCacheSizeOf(entityName, null);
        this.setSharedCacheOf(entityName, null);
    }

    private EclipseLinkCachingEntity getEntityNamed(String name) {
        for (EclipseLinkCachingEntity entity : this.entities) {
            if (!entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    private EclipseLinkCachingEntity buildEntity(String name) {
        return new EclipseLinkCachingEntity(this, name);
    }

    private void removeEntity(EclipseLinkCachingEntity entity) {
        if (entity == null) {
            throw new NullPointerException();
        }
        this.removeItemFromList(entity, this.entities, "entities");
    }

    @Override
    public boolean entityExists(String name) {
        for (EclipseLinkCachingEntity entity : this.entities) {
            if (!entity.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeDefaultCachingProperties() {
        this.setCacheTypeDefault(null);
        this.setCacheSizeDefault(null);
        this.setFlushClearCache(null);
    }

    @Override
    public ListIterable<EclipseLinkCachingEntity> getEntities() {
        return IterableTools.cloneLive(this.entities);
    }

    @Override
    public Iterable<String> getEntityNames() {
        return IterableTools.transform(this.getEntities(), EclipseLinkCachingEntity.NAME_TRANSFORMER);
    }

    @Override
    public int getEntitiesSize() {
        return this.entities.size();
    }
}

