/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NameStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStringArrayExpressionConverter
extends AbstractExpressionConverter<String[]>
implements IndexedExpressionConverter<String> {
    private final ExpressionConverter<String> elementConverter;
    private final StringArrayExpressionConverter arrayConverter;

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter) {
        this(elementConverter, true);
    }

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter, boolean removeArrayInitializerWhenEmpty) {
        this.elementConverter = elementConverter;
        this.arrayConverter = new StringArrayExpressionConverter(elementConverter, removeArrayInitializerWhenEmpty);
    }

    @Override
    protected Expression convertObject(String[] strings, AST ast) {
        return strings.length == 1 ? this.elementConverter.convert(strings[0], ast) : this.arrayConverter.convertObject(strings, ast);
    }

    @Override
    protected String[] convertNull() {
        return this.arrayConverter.convertNull();
    }

    @Override
    protected String[] convertExpression(Expression expression) {
        return expression.getNodeType() == 4 ? this.convertArrayInitializer((ArrayInitializer)expression) : this.convertNonArrayInitializer(expression);
    }

    protected String[] convertArrayInitializer(ArrayInitializer arrayInitializer) {
        return this.arrayConverter.convertArrayInitializer(arrayInitializer);
    }

    protected String[] convertNonArrayInitializer(Expression expression) {
        String[] stringArray;
        String element = this.elementConverter.convert(expression);
        if (element == null) {
            stringArray = StringTools.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = element;
        }
        return stringArray;
    }

    @Override
    public Expression selectExpression(Expression expression, int index) {
        if (expression.getNodeType() == 4) {
            return this.arrayConverter.selectExpression(expression, index);
        }
        if (index == 0) {
            return expression;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static AnnotationStringArrayExpressionConverter forStrings() {
        return new AnnotationStringArrayExpressionConverter(StringExpressionConverter.instance());
    }

    public static AnnotationStringArrayExpressionConverter forNames() {
        return new AnnotationStringArrayExpressionConverter(NameStringExpressionConverter.instance());
    }

    public static AnnotationStringArrayExpressionConverter forTypes() {
        return new AnnotationStringArrayExpressionConverter(TypeStringExpressionConverter.instance());
    }
}

