/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddInheritedEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateIsARelationFeature
extends AbstractCreateConnectionFeature {
    private PersistentType superclass;

    public CreateIsARelationFeature(IFeatureProvider fp) {
        this(fp, JPAEditorMessages.CreateIsARelationFeature_CreateIsARelationFeatureName, JPAEditorMessages.CreateIsARelationFeature_CreateIsARelationFeatureDescription);
    }

    public CreateIsARelationFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        this.superclass = this.getPersistentType(context.getSourceAnchor());
        PersistentType subclass = this.getPersistentType(context.getTargetAnchor());
        if (this.superclass == null || subclass == null) {
            return false;
        }
        if (this.superclass.getName().equals(subclass.getName())) {
            return false;
        }
        if (!JpaArtifactFactory.instance().isEntity(subclass) || subclass.getSuperPersistentType() != null) {
            return false;
        }
        return JpaArtifactFactory.instance().isEntity(this.superclass) || JpaArtifactFactory.instance().isMappedSuperclass(this.superclass);
    }

    public Connection create(ICreateConnectionContext context) {
        this.superclass = this.getPersistentType(context.getSourceAnchor());
        PersistentType subclass = this.getPersistentType(context.getTargetAnchor());
        if (JpaArtifactFactory.instance().hasOrInheritsPrimaryKey(this.superclass)) {
            for (PersistentAttribute jpa : subclass.getAttributes()) {
                if (jpa.getMappingKey().equals("id")) {
                    jpa.getJavaPersistentAttribute().setMappingKey("basic");
                    continue;
                }
                if (!jpa.getMappingKey().equals("embeddedId")) continue;
                jpa.getJavaPersistentAttribute().setMappingKey("embedded");
            }
        }
        JpaArtifactFactory.instance().buildHierarchy(this.superclass, subclass, true);
        JPAEditorUtil.createImport(JPAEditorUtil.getCompilationUnit(subclass), this.superclass.getName());
        IsARelation rel = new IsARelation(subclass, this.superclass);
        AddInheritedEntityFeature ft = new AddInheritedEntityFeature(this.getFeatureProvider());
        AddConnectionContext cont = new AddConnectionContext(context.getTargetAnchor(), context.getSourceAnchor());
        cont.setNewObject((Object)rel);
        Connection connection = (Connection)ft.add((IAddContext)cont);
        return connection;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        this.superclass = this.getPersistentType(context.getSourceAnchor());
        return this.superclass != null;
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.derive_jpt";
    }

    protected PersistentType getPersistentType(Anchor anchor) {
        Object refObject;
        if (anchor != null && (refObject = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof PersistentType) {
            return (PersistentType)refObject;
        }
        return null;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void startConnecting() {
        super.startConnecting();
        this.disableAllEmbeddables();
    }

    public void attachedToSource(ICreateConnectionContext context) {
        super.attachedToSource(context);
        this.getFeatureProvider().setOriginalPersistentTypeColor();
        this.disableUnvalidRelationTargets();
    }

    public void endConnecting() {
        super.endConnecting();
        this.getFeatureProvider().setOriginalPersistentTypeColor();
    }

    private void disableUnvalidRelationTargets() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextModelRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (JpaArtifactFactory.instance().isEntity((PersistentType)jpt) && !this.superclass.getName().equals(jpt.getName()) && jpt.getSuperPersistentType() == null) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private void disableAllEmbeddables() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextModelRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (!JpaArtifactFactory.instance().isEmbeddable((PersistentType)jpt)) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }
}

