/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEjbSession;
import org.eclipse.jst.ws.jaxws.dom.integration.internal.plugin.DomIntegrationMessages;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IJavaWebServiceElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMRuntimeManager;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.jst.ws.jaxws.utils.resources.ProjectManagementUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.actions.SelectionListenerAction;

public class NavigateToImplementationAction
extends SelectionListenerAction
implements IActionDelegate2 {
    protected Object srcObject;
    private IJavaProject project;
    private StructuredViewer viewer;

    protected NavigateToImplementationAction(StructuredViewer viewer) {
        this(DomIntegrationMessages.OpenWSResourceAction_Name);
        this.viewer = viewer;
    }

    protected NavigateToImplementationAction(String text) {
        super(text);
    }

    public String getText() {
        if (this.srcObject instanceof SessionBean) {
            return DomIntegrationMessages.NavigateToImplementationAction_ShowInWebServicesAreaAction;
        }
        return DomIntegrationMessages.NavigateToImplementationAction_ShowInEJBAreaAction;
    }

    public boolean isEnabled() {
        boolean isEnabled;
        boolean bl = isEnabled = super.isEnabled() && this.viewer instanceof TreeViewer && this.project != null && ProjectManagementUtils.isEjb3Project((String)this.project.getProject().getName());
        if (this.srcObject instanceof IWebService) {
            return isEnabled;
        }
        if (this.srcObject instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)this.srcObject;
            IWebService webService = this.getWebService(sessionBean);
            if (webService == null) {
                return false;
            }
            return isEnabled;
        }
        if (this.srcObject instanceof IServiceEndpointInterface && ((IServiceEndpointInterface)this.srcObject).isImplicit()) {
            return isEnabled;
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        ICompilationUnit cu = null;
        if (this.srcObject instanceof SessionBean) {
            String impl;
            SessionBean sessionBean = (SessionBean)this.srcObject;
            String ejbClass = sessionBean.getEjbClass();
            IWebService webService = this.getWebService(sessionBean);
            if (webService == null) {
                return;
            }
            IServiceEndpointInterface sEI = webService.getServiceEndpoint();
            boolean isImplicit = sEI.isImplicit();
            String sEIClass = !isImplicit ? (impl = sEI.getImplementation()) : ejbClass;
            try {
                cu = this.project.findType(sEIClass).getCompilationUnit();
                IResource resource = cu.getResource();
                this.moveToSEINode(resource);
            }
            catch (JavaModelException jme) {
                this.logger().logError("Unexpected exception occurred", (Throwable)jme);
                return;
            }
        }
        try {
            cu = this.project.findType(((IJavaWebServiceElement)this.srcObject).getImplementation()).getCompilationUnit();
        }
        catch (JavaModelException jme) {
            this.logger().logError("Unexpected exception occurred", (Throwable)jme);
            return;
        }
        this.moveToEjbNode(cu.getResource());
    }

    protected IWebService getWebService(SessionBean sessionBean) {
        IDOM dom;
        block4: {
            IWsDOMRuntimeExtension domRuntime = this.getDomRuntime();
            if (domRuntime == null) {
                return null;
            }
            try {
                dom = domRuntime.getDOM();
                if (dom != null) break block4;
                return null;
            }
            catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {
                return null;
            }
        }
        IWebServiceProject webServiceProject = DomUtil.INSTANCE.findProjectByName(dom, this.project.getProject().getName());
        return DomUtil.INSTANCE.findWsByImplName(webServiceProject, sessionBean.getEjbClass());
    }

    protected IWsDOMRuntimeExtension getDomRuntime() {
        return WsDOMRuntimeManager.instance().getDOMRuntime("org.eclipse.jst.ws.jaxws.dom.jee5");
    }

    private void moveToSEINode(IResource resource) {
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        StructuredSelection sel = null;
        Object[] expandedObjects = treeViewer.getExpandedElements();
        Object[] projectElements = ((ITreeContentProvider)treeViewer.getContentProvider()).getChildren((Object)this.project.getProject());
        IWebServiceProject wsProject = null;
        int ii = 0;
        while (ii < projectElements.length) {
            if (projectElements[ii] instanceof IWebServiceProject) {
                wsProject = (IWebServiceProject)projectElements[ii];
                treeViewer.expandToLevel((Object)wsProject, 2);
                break;
            }
            ++ii;
        }
        if (wsProject == null) {
            return;
        }
        for (IServiceEndpointInterface sEI : wsProject.getServiceEndpointInterfaces()) {
            try {
                ICompilationUnit cu = this.project.findType(sEI.getImplementation()).getCompilationUnit();
                if (!cu.getResource().equals((Object)resource)) continue;
                sel = new StructuredSelection((Object)sEI);
                TreePath treePath = this.getTreePathForSEI(treeViewer, wsProject);
                Object[] elementsToExpand = new Object[treePath.getSegmentCount()];
                int jj = 0;
                while (jj < elementsToExpand.length) {
                    if (this.notAlreadyExpanded(treePath.getSegment(jj), expandedObjects)) {
                        elementsToExpand[jj] = treePath.getSegment(jj);
                    }
                    ++jj;
                }
                jj = 0;
                while (jj < elementsToExpand.length) {
                    if (elementsToExpand[jj] != null) {
                        Object[] tmp = expandedObjects;
                        expandedObjects = new Object[expandedObjects.length + 1];
                        int kk = 0;
                        while (kk < tmp.length) {
                            expandedObjects[kk] = tmp[kk];
                            ++kk;
                        }
                        expandedObjects[expandedObjects.length - 1] = elementsToExpand[jj];
                    }
                    ++jj;
                }
                break;
            }
            catch (JavaModelException jme) {
                this.logger().logError("Unexpected exception occurred", (Throwable)jme);
                return;
            }
        }
        this.setExpandedElementsAndSelection(treeViewer, expandedObjects, (ISelection)sel);
    }

    private void moveToEjbNode(IResource resource) {
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        StructuredSelection sel = null;
        Object[] expandedObjects = treeViewer.getExpandedElements();
        Object[] projectElements = ((ITreeContentProvider)treeViewer.getContentProvider()).getChildren((Object)this.project.getProject());
        GroupEJBProvider ejbProvider = null;
        GroupEjbSession ejbSession = null;
        int ii = 0;
        while (ii < projectElements.length) {
            if (projectElements[ii] instanceof GroupEJBProvider) {
                ejbProvider = (GroupEJBProvider)projectElements[ii];
                treeViewer.expandToLevel((Object)ejbProvider, 1);
                break;
            }
            ++ii;
        }
        if (ejbProvider == null) {
            return;
        }
        for (Object ejbProviderChild : ejbProvider.getChildren()) {
            if (!(ejbProviderChild instanceof GroupEjbSession)) continue;
            ejbSession = (GroupEjbSession)ejbProviderChild;
            treeViewer.expandToLevel((Object)ejbSession, 2);
        }
        if (ejbSession == null) {
            return;
        }
        Object[] ejbs = treeViewer.getExpandedElements();
        int ii2 = 0;
        while (ii2 < ejbs.length) {
            if (ejbs[ii2] instanceof SessionBean || ejbs[ii2] instanceof MessageDrivenBean) {
                IJavaProject javaProject = this.findJavaProject(ejbs[ii2]);
                IType t = null;
                try {
                    t = ejbs[ii2] instanceof SessionBean ? javaProject.findType(((SessionBean)ejbs[ii2]).getEjbClass()) : javaProject.findType(((MessageDrivenBean)ejbs[ii2]).getEjbClass());
                }
                catch (JavaModelException javaModelException) {
                    return;
                }
                IResource r = t.getResource();
                if (r.equals((Object)resource)) {
                    sel = new StructuredSelection(ejbs[ii2]);
                    TreePath treePath = this.getTreePathForObject(treeViewer, ejbs[ii2]);
                    this.expandElements(expandedObjects, treePath);
                    break;
                }
            }
            ++ii2;
        }
        this.setExpandedElementsAndSelection(treeViewer, expandedObjects, (ISelection)sel);
    }

    protected IJavaProject findJavaProject(Object ejb) {
        IProject proj = ProjectUtilities.getProject((Object)ejb);
        return JavaCore.create((IProject)proj);
    }

    private void setExpandedElementsAndSelection(TreeViewer treeViewer, Object[] expandedObjects, ISelection sel) {
        treeViewer.setExpandedElements(expandedObjects);
        if (sel != null) {
            treeViewer.setSelection(sel, true);
        }
    }

    private void expandElements(Object[] expandedObjects, TreePath treePath) {
        Object[] elementsToExpand = new Object[treePath.getSegmentCount()];
        int jj = 0;
        while (jj < elementsToExpand.length) {
            if (this.notAlreadyExpanded(treePath.getSegment(jj), expandedObjects)) {
                elementsToExpand[jj] = treePath.getSegment(jj);
            }
            ++jj;
        }
        jj = 0;
        while (jj < elementsToExpand.length) {
            if (elementsToExpand[jj] != null) {
                Object[] tmp = expandedObjects;
                expandedObjects = new Object[expandedObjects.length + 1];
                int kk = 0;
                while (kk < tmp.length) {
                    expandedObjects[kk] = tmp[kk];
                    ++kk;
                }
                expandedObjects[expandedObjects.length - 1] = elementsToExpand[jj];
            }
            ++jj;
        }
    }

    private boolean notAlreadyExpanded(Object obj, Object[] expObjs) {
        int ii = 0;
        while (ii < expObjs.length) {
            if (expObjs[ii].equals(obj)) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    private TreePath getTreePathForSEI(TreeViewer treeViewer, IWebServiceProject wsProject) {
        TreePath[] treePaths = treeViewer.getExpandedTreePaths();
        int ii = 0;
        while (ii < treePaths.length) {
            if (treePaths[ii].getLastSegment() instanceof ISEIChildList && this.contains(treePaths[ii], wsProject)) {
                return treePaths[ii];
            }
            ++ii;
        }
        return null;
    }

    private boolean contains(TreePath treePath, IWebServiceProject wsProject) {
        int ii = 0;
        while (ii < treePath.getSegmentCount()) {
            if (treePath.getSegment(ii).equals(wsProject)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    private TreePath getTreePathForObject(TreeViewer treeViewer, Object obj) {
        TreePath[] treePaths = treeViewer.getExpandedTreePaths();
        int ii = 0;
        while (ii < treePaths.length) {
            if (treePaths[ii].getLastSegment().equals(obj)) {
                return treePaths[ii];
            }
            ++ii;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateSelection((IStructuredSelection)selection);
    }

    public void selectionChanged(IStructuredSelection selection, IJavaProject project) {
        super.selectionChanged(selection);
        this.project = project;
    }

    public boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        this.srcObject = s.getFirstElement();
        return true;
    }

    private ILogger logger() {
        return new Logger();
    }

    public void dispose() {
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }
}

