/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.j2ee.internal.command.AbstractOverrideCommand;
import org.eclipse.jst.j2ee.internal.command.J2EEClipboard;

public class J2EERemoveOverrideCommand
extends AbstractOverrideCommand {
    private RemoveCommand bindingsRemoveCommand;
    private RemoveCommand extensionsRemoveCommand;
    private ResourceSet resourceSet;

    protected J2EERemoveOverrideCommand() {
    }

    public J2EERemoveOverrideCommand(RemoveCommand command) {
        super((AbstractOverrideableCommand)command);
    }

    protected RemoveCommand createRemoveCommand(Collection elements) {
        return (RemoveCommand)RemoveCommand.create((EditingDomain)this.getDomain(), (Collection)elements);
    }

    public void execute() {
        Collection objects = this.getRemoveCommand().getCollection();
        ArrayList bindings = new ArrayList(objects.size());
        ArrayList extensions = new ArrayList(objects.size());
        for (EObject o : objects) {
            if (this.resourceSet != null) continue;
            this.resourceSet = o.eResource().getResourceSet();
        }
        if (!bindings.isEmpty()) {
            this.setBindingsRemoveCommand(this.createRemoveCommand(bindings));
        }
        if (!extensions.isEmpty()) {
            this.setExtensionsRemoveCommand(this.createRemoveCommand(extensions));
        }
        this.executeAllChildren();
    }

    protected void executeAllChildren() {
        this.executeNested(this.bindingsRemoveCommand);
        this.executeNested(this.extensionsRemoveCommand);
        this.getOverridable().doExecute();
    }

    protected void executeNested(RemoveCommand cmd) {
        if (cmd != null && cmd.doCanExecute()) {
            cmd.doExecute();
        }
    }

    protected RemoveCommand getBindingsRemoveCommand() {
        return this.bindingsRemoveCommand;
    }

    protected RemoveCommand getExtensionsRemoveCommand() {
        return this.extensionsRemoveCommand;
    }

    public RemoveCommand getRemoveCommand() {
        return (RemoveCommand)this.getOverridable();
    }

    protected boolean prepare() {
        this.setJ2eeClipboard(new J2EEClipboard(this.getRemoveCommand().getCollection()));
        return true;
    }

    public void redo() {
        this.executeAllChildren();
    }

    protected void setBindingsRemoveCommand(RemoveCommand newBindingsRemoveCommand) {
        this.bindingsRemoveCommand = newBindingsRemoveCommand;
    }

    protected void setExtensionsRemoveCommand(RemoveCommand newExtensionsRemoveCommand) {
        this.extensionsRemoveCommand = newExtensionsRemoveCommand;
    }

    public void undo() {
        this.getRemoveCommand().doUndo();
        this.undoNested(this.bindingsRemoveCommand);
        this.undoNested(this.extensionsRemoveCommand);
    }

    protected void undoNested(RemoveCommand cmd) {
        if (cmd != null && cmd.doCanUndo()) {
            cmd.doUndo();
        }
    }
}

