/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.jca.AuthenticationMechanism;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;
import org.eclipse.jst.j2ee.jca.SecurityPermission;

public class RarFileTests
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public RarFileTests(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.RarFileTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public void printRARToConsole(Connector connector) {
        ResourceAdapter ra = connector.getResourceAdapter();
        System.out.println("ResourceAdapter from XML Deployment Descriptor");
        System.out.println("-------------------------------------------------");
        System.out.println(String.valueOf(connector.getDisplayName()) + ": " + connector.getDescription());
        System.out.println("Vendor : " + connector.getVendorName());
        System.out.println("Version : " + connector.getVersion());
        System.out.println("Spec Version : " + connector.getSpecVersion());
        System.out.println("EIS Type : " + connector.getEisType());
        System.out.println("Reauthentication Support : " + ra.isReauthenticationSupport());
        System.out.println("Transaction Support : " + ra.getTransactionSupport().getName().toLowerCase());
        if (connector.getLicense() != null) {
            System.out.println("License Required : " + connector.getLicense().isRequired());
            System.out.println("License Description : " + connector.getLicense().getDescription());
        }
        System.out.println("Small Icon : " + connector.getSmallIcon());
        System.out.println("Large Icon : " + connector.getLargeIcon());
        EList authMechs = ra.getAuthenticationMechanisms();
        int i = 0;
        while (i < authMechs.size()) {
            AuthenticationMechanism auth = (AuthenticationMechanism)authMechs.get(i);
            System.out.println("\nAuthentication Mechanism:");
            System.out.println("Description : " + auth.getDescription());
            System.out.println("Type : " + auth.getAuthenticationMechanismType().getName().toLowerCase());
            System.out.println("Credential Interface : " + auth.getCredentialInterface());
            ++i;
        }
        System.out.println("\nRegistered classes:");
        System.out.println("\t" + ra.getConnectionFactoryImplClass() + " implements ");
        System.out.println("\t\t" + ra.getConnectionFactoryInterface());
        System.out.println("\t" + ra.getConnectionImplClass() + " implements ");
        System.out.println("\t\t" + ra.getConnectionInterface());
        System.out.println("\tManagedConnectionFactory: " + ra.getManagedConnectionFactoryClass());
        EList configs = ra.getConfigProperties();
        System.out.println("\nConfig-properties:");
        int i2 = 0;
        while (i2 < configs.size()) {
            ConfigProperty prop = (ConfigProperty)configs.get(i2);
            System.out.println("\tConfig-property : " + prop.getName());
            System.out.println("\tType : " + prop.getType() + " / Value : " + prop.getValue());
            System.out.println("\tDescription : " + prop.getDescription() + "\n");
            ++i2;
        }
        EList secs = ra.getSecurityPermissions();
        System.out.println("\nSecurity-Permissions:");
        int i3 = 0;
        while (i3 < secs.size()) {
            SecurityPermission prop = (SecurityPermission)secs.get(i3);
            System.out.println("\tConfig-Description : " + prop.getDescription());
            System.out.println("\tSpecification : " + prop.getSpecification() + "\n");
            ++i3;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.RarFileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testaddCopyModule() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        rarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/newEarWithRarCopiedModule.ear");
        newEarFile.addCopy((ModuleFile)rarFile);
        RARFile copied = (RARFile)newEarFile.getModuleFiles().get(0);
        RarFileTests.assertTrue((boolean)copied.isDeploymentDescriptorSet());
        RarFileTests.assertTrue((copied.getDeploymentDescriptor() == copied.getDeploymentDescriptorResource().getContents().get(0) ? 1 : 0) != 0);
        RarFileTests.assertTrue((copied.getDeploymentDescriptor() != rarFile.getDeploymentDescriptor() ? 1 : 0) != 0);
        RarFileTests.assertTrue((rarFile.getFiles().size() == copied.getFiles().size() ? 1 : 0) != 0);
        newEarFile.saveNoReopen();
    }

    public void testexpandRarModule() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        rarFile.setURI("sample.rar");
        rarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/RarTests/newEarWithRarModule.ear");
        newEarFile.addCopy((ModuleFile)rarFile);
        newEarFile.saveNoReopen();
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/RarTests/Rar-containing-ear-out.ear";
        newEarFile.extractTo(out, 64);
    }

    public void testOpenAndExtract() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Exploded_RAR_Dir/";
        rarFile.extractToConnectorDirectory(out, 126);
    }

    public void testOpenAndRead() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        rarFile.getDeploymentDescriptor();
    }

    public void testopenRarEar() throws Exception {
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "testrar.ear");
        RarFileTests.assertTrue((earFile.getDeploymentDescriptor().getFirstModule("sample.rar") != null ? 1 : 0) != 0);
    }

    public void testSaveRarEar() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        rarFile.setURI("sample.rar");
        rarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/RarTests/newEarWithRarModule_saved.ear");
        newEarFile.addCopy((ModuleFile)rarFile);
        RarFileTests.assertNotNull((String)"Module wasn't found!", (Object)newEarFile.getDeploymentDescriptor().getFirstModule("sample.rar"));
        newEarFile.save();
    }

    public void testJ2Cauth() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.rar";
        RARFile rarFile = (RARFile)this.getArchiveFactory().openArchive(in);
        Connector dd = rarFile.getDeploymentDescriptor();
        ResourceAdapter rd = dd.getResourceAdapter();
        rd.getAuthenticationMechanisms();
    }
}

