/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.archive.test.AbstractArchiveTest;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class ResourceTests
extends AbstractArchiveTest {
    static /* synthetic */ Class class$0;

    public ResourceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.ResourceTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.ResourceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected List findOccurrences(List resources, String uri) {
        ArrayList<Resource> result = new ArrayList<Resource>(1);
        int i = 0;
        while (i < resources.size()) {
            Resource aResource = (Resource)resources.get(i);
            if (uri.equals(aResource.getURI().toString())) {
                result.add(aResource);
            }
            ++i;
        }
        return result;
    }

    public void testResourceCreation() throws Exception {
        String uri = "META-INF/client-resource.xmi";
        ApplicationClientFile appClientFile = ResourceTests.getArchiveFactory().createApplicationClientFileInitialized("test.jar");
        Resource res = null;
        boolean exceptionCaught = false;
        try {
            res = appClientFile.getMofResource(uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            exceptionCaught = true;
            List foundResources = this.findOccurrences((List)appClientFile.getResourceSet().getResources(), uri);
            ResourceTests.assertTrue((String)"There should exist exactly one resource", (foundResources.size() == 1 ? 1 : 0) != 0);
            Resource foundResource = (Resource)foundResources.get(0);
            ResourceTests.assertFalse((String)"The resource should be unloaded", (boolean)foundResource.isLoaded());
            res = appClientFile.makeMofResource(uri);
            ResourceTests.assertTrue((String)"Resource should not be null", (res != null ? 1 : 0) != 0);
            foundResources = this.findOccurrences((List)appClientFile.getResourceSet().getResources(), uri);
            ResourceTests.assertTrue((String)"There should exist exactly one resource", (foundResources.size() == 1 ? 1 : 0) != 0);
            foundResource = (Resource)foundResources.get(0);
            ResourceTests.assertTrue((String)"The resource should exist", (foundResource != null ? 1 : 0) != 0);
            ResourceTests.assertFalse((String)"The resource should be unloaded", (boolean)foundResource.isLoaded());
        }
        ResourceTests.assertTrue((String)"Exception should have been caught", (boolean)exceptionCaught);
        Collection loadedResources = appClientFile.getLoadedMofResources();
        ResourceTests.assertTrue((String)"Loaded resources should be size 1", (loadedResources.size() == 1 ? 1 : 0) != 0);
        EjbRef aRef = CommonPackage.eINSTANCE.getCommonFactory().createEjbRef();
        res.getContents().add((Object)aRef);
        loadedResources = appClientFile.getLoadedMofResources();
        ResourceTests.assertTrue((String)"Loaded resources should be size 2", (loadedResources.size() == 2 ? 1 : 0) != 0);
    }

    public void testResourceDirty() throws Exception {
        EJBJarFile jar = ResourceTests.getArchiveFactory().openEJB11JarFile(String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar");
        EnterpriseBean cfr_ignored_0 = (EnterpriseBean)jar.getDeploymentDescriptor().getEnterpriseBeans().get(0);
        EARFile newEar = ResourceTests.getArchiveFactory().createEARFileInitialized("test");
        EJBJarFile copyJar = (EJBJarFile)newEar.addCopy((ModuleFile)jar);
        ResourceTests.assertFalse((String)"dd should not be dirty", (boolean)copyJar.getDeploymentDescriptorResource().isModified());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArchiveInit.init();
    }
}

