/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.jst.j2ee.archive.test.AbstractArchiveTest;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class SecurityRoleTests
extends AbstractArchiveTest {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public SecurityRoleTests(String name) {
        super(name);
    }

    public CommonFactory getCommonFactory() {
        return CommonPackage.eINSTANCE.getCommonFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.SecurityRoleTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.SecurityRoleTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testPushDownCopy() throws Exception {
        EARFile earFile = SecurityRoleTests.getArchiveFactory().openEARFile(String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear");
        WARFile warFile = (WARFile)earFile.getWARFiles().get(0);
        EJBJarFile ejbJarFile = (EJBJarFile)earFile.getEJBJarFiles().get(0);
        SecurityRole aRole = this.getCommonFactory().createSecurityRole();
        aRole.setRoleName("administrator");
        aRole.setDescription("The all powerful");
        earFile.getDeploymentDescriptor().getSecurityRoles().add((Object)aRole);
        earFile.pushDownRole(aRole);
        SecurityRoleTests.assertTrue((String)"Push down failed for ejb jar", (ejbJarFile.getDeploymentDescriptor().getAssemblyDescriptor().getSecurityRoleNamed("administrator") != null ? 1 : 0) != 0);
        SecurityRoleTests.assertTrue((String)"Push down failed for war", (warFile.getDeploymentDescriptor().getSecurityRoleNamed("administrator") != null ? 1 : 0) != 0);
        earFile.close();
    }

    public void testRollupAddAndPushDown() throws Exception {
        EARFile earFile = SecurityRoleTests.getArchiveFactory().openEARFile(String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear");
        WebModuleRef webRef = (WebModuleRef)earFile.getWebModuleRefs().get(0);
        EJBModuleRef ejbModRef = (EJBModuleRef)earFile.getEJBModuleRefs().get(0);
        SecurityRole aRole = this.getCommonFactory().createSecurityRole();
        aRole.setRoleName("Joe");
        aRole.setDescription("New description");
        webRef.getWebApp().getSecurityRoles().add((Object)aRole);
        aRole = this.getCommonFactory().createSecurityRole();
        aRole.setRoleName("administrator");
        aRole.setDescription("The all powerful");
        webRef.getWebApp().getSecurityRoles().add((Object)aRole);
        earFile.rollUpRoles();
        SecurityRoleTests.assertTrue((String)"Roll up not right", (earFile.getDeploymentDescriptor().getSecurityRoles().size() == 5 ? 1 : 0) != 0);
        aRole = this.getCommonFactory().createSecurityRole();
        aRole.setRoleName("manager");
        aRole.setDescription("the manager");
        earFile.addCopy(aRole, webRef.getModule());
        SecurityRoleTests.assertTrue((String)"Add copy not right", (earFile.getDeploymentDescriptor().getSecurityRoles().size() == 6 && earFile.getDeploymentDescriptor().containsSecurityRole(aRole.getRoleName()) && webRef.getWebApp().containsSecurityRole(aRole.getRoleName()) ? 1 : 0) != 0);
        earFile.renameSecurityRole("Joe", "guest");
        SecurityRoleTests.assertTrue((String)"Push down not right", (!earFile.getDeploymentDescriptor().containsSecurityRole("Joe") && earFile.getDeploymentDescriptor().containsSecurityRole("guest") && !webRef.getWebApp().containsSecurityRole("Joe") && webRef.getWebApp().containsSecurityRole("guest") && !ejbModRef.getEJBJar().containsSecurityRole("Joe") && ejbModRef.getEJBJar().containsSecurityRole("guest") ? 1 : 0) != 0);
        earFile.saveAsNoReopen(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SecurityRoleTests/newSample.ear");
    }
}

