/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.common.tests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.EjbRef;

public class CommonExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"common.xmi", (Object)CommonPackage.eINSTANCE);
        if (args.length == 0) {
            System.out.println("Enter a list of file paths or URIs that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.common"));
                EjbRef root = CommonFactory.eINSTANCE.createEjbRef();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)System.out, null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < args.length) {
                File file = new File(args[0]);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)args[0]);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    System.out.println("Loaded " + uri);
                    Iterator j = resource.getContents().iterator();
                    while (j.hasNext()) {
                        EObject eObject = (EObject)j.next();
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        CommonExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            CommonExample.printDiagnostic((Diagnostic)i.next(), String.valueOf(indent) + "  ");
        }
    }
}

