/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.contenttype;

import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class TestContentTypes
extends TestCase {
    private static final String FACELET_FILENAME = "WebContent/contentType_jsf_facelet.xhtml";
    private static final String FACELET_COMPOSITE_FILENAME = "WebContent/resources/ezcomp/contentType_jsf_facelet_composite.xhtml";
    private WebProjectTestEnvironment _webProject;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        ZipFile zipFile = JSFTestUtil.createZipFile((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/testzips/TestProject1.zip");
        this._webProject = new WebProjectTestEnvironment((TestCase)this, JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"));
        this._webProject.createFromZip2(zipFile, true);
        Job.getJobManager().beginRule((ISchedulingRule)this._webProject.getTestProject(), null);
    }

    protected void tearDown() throws Exception {
        Job.getJobManager().endRule((ISchedulingRule)this._webProject.getTestProject());
        super.tearDown();
    }

    public void testSanity() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestContentTypes.assertNotNull((Object)project);
        TestContentTypes.assertTrue((boolean)project.isAccessible());
        IFile faceletFile = project.getFile((IPath)new Path(FACELET_FILENAME));
        TestContentTypes.assertTrue((boolean)faceletFile.isAccessible());
        IFile faceletCompositeFile = project.getFile((IPath)new Path(FACELET_COMPOSITE_FILENAME));
        TestContentTypes.assertTrue((boolean)faceletCompositeFile.isAccessible());
    }

    public void testNoBundleStateChange() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jst.jsf.core");
        TestContentTypes.assertNotNull((Object)bundle);
        int initialBundleState = bundle.getState();
        IFile faceletFile = this._webProject.getTestProject().getFile((IPath)new Path(FACELET_FILENAME));
        TestContentTypes.assertTrue((boolean)this.hasContentType(faceletFile.getFullPath().toString(), "jsf.facelet"));
        TestContentTypes.assertEquals((String)"Bundle state changed while querying content type", (int)initialBundleState, (int)bundle.getState());
    }

    public void testJSFFaceletContentType() throws Exception {
        IFile faceletFile = this._webProject.getTestProject().getFile((IPath)new Path(FACELET_FILENAME));
        TestContentTypes.assertTrue((boolean)this.hasContentType(faceletFile.getFullPath().toString(), "jsf.facelet"));
    }

    public void testJSFFaceletCompositeContentType() throws Exception {
        IFile faceletFile = this._webProject.getTestProject().getFile((IPath)new Path(FACELET_COMPOSITE_FILENAME));
        TestContentTypes.assertTrue((boolean)this.hasContentType(faceletFile.getFullPath().toString(), "jsf.facelet.composite"));
    }

    private boolean hasContentType(String filename, String contentTypeId) {
        IContentType[] contentTypes;
        boolean hasContentType = false;
        IContentType[] iContentTypeArray = contentTypes = Platform.getContentTypeManager().findContentTypesFor(filename);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentTypeId.equals(contentType.getId())) {
                hasContentType = true;
                break;
            }
            ++n2;
        }
        return hasContentType;
    }
}

