/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JsfDownloadableLibraryLocationTests
extends TestCase {
    private static final String CATALOG_URL_PREFIX = "http://www.eclipse.org/webtools/jsf/jsf-library";
    private static final String[] CATALOG_URLS = new String[]{"http://www.eclipse.org/webtools/jsf/jsf-library/jsf-2.1-downloadable-libraries.xml", "http://www.eclipse.org/webtools/jsf/jsf-library/jsf-2.0-downloadable-libraries.xml", "http://www.eclipse.org/webtools/jsf/jsf-library/jsf-1.2-downloadable-libraries.xml", "http://www.eclipse.org/webtools/jsf/jsf-library/jsf-1.1-downloadable-libraries.xml"};
    private Proxy httpProxy = Proxy.NO_PROXY;
    private final List<String> downloadUrls = new ArrayList<String>();

    public JsfDownloadableLibraryLocationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setProxy();
        String[] stringArray = CATALOG_URLS;
        int n = CATALOG_URLS.length;
        int n2 = 0;
        while (n2 < n) {
            String catalog = stringArray[n2];
            Document document = this.getXmlDocument(catalog);
            NodeList nodes = this.evaluateXpathQuery(document, "//download-url/text()");
            int i = 0;
            while (i < nodes.getLength()) {
                String downloadUrl = nodes.item(i).getNodeValue();
                this.downloadUrls.add(downloadUrl);
                System.out.println("JSF library download URL (extracted from catalog): " + downloadUrl);
                ++i;
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     */
    private void setProxy() throws IOException {
        String sysProxyPort;
        ArrayList<Proxy> possibleProxies = new ArrayList<Proxy>();
        possibleProxies.add(Proxy.NO_PROXY);
        String sysProxyHost = System.getProperty("http.proxyHost");
        if (sysProxyHost != null && (sysProxyPort = System.getProperty("http.proxyPort")) != null) {
            int proxyPort = -1;
            try {
                proxyPort = Integer.parseInt(sysProxyPort);
            }
            catch (NumberFormatException numberFormatException) {}
            if (proxyPort > -1) {
                possibleProxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(sysProxyHost, proxyPort)));
            }
        }
        possibleProxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("www-proxy.us.oracle.com", 80)));
        URL proxyTestURL = new URL("http://www.eclipse.org/");
        for (Proxy proxy : possibleProxies) {
            InputStream is = null;
            URLConnection connection = proxyTestURL.openConnection(proxy);
            is = connection.getInputStream();
            this.httpProxy = proxy;
            if (is == null) break;
            try {
                is.close();
            }
            catch (IOException iOException) {}
            break;
            catch (IOException iOException) {
                try {
                    if (is == null) continue;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException3) {}
            }
        }
    }

    public void testDownloadLibraryUrls() throws IOException {
        for (String url : this.downloadUrls) {
            JsfDownloadableLibraryLocationTests.assertTrue((String)("Cannot download library from: " + url), (boolean)this.isValidUrl(url));
        }
    }

    private Document getXmlDocument(String url) throws ParserConfigurationException, MalformedURLException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        URL catalogUrl = new URL(url);
        URLConnection catalogUrlConnection = catalogUrl.openConnection(this.httpProxy);
        return builder.parse(catalogUrlConnection.getInputStream());
    }

    private NodeList evaluateXpathQuery(Document xmlDocument, String xpathQuery) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(xpathQuery);
        return (NodeList)expr.evaluate(xmlDocument, XPathConstants.NODESET);
    }

    private boolean isValidUrl(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(this.httpProxy);
        urlConnection.connect();
        int responseCode = -1;
        try {
            responseCode = urlConnection.getResponseCode();
        }
        catch (SocketException socketException) {}
        return 200 <= responseCode && responseCode <= 299;
    }
}

