/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathEntryLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IClasspathLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;
import org.eclipse.jst.jsf.core.tests.resource.ClasspathTestListener;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJDTWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaChangeEventFactory;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaCoreMediator;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaProject;
import org.eclipse.jst.jsf.test.util.mock.java.MockPackageFragmentRoot;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class FastClasspathEntryLifecycleTests {
    private IWorkspaceContext _wsContext;
    private MockJavaChangeEventFactory _factory;
    private IProject _project;
    private MockJDTWorkspaceContext _jdtContext;
    private MockJavaProject _javaProject;

    @Before
    public void setUp() throws Exception {
        this._wsContext = new MockWorkspaceContext();
        this._project = this._wsContext.createProject("SomeTestProject");
        this._jdtContext = new MockJDTWorkspaceContext(this._wsContext);
        this._javaProject = this._jdtContext.createJavaProject(this._project);
        this._factory = new MockJavaChangeEventFactory(this._jdtContext);
    }

    @Test
    public void testAddJarTo() {
        ClasspathEntryLifecycleListener listener = new ClasspathEntryLifecycleListener(this._project, (JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        ClasspathTestListener testListener = new ClasspathTestListener(this._jdtContext, listener);
        MockPackageFragmentRoot fragRoot = new MockPackageFragmentRoot((IJavaProject)this._javaProject, (IPath)new Path("/WebContent/WEB-INF/lib/my.jar"));
        ElementChangedEvent event = this._factory.createSimpleJarAdded(this._project, (IPackageFragmentRoot)fragRoot);
        testListener.fireAndExpect(event, event.getDelta().getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.ADDED);
        listener.dispose();
    }

    @Test
    public void testRemoveJarFrom() {
        ClasspathEntryLifecycleListener listener = new ClasspathEntryLifecycleListener(this._project, (JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        ClasspathTestListener testListener = new ClasspathTestListener(this._jdtContext, listener);
        MockPackageFragmentRoot fragRoot = new MockPackageFragmentRoot((IJavaProject)this._javaProject, (IPath)new Path("/WebContent/WEB-INF/lib/my.jar"));
        ElementChangedEvent event = this._factory.createSimpleJarRemoved(this._project, (IPackageFragmentRoot)fragRoot);
        testListener.fireAndExpect(event, event.getDelta().getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.REMOVED);
        listener.dispose();
    }
}

