/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.resource.MyTestListener;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceContext;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceRunner;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEventFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=WorkspaceRunner.class)
@Category(value={NoPluginEnvironment.class})
public class FastLifecycleListenerTests {
    @WorkspaceContext
    private IWorkspaceContextWithEvents _wsContext;
    private MockResourceChangeEventFactory _factory;
    private IProject _project;
    private IFile _file;

    @Before
    public void setUp() throws Exception {
        this._project = this._wsContext.createProject("SomeTestProject");
        this._file = this._project.getFile("myfile.txt");
        this._factory = new MockResourceChangeEventFactory((IWorkspaceContext)this._wsContext);
    }

    @Test
    public void testAddRemoveListener() {
        LifecycleListener listener = new LifecycleListener((IResource)this._file, this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFileChange(this._file, true);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testAddRemoveResource() {
        ArrayList<Class<LifecycleListener>> includeListeners = new ArrayList<Class<LifecycleListener>>();
        includeListeners.add(LifecycleListener.class);
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFileChange(this._file, true);
        tester.fireAndExpectNull(event);
        Assert.assertEquals((long)0L, (long)this._wsContext.getListeners(includeListeners).size());
        listener.addResource((IResource)this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS);
        Assert.assertEquals((long)1L, (long)this._wsContext.getListeners(includeListeners).size());
        listener.removeResource((IResource)this._file);
        tester.fireAndExpectNull(event);
        Assert.assertEquals((long)0L, (long)this._wsContext.getListeners(includeListeners).size());
    }

    @Test(expected=IllegalStateException.class)
    public void testDispose_AddListener() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        listener.dispose();
        listener.addListener((ILifecycleListener)new MyTestListener(this._wsContext));
    }

    @Test(expected=IllegalStateException.class)
    public void testDispose_RemoveListener() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        listener.dispose();
        listener.removeListener((ILifecycleListener)new MyTestListener(this._wsContext));
    }

    @Test
    public void testDispose_AddRemoveResource() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        listener.dispose();
        listener.addResource((IResource)this._file);
        listener.removeResource((IResource)this._file);
    }

    @Test
    public void testFileChangedEvents() {
        LifecycleListener listener = new LifecycleListener((IResource)this._file, this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFileChange(this._file, true);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS);
        event = this._factory.createSimpleFileRemove(this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        event = this._factory.createSimpleFileAdded(this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED);
        listener.removeResource((IResource)this._file);
        tester.fireAndExpectNull(event);
        listener.addResource((IResource)this._file.getParent());
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER);
    }

    @Test
    public void testProjectChangeEvents_ProjectClosed() {
        LifecycleListener listener = new LifecycleListener((IResource)this._project, this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleProjectClosed(this._project);
        tester.fireAndExpect(event, (IResource)this._project, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        listener.removeResource((IResource)this._project);
        listener.addResource((IResource)this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
    }

    @Test
    public void testProjectChangeEvents_ProjectDeleted() {
        LifecycleListener listener = new LifecycleListener((IResource)this._project, this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleProjectDeleted(this._project);
        tester.fireAndExpect(event, (IResource)this._project, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        listener.removeResource((IResource)this._project);
        listener.addResource((IResource)this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED);
    }

    @Test(expected=NullPointerException.class)
    public void testPassNullTo_Workspace_Constructor() {
        new LifecycleListener(null);
    }

    @Test(expected=NullPointerException.class)
    public void testPassNullToResource_Workspace_Constructor() {
        boolean failed = false;
        try {
            new LifecycleListener(null, this._wsContext.getWorkspace());
        }
        catch (NullPointerException nullPointerException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            new LifecycleListener((IResource)this._file, null);
        }
        catch (NullPointerException nullPointerException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        new LifecycleListener(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testPassNullToListResource_Workspace_Constructor() {
        boolean failed = false;
        try {
            new LifecycleListener(null, this._wsContext.getWorkspace());
        }
        catch (NullPointerException nullPointerException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            new LifecycleListener(new ArrayList(), null);
        }
        catch (NullPointerException nullPointerException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            ArrayList<IFile> resources = new ArrayList<IFile>();
            resources.add(this._file);
            resources.add(null);
            new LifecycleListener(resources, this._wsContext.getWorkspace());
        }
        catch (NullPointerException nullPointerException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        new LifecycleListener(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testPassNullToAddResource() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        listener.addResource(null);
    }

    @Test(expected=NullPointerException.class)
    public void testPassNullToAddListener() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        listener.addListener(null);
    }
}

