/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.io.File;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.jsf.common.internal.resource.DefaultJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJDTWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaChangeEventFactory;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaCoreMediator;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaProject;
import org.eclipse.jst.jsf.test.util.mock.java.MockPackageFragmentRoot;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TestDefaultJarLocator {
    private IWorkspaceContext _wsContext;
    private IProject _project;
    private MockJavaChangeEventFactory _factory;
    private MockJDTWorkspaceContext _jdtContext;
    private MockJavaProject _javaProject;

    @Before
    public void setUp() throws Exception {
        this._wsContext = new MockWorkspaceContext();
        this._project = this._wsContext.createProject("SomeTestProject");
        this._jdtContext = new MockJDTWorkspaceContext(this._wsContext);
        this._factory = new MockJavaChangeEventFactory(this._jdtContext);
        this._jdtContext.createCPELibraryInProject(this._project, (IPath)new Path("/WEB-INF/WebContent/lib/nocareContents.jar"), new File("./testfiles/faces-all-bogus.jar"));
        this._javaProject = this._jdtContext.createJavaProject(this._project);
    }

    @Test
    public void testStart() throws Exception {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.start(this._project);
    }

    @Test
    public void testLocate() {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.start(this._project);
        Collection locate = (Collection)jarLocator.locate((Object)this._project);
        Assert.assertEquals((int)1, (int)locate.size());
        Collection jars = jarLocator.getJars(this._project);
        Assert.assertEquals((int)1, (int)locate.size());
        Assert.assertEquals((Object)locate, (Object)jars);
    }

    @Test
    public void testAddJar() {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.start(this._project);
        final IJarLocator.JarChangeEvent[] trappedEvents = new IJarLocator.JarChangeEvent[1];
        jarLocator.addListener(new IJarLocator.JarChangeListener(){

            public void changed(IJarLocator.JarChangeEvent event) {
                trappedEvents[0] = event;
            }
        });
        MockPackageFragmentRoot fragRoot = new MockPackageFragmentRoot((IJavaProject)this._javaProject, (IPath)new Path("/WebContent/WEB-INF/lib/my.jar"));
        ElementChangedEvent event = this._factory.createSimpleJarAdded(this._project, (IPackageFragmentRoot)fragRoot);
        this._jdtContext.fireElementChangedEvent(event);
        Assert.assertNotNull((Object)trappedEvents[0]);
        Assert.assertEquals((Object)IJarLocator.JarChangeEvent.Type.JAR_ADDED, (Object)trappedEvents[0].getType());
        Assert.assertEquals((String)"/WebContent/WEB-INF/lib/my.jar", (String)trappedEvents[0].getJar().getPath().toString());
    }

    @Test
    public void testRemoveJar() {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.start(this._project);
        final IJarLocator.JarChangeEvent[] trappedEvents = new IJarLocator.JarChangeEvent[1];
        jarLocator.addListener(new IJarLocator.JarChangeListener(){

            public void changed(IJarLocator.JarChangeEvent event) {
                trappedEvents[0] = event;
            }
        });
        MockPackageFragmentRoot fragRoot = new MockPackageFragmentRoot((IJavaProject)this._javaProject, (IPath)new Path("/WebContent/WEB-INF/lib/my.jar"));
        ElementChangedEvent event = this._factory.createSimpleJarRemoved(this._project, (IPackageFragmentRoot)fragRoot);
        this._jdtContext.fireElementChangedEvent(event);
        Assert.assertNotNull((Object)trappedEvents[0]);
        Assert.assertEquals((Object)IJarLocator.JarChangeEvent.Type.JAR_REMOVED, (Object)trappedEvents[0].getType());
        Assert.assertEquals((String)"/WebContent/WEB-INF/lib/my.jar", (String)trappedEvents[0].getJar().getPath().toString());
    }

    @Test(expected=IllegalStateException.class)
    public void testLocateWithoutStart() {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.locate((Object)this._project);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetJarsWithoutStart() {
        DefaultJarLocator jarLocator = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        jarLocator.getJars(this._project);
    }
}

