/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.internal.resource.ResourceTracker;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceContext;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceRunner;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEventFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=WorkspaceRunner.class)
@Category(value={NoPluginEnvironment.class})
public class TestResourceTracker {
    private MockResourceChangeEventFactory _eventFactory;
    @WorkspaceContext
    private IWorkspaceContextWithEvents _wsContext;
    private IFile _testResource;
    private TestableResourceTracker _resourceTracker;
    private LifecycleListener _lifecycleListener;
    private IFile _uninterestedInRes;

    @Before
    public void setUp() throws Exception {
        this._eventFactory = new MockResourceChangeEventFactory((IWorkspaceContext)this._wsContext);
        IProject createProject = this._wsContext.createProject("TestResourceTracker_Project");
        this._testResource = createProject.getFile("/WebContent/resources/foo/resource/somelib/foo.xhtml");
        this._uninterestedInRes = createProject.getFile("/WebContent/resources/foo/resource/uninterestedInMe/foo.xhtml");
        this._resourceTracker = new TestableResourceTracker((IResource)this._testResource);
        this._lifecycleListener = new LifecycleListener(this._wsContext.getWorkspace());
        this._lifecycleListener.addListener((ILifecycleListener)this._resourceTracker);
        this._lifecycleListener.addResource((IResource)this._testResource);
        this._lifecycleListener.addResource((IResource)this._uninterestedInRes);
    }

    @After
    public void tearDown() {
        this._resourceTracker.dispose();
    }

    @Test
    public void testGetResource() {
        Assert.assertSame((Object)this._testResource, (Object)this._resourceTracker.getResource());
    }

    @Test
    public void testGetLastModifiedStamp() {
        Assert.assertEquals((long)-1L, (long)this._resourceTracker.getLastModifiedStamp());
    }

    @Test
    public void testFireResourceInAccessible() {
        IResourceChangeEvent event = this._eventFactory.createSimpleProjectDeleted(this._testResource.getProject());
        this._wsContext.fireWorkspaceEvent(event);
        Assert.assertTrue((boolean)this._resourceTracker.isInAccessibleFired());
        Assert.assertEquals((Object)ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED, (Object)this._resourceTracker.getInAccessibleReason());
        Assert.assertFalse((boolean)this._resourceTracker.isAddFired());
        Assert.assertFalse((boolean)this._resourceTracker.isChangeFired());
    }

    @Test
    public void testFireResourceChanged() {
        IResourceChangeEvent event = this._eventFactory.createSimpleFileChange(this._testResource, true);
        this._wsContext.fireWorkspaceEvent(event);
        Assert.assertTrue((boolean)this._resourceTracker.isChangeFired());
        Assert.assertEquals((Object)ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS, (Object)this._resourceTracker.getChangeReason());
        Assert.assertFalse((boolean)this._resourceTracker.isAddFired());
        Assert.assertFalse((boolean)this._resourceTracker.isInAccessibleFired());
    }

    @Test
    public void testFireResourceAdded() {
        IResourceChangeEvent event = this._eventFactory.createSimpleFileAdded(this._testResource);
        this._wsContext.fireWorkspaceEvent(event);
        Assert.assertTrue((boolean)this._resourceTracker.isAddFired());
        Assert.assertEquals((long)1L, (long)this._resourceTracker.getAddReason().size());
        Assert.assertEquals((Object)ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED, (Object)this._resourceTracker.getAddReason().get(0));
        Assert.assertFalse((boolean)this._resourceTracker.isInAccessibleFired());
        Assert.assertFalse((boolean)this._resourceTracker.isChangeFired());
    }

    @Test
    public void testResourceFilter() {
        IResourceChangeEvent event = this._eventFactory.createSimpleFileChange(this._uninterestedInRes, true);
        this._wsContext.fireWorkspaceEvent(event);
        Assert.assertFalse((boolean)this._resourceTracker.isInAccessibleFired());
        Assert.assertFalse((boolean)this._resourceTracker.isAddFired());
        Assert.assertFalse((boolean)this._resourceTracker.isChangeFired());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestableResourceTracker
    extends ResourceTracker<IResource> {
        private boolean _inAccessibleFired;
        private ResourceLifecycleEvent.ReasonType _inAccessibleReason;
        private boolean _changeFired;
        private ResourceLifecycleEvent.ReasonType _changeReason;
        private boolean _addFired;
        private List<ResourceLifecycleEvent.ReasonType> _addReason = new ArrayList<ResourceLifecycleEvent.ReasonType>();

        public TestableResourceTracker(IResource resource) {
            super(resource);
        }

        protected void fireResourceInAccessible(IResource resource, ResourceLifecycleEvent.ReasonType reasonType) {
            this._inAccessibleFired = true;
            this._inAccessibleReason = reasonType;
        }

        protected void fireResourceChanged(IResource resource, ResourceLifecycleEvent.ReasonType reasonType) {
            this._changeFired = true;
            this._changeReason = reasonType;
        }

        protected void fireResourceAdded(IResource affectedResource, ResourceLifecycleEvent.ReasonType reasonType) {
            this._addFired = true;
            this._addReason.add(reasonType);
        }

        public final boolean isInAccessibleFired() {
            return this._inAccessibleFired;
        }

        public final ResourceLifecycleEvent.ReasonType getInAccessibleReason() {
            return this._inAccessibleReason;
        }

        public final boolean isChangeFired() {
            return this._changeFired;
        }

        public final ResourceLifecycleEvent.ReasonType getChangeReason() {
            return this._changeReason;
        }

        public final boolean isAddFired() {
            return this._addFired;
        }

        public final List<ResourceLifecycleEvent.ReasonType> getAddReason() {
            return this._addReason;
        }
    }
}

