/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestTypeUtil
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private IType _testBean1Type;
    private IType _testBeanSubclassType;
    private IType _testBeanGenericType;
    private IType _testEnum1Type;
    private IType _binaryType;
    private static final String srcFolderName = "src";
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";
    private static final String testBeanSubclassName1 = "TestBean1Subclass";
    private static final String testAnotherBeanName = "AnotherBean";
    private static final String testBeanGenericName = "TestBeanGeneric";
    private static final String testEnumName1 = "TestEnum1";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestTypeUtil" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        projectTestEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data");
        String code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanName1, code);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestTypeUtil.assertNotNull((Object)this._testBean1Type);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1Subclass.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanSubclassName1, code);
        this._testBeanSubclassType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1Subclass");
        TestTypeUtil.assertNotNull((Object)this._testBeanSubclassType);
        TestTypeUtil.assertNotSame((Object)this._testBean1Type, (Object)this._testBeanSubclassType);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/AnotherBean.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testAnotherBeanName, code);
        TestTypeUtil.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType("com.test.AnotherBean"));
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBeanGeneric.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanGenericName, code);
        this._testBeanGenericType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBeanGeneric");
        TestTypeUtil.assertNotNull((Object)this._testBeanGenericType);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestEnum1.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testEnumName1, code);
        this._testEnum1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestEnum1");
        TestTypeUtil.assertNotNull((Object)this._testEnum1Type);
        TestTypeUtil.assertTrue((boolean)this._testEnum1Type.isEnum());
        IClasspathEntry entry = this._jdtTestEnvironment.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), "/testfiles/signatures.jar");
        TestTypeUtil.assertNotNull((Object)entry);
        this._binaryType = this._jdtTestEnvironment.getJavaProject().findType("com.test.BinaryType");
        TestTypeUtil.assertNotNull((Object)this._binaryType);
        TestTypeUtil.assertEquals((int)8, (int)this._binaryType.getMethods().length);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testResolveTypeSignatureITypeString() {
        TestTypeUtil.assertEquals((String)"Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QString;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QString;", (boolean)false));
        TestTypeUtil.assertEquals((String)"Ljava.util.Collection;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QCollection;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.util.Collection;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QCollection;", (boolean)false));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap;", (boolean)false));
        String typeSigWithErasure = TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;QString;>;", (boolean)true);
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)typeSigWithErasure);
        String typeSigNoErasure = TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;QString;>;", (boolean)false);
        TestTypeUtil.assertEquals((String)"Ljava.util.Map<Ljava.lang.String;Ljava.lang.String;>;", (String)typeSigNoErasure);
        IType mapType = TypeUtil.resolveType((IJavaProject)this._jdtTestEnvironment.getJavaProject(), (String)"Ljava.util.Map;");
        TestTypeUtil.assertNotNull((Object)mapType);
        TestTypeUtil.assertEquals((String)"Ljava.lang.Object;", (String)TypeUtil.resolveTypeSignature((IType)mapType, (String)"TV;", (boolean)false));
        TestTypeUtil.assertEquals((String)"QSomeNotRealClass;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QSomeNotRealClass;", (boolean)false));
        TestTypeUtil.assertEquals((String)"[I", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"[I"));
        TestTypeUtil.assertEquals((String)"[Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"[QString;"));
        TestTypeUtil.assertEquals((String)"[Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"[QMap;"));
        TestTypeUtil.assertEquals((String)"[Ljava.util.Collection;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"[QCollection;"));
        TestTypeUtil.assertEquals((String)"[[[Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"[[[QString;"));
        this.runWildcardAndCapture(typeSigWithErasure, true);
        this.runWildcardAndCapture(typeSigNoErasure, false);
    }

    private void runWildcardAndCapture(String expected, boolean typeErasure) {
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<+QString;+QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<+QString;QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;+QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<-QString;-QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<-QString;QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;-QString;>;", (boolean)typeErasure));
        String expected1 = "Ljava.util.Map" + (typeErasure ? ";" : "<Ljava.lang.Object;Ljava.lang.Object;>;");
        TestTypeUtil.assertEquals((String)expected1, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<**>;", (boolean)typeErasure));
        String expected2 = "Ljava.util.Map" + (typeErasure ? ";" : "<Ljava.lang.Object;Ljava.lang.String;>;");
        TestTypeUtil.assertEquals((String)expected2, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<*QString;>;", (boolean)typeErasure));
        String expected3 = "Ljava.util.Map" + (typeErasure ? ";" : "<Ljava.lang.String;Ljava.lang.Object;>;");
        TestTypeUtil.assertEquals((String)expected3, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;*>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<!+QString;!+QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<!+QString;QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)expected, (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;!+QString;>;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)"Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"!+QString;", (boolean)typeErasure));
        TestTypeUtil.assertEquals((String)"Ljava.lang.Object;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"*", (boolean)typeErasure));
    }

    public void testCanNeverBeEqual() {
        TestTypeUtil.assertFalse((boolean)TypeUtil.canNeverBeEqual((String)"Ljava.lang.Enum;", (String)"Lcom.test.SomeEnum;"));
        TestTypeUtil.assertFalse((boolean)TypeUtil.canNeverBeEqual((String)"Lcom.test.SomeEnum;", (String)"Ljava.lang.Enum;"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.canNeverBeEqual((String)"Lcom.test.SomeEnum1;", (String)"Lcom.test.SomeEnum2;"));
        TestTypeUtil.assertFalse((boolean)TypeUtil.canNeverBeEqual((String)"Lcom.test.SomeEnum1;", (String)"Lcom.test.SomeEnum1;"));
    }

    public void testIsEnumsCompareCompatible() {
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumsCompareCompatible((String)"Ljava.lang.Enum;", (String)"Lcom.test.SomeEnum;"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumsCompareCompatible((String)"Lcom.test.SomeEnum;", (String)"Ljava.lang.Enum;"));
        TestTypeUtil.assertFalse((boolean)TypeUtil.isEnumsCompareCompatible((String)"Lcom.test.SomeEnum1;", (String)"Lcom.test.SomeEnum2;"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumsCompareCompatible((String)"Lcom.test.SomeEnum1;", (String)"Lcom.test.SomeEnum1;"));
    }

    public void testGetSignature() {
        TestTypeUtil.assertEquals((String)"Lcom.test.TestBean1;", (String)TypeUtil.getSignature((IType)this._testBean1Type));
    }

    public void testResolveMethodSignature() throws Exception {
        TestTypeUtil.assertEquals((String)"()Ljava.lang.String;", (String)TypeUtil.resolveMethodSignature((IType)this._testBean1Type, (String)"()QString;"));
        TestTypeUtil.assertEquals((String)"(Ljava.lang.String;)V", (String)TypeUtil.resolveMethodSignature((IType)this._testBean1Type, (String)"(QString;)V"));
        TestTypeUtil.assertEquals((String)"(Ljava.lang.String;Z)V", (String)TypeUtil.resolveMethodSignature((IType)this._testBean1Type, (String)"(QString;Z)V"));
        IMethod method = this._testBean1Type.getMethod("getStringProp1", null);
        TestTypeUtil.assertEquals((String)"()Ljava.lang.String;", (String)TypeUtil.resolveMethodSignature((IType)this._testBean1Type, (String)method.getSignature()));
        method = this._testBean1Type.getMethod("setStringProperty2", new String[]{"I"});
        TestTypeUtil.assertEquals((String)"(I)V", (String)TypeUtil.resolveMethodSignature((IType)this._testBean1Type, (String)method.getSignature()));
        TestTypeUtil.assertTrue((boolean)this._binaryType.isBinary());
        TestTypeUtil.assertEquals((String)"()Ljava.lang.String;", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("getStringProperty", null).getSignature()));
        TestTypeUtil.assertEquals((String)"(Ljava.lang.String;)V", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("setStringProperty", new String[]{"Ljava.lang.String;"}).getSignature()));
        TestTypeUtil.assertEquals((String)"()I", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("getIntegerProperty", null).getSignature()));
        TestTypeUtil.assertEquals((String)"(I)V", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("setIntegerProperty", new String[]{"I"}).getSignature()));
        TestTypeUtil.assertEquals((String)"()Lcom.test.BinaryPropertyAndMethodType;", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("getUserDefined", null).getSignature()));
        TestTypeUtil.assertEquals((String)"(Lcom.test.BinaryPropertyAndMethodType;)V", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("setUserDefined", new String[]{"Lcom.test.BinaryPropertyAndMethodType;"}).getSignature()));
        TestTypeUtil.assertEquals((String)"(Ljava.lang.String;Lcom.test.BinaryPropertyAndMethodType;I)I", (String)TypeUtil.resolveMethodSignature((IType)this._binaryType, (String)this._binaryType.getMethod("methodWithMultipleArgs", new String[]{"Ljava.lang.String;", "Lcom.test.BinaryPropertyAndMethodType;", "I"}).getSignature()));
    }

    public void testResolveTypeIJavaProjectString() {
        TestTypeUtil.assertNotNull((Object)TypeUtil.resolveType((IJavaProject)this._jdtTestEnvironment.getJavaProject(), (String)"Ljava.lang.String;"));
        TestTypeUtil.assertEquals((Object)this._testBean1Type, (Object)TypeUtil.resolveType((IJavaProject)this._jdtTestEnvironment.getJavaProject(), (String)"Lcom.test.TestBean1;"));
    }

    public void testMatchTypeParameterToArgument() throws Exception {
        IType mapType = TypeUtil.resolveType((IJavaProject)this._jdtTestEnvironment.getJavaProject(), (String)"Ljava.util.Map;");
        TestTypeUtil.assertNotNull((Object)mapType);
        ArrayList<String> args = new ArrayList<String>();
        args.add("Ljava.lang.String;");
        args.add("Lcom.test.TestBean1;");
        TestTypeUtil.assertEquals((String)"Lcom.test.TestBean1;", (String)TypeUtil.matchTypeParameterToArgument((IType)mapType, (String)"TV;", args));
        TestTypeUtil.assertNull((Object)TypeUtil.matchTypeParameterToArgument((IType)mapType, (String)"TQ;", args));
        TestTypeUtil.assertNull((Object)TypeUtil.matchTypeParameterToArgument((IType)mapType, (String)"Tgarbonzo;", args));
    }

    public void testIsEnumMember() throws Exception {
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"red"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"blue"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"green"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"yellow"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"purple"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"orange"));
        TestTypeUtil.assertFalse((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"mauve"));
        TestTypeUtil.assertFalse((boolean)TypeUtil.isEnumMember((IType)this._testEnum1Type, (String)"pink"));
        IType type = this._jdtTestEnvironment.getJavaProject().findType("java.lang.Enum");
        TestTypeUtil.assertNotNull((Object)type);
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)type, (String)"red"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)type, (String)"pink"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)type, (String)"anything"));
        TestTypeUtil.assertTrue((boolean)TypeUtil.isEnumMember((IType)type, (String)"deadbeef"));
    }
}

