/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;

public class RefactoringTest
extends TestCase {
    public RefactoringTest() {
    }

    public RefactoringTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new RefactoringTest("Refactoring"){

            protected void runTest() {
                this.testRefactoring();
            }
        });
        return suite;
    }

    public void testRefactoring() {
        try {
            this.generateWSDL(String.valueOf(WSDLTestsPlugin.getInstallURL()) + "samples/generated/RefactoringTest.wsdl");
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void renameOperation(Operation op) {
        Input input = op.getEInput();
        Assert.assertNotNull((Object)input);
        Message message = input.getEMessage();
        Assert.assertNotNull((Object)message);
        op.setName("Renamed" + op.getName());
        QName newQName = new QName(message.getQName().getNamespaceURI(), "Renamed" + message.getQName().getLocalPart());
        message.setQName(newQName);
    }

    public void generateWSDL(String outputFile) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)outputFile));
        resourceSet.getResources().add((Object)resource);
        Definition definition = WSDLFactory.eINSTANCE.createDefinition();
        definition.setQName(new QName("http://schemas.xmlsoap.org/wsdl/", "Temperature"));
        resource.getContents().add((Object)definition);
        definition.setTargetNamespace("http://www.temperature.com");
        definition.addNamespace("tns", "http://www.temperature.com");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        Part part = WSDLFactory.eINSTANCE.createPart();
        part.setName("ZipCode");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        Message inputMessage = WSDLFactory.eINSTANCE.createMessage();
        inputMessage.setQName(new QName(definition.getTargetNamespace(), "GetTemperatureInput"));
        inputMessage.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)inputMessage);
        part = WSDLFactory.eINSTANCE.createPart();
        part.setName("Temperature");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "float"));
        Message outputMessage = WSDLFactory.eINSTANCE.createMessage();
        outputMessage.setQName(new QName(definition.getTargetNamespace(), "GetTemperatureOutput"));
        outputMessage.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)outputMessage);
        Input input = WSDLFactory.eINSTANCE.createInput();
        input.setMessage((javax.wsdl.Message)inputMessage);
        Output output = WSDLFactory.eINSTANCE.createOutput();
        output.setMessage((javax.wsdl.Message)outputMessage);
        Operation operation = WSDLFactory.eINSTANCE.createOperation();
        operation.setName("GetTemperatureForZipCode");
        operation.setInput((javax.wsdl.Input)input);
        operation.setOutput((javax.wsdl.Output)output);
        PortType portType = WSDLFactory.eINSTANCE.createPortType();
        portType.setQName(new QName(definition.getTargetNamespace(), "GetTemperatureInfoSOAP"));
        portType.addOperation((javax.wsdl.Operation)operation);
        definition.addPortType((javax.wsdl.PortType)portType);
        part = WSDLFactory.eINSTANCE.createPart();
        part.setName("Part2");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        Message inputMessage2 = WSDLFactory.eINSTANCE.createMessage();
        inputMessage2.setQName(new QName(definition.getTargetNamespace(), "InputMessage2"));
        inputMessage2.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)inputMessage2);
        part = WSDLFactory.eINSTANCE.createPart();
        part.setName("Part3");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "float"));
        Message outputMessage2 = WSDLFactory.eINSTANCE.createMessage();
        outputMessage2.setQName(new QName(definition.getTargetNamespace(), "OutputMessage2"));
        outputMessage2.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)outputMessage2);
        Input input2 = WSDLFactory.eINSTANCE.createInput();
        input2.setMessage((javax.wsdl.Message)inputMessage2);
        Output output2 = WSDLFactory.eINSTANCE.createOutput();
        output2.setMessage((javax.wsdl.Message)outputMessage2);
        Operation operation2 = WSDLFactory.eINSTANCE.createOperation();
        operation2.setName("Operation2");
        operation2.setInput((javax.wsdl.Input)input2);
        operation2.setOutput((javax.wsdl.Output)output2);
        portType.addOperation((javax.wsdl.Operation)operation2);
        this.renameOperation(operation);
        this.renameOperation(operation2);
        resource.save(null);
    }
}

