/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;

public abstract class AbstractTestProxy
extends TestCase {
    private RegistryHandler registryHandler;
    protected ProxyFactoryRegistry registry;
    protected IStandardBeanTypeProxyFactory proxyTypeFactory;
    protected IStandardBeanProxyFactory proxyFactory;

    public static void initRegistryHandler(TestSuite suite, RegistryHandler registryHandler) {
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (test instanceof AbstractTestProxy) {
                ((AbstractTestProxy)test).setRegistryHandler(registryHandler);
                continue;
            }
            if (!(test instanceof TestSuite)) continue;
            AbstractTestProxy.initRegistryHandler((TestSuite)test, registryHandler);
        }
    }

    public AbstractTestProxy() {
    }

    public AbstractTestProxy(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        AbstractTestProxy.assertNotNull((Object)this.getRegistryHandler());
        AbstractTestProxy.assertTrue((String)"Suite not setup correctly.", (boolean)this.getRegistryHandler().isValid());
        this.createRegistry();
    }

    private void createRegistry() throws CoreException {
        this.registry = this.getRegistryHandler().getRegistry();
        AbstractTestProxy.assertNotNull((Object)this.registry);
        this.proxyFactory = this.registry.getBeanProxyFactory();
        this.proxyTypeFactory = this.registry.getBeanTypeProxyFactory();
    }

    public void setRegistryHandler(RegistryHandler registryHandler) {
        this.registryHandler = registryHandler;
    }

    public RegistryHandler getRegistryHandler() {
        return this.registryHandler;
    }

    public void recreateRegistry() throws CoreException {
        this.getRegistryHandler().destroyRegistry();
        this.createRegistry();
    }

    public static interface RegistryHandler {
        public boolean isValid();

        public ProxyFactoryRegistry getRegistry() throws CoreException;

        public void destroyRegistry();
    }
}

