/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.tests.proxy.initParser.ArrayConstructorTest;
import org.eclipse.jem.tests.proxy.initParser.tree.ASTTreeInitStringParserTestHelper;

public class ASTArraysTest
extends ArrayConstructorTest {
    public ASTArraysTest(String name) {
        super(name);
    }

    protected ASTTreeInitStringParserTestHelper getTreeParser() {
        return (ASTTreeInitStringParserTestHelper)this.testHelper;
    }

    public void testUndefinedSecondDim() throws Throwable {
        IExpression exp = this.getTreeParser().getRegistry().getBeanProxyFactory().createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][]", 1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 3);
        this.testHelper.testInitString("new int[3][]", exp.getExpressionValue());
    }

    public void testArrayAccess() throws Throwable {
        IExpression exp = this.getTreeParser().getRegistry().getBeanProxyFactory().createExpression();
        exp.createArrayAccess(ForExpression.ROOTEXPRESSION, 1);
        exp.createArrayCreation(ForExpression.ARRAYACCESS_ARRAY, "java.lang.Integer[]", 1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 3);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        this.testHelper.testInitString("(new Integer[3])[0]", exp.getExpressionValue());
    }

    public void testMutltiArrayAccess() throws Throwable {
        IExpression exp = this.getTreeParser().getRegistry().getBeanProxyFactory().createExpression();
        exp.createArrayAccess(ForExpression.ROOTEXPRESSION, 2);
        exp.createArrayCreation(ForExpression.ARRAYACCESS_ARRAY, "int[][]", 0);
        exp.createArrayInitializer(2);
        exp.createArrayInitializer(1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 2);
        exp.createArrayInitializer(1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 4);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        this.testHelper.testInitString("(new int[][] {{2}, {4}})[0][0]", exp.getExpressionValue());
    }
}

