/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;

public class ASTMiscTest
extends AbstractInitParserTestCase {
    public ASTMiscTest(String name) {
        super(name);
    }

    public void testCharLiteral() {
        PTCharacterLiteral cl = InstantiationFactory.eINSTANCE.createPTCharacterLiteral();
        cl.setEscapedValue("'a'");
        ASTMiscTest.assertEquals((char)'a', (char)cl.getCharValue());
        cl.setCharValue('b');
        ASTMiscTest.assertEquals((String)"'b'", (String)cl.getEscapedValue());
        cl.setEscapedValue("'\\n'");
        ASTMiscTest.assertEquals((char)'\n', (char)cl.getCharValue());
        cl.setCharValue('\b');
        ASTMiscTest.assertEquals((String)"'\\b'", (String)cl.getEscapedValue());
        cl.setEscapedValue("'\\u0300'");
        ASTMiscTest.assertEquals((char)'\u0300', (char)cl.getCharValue());
        cl.setCharValue('\u0400');
        ASTMiscTest.assertEquals((String)"'\u0400'", (String)cl.getEscapedValue());
    }

    public void testStringLiteral() {
        PTStringLiteral sl = InstantiationFactory.eINSTANCE.createPTStringLiteral();
        sl.setEscapedValue("\"a\"");
        ASTMiscTest.assertEquals((String)"a", (String)sl.getLiteralValue());
        sl.setLiteralValue("\b");
        ASTMiscTest.assertEquals((String)"\"\\b\"", (String)sl.getEscapedValue());
        sl.setEscapedValue("\"\\n\"");
        ASTMiscTest.assertEquals((String)"\n", (String)sl.getLiteralValue());
        sl.setLiteralValue("\b");
        ASTMiscTest.assertEquals((String)"\"\\b\"", (String)sl.getEscapedValue());
        sl.setEscapedValue("\"\\u0300\"");
        ASTMiscTest.assertEquals((String)"\u0300", (String)sl.getLiteralValue());
        sl.setLiteralValue("\u0400");
        ASTMiscTest.assertEquals((String)"\"\u0400\"", (String)sl.getEscapedValue());
    }
}

