/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.tests.scenarios;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawerFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteRoot;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.tests.helpers.ComplexProvider;

public class ObjectOrientedSnippetScenario
extends TestCase {
    private IFile file;

    protected void setUp() throws Exception {
        super.setUp();
        String projectName = String.valueOf(System.currentTimeMillis());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        this.file = project.getFile("testTextSnippet.txt");
        if (!this.file.exists()) {
            ByteArrayInputStream sr = new ByteArrayInputStream("test Text Snippet Provider".getBytes());
            this.file.create((InputStream)sr, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void testSave() throws Exception {
        SnippetPaletteRoot anchor = null;
        SnippetsView view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        if (view == null) {
            view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        }
        if (view != null) {
            anchor = view.getRoot();
        }
        Shell activeShell = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        ObjectOrientedSnippetScenario.assertNotNull((Object)activeShell);
        PaletteDrawer drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(activeShell, (PaletteEntry)anchor);
        drawer.setLabel("testName");
        ComplexProvider provider = new ComplexProvider();
        IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
        provider.setEditor(openEditor);
        SnippetPaletteItem createSnippet = provider.createSnippet((PaletteEntry)drawer);
        ObjectOrientedSnippetScenario.assertNotNull((Object)createSnippet);
        File f = new File(createSnippet.getStorageLocation().toOSString());
        ObjectOrientedSnippetScenario.assertTrue((boolean)f.exists());
        ObjectOrientedSnippetScenario.assertEquals((int)1, (int)f.list().length);
        ObjectOrientedSnippetScenario.assertEquals((String)"test.txt", (String)f.listFiles()[0].getName());
        ObjectOrientedSnippetScenario.assertEquals((String)"testing 1, 2, 3, 4, 5, 6".trim(), (String)this.getContents(f.listFiles()[0]).trim());
    }

    public void testProviderBasedSourceType() throws Exception {
        SnippetPaletteRoot anchor = null;
        SnippetsView view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        if (view == null) {
            view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        }
        if (view != null) {
            anchor = view.getRoot();
        }
        Shell activeShell = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        ObjectOrientedSnippetScenario.assertNotNull((Object)activeShell);
        PaletteDrawer drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(activeShell, (PaletteEntry)anchor);
        drawer.setLabel(this.getName());
        ComplexProvider provider = new ComplexProvider();
        IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
        provider.setEditor(openEditor);
        SnippetPaletteItem createSnippet = provider.createSnippet((PaletteEntry)drawer);
        ObjectOrientedSnippetScenario.assertNotNull((Object)createSnippet);
        File f = new File(createSnippet.getStorageLocation().toOSString());
        ObjectOrientedSnippetScenario.assertTrue((boolean)f.exists());
        ObjectOrientedSnippetScenario.assertEquals((int)1, (int)f.list().length);
        ObjectOrientedSnippetScenario.assertEquals((String)"test.txt", (String)f.listFiles()[0].getName());
        ObjectOrientedSnippetScenario.assertEquals((String)"testing 1, 2, 3, 4, 5, 6".trim(), (String)this.getContents(f.listFiles()[0]).trim());
        ObjectOrientedSnippetScenario.assertEquals((Object)"USER", (Object)createSnippet.getSourceType());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContents(File aFile) {
        StringBuffer contents = new StringBuffer();
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                input.close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                input.close();
                return contents.toString();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }
}

