/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.contenttypeidentifier.contentspecific;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TestModelHandlers
extends TestCase {
    static /* synthetic */ Class class$0;

    private static ModelHandlerRegistry getModelHandlerRegistry() {
        ModelHandlerRegistry registry = ModelHandlerRegistry.getInstance();
        return registry;
    }

    public void testCreation() {
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        TestModelHandlers.assertTrue((String)"model handler registry must exist", (registry != null ? 1 : 0) != 0);
    }

    public void testCSSExists() {
        String id = ContentTypeIdForCSS.ContentTypeID_CSS;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have CSS type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testCSSExistsFromFilename() throws IOException {
        String filename = "test.css";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have CSS type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForCSS.ContentTypeID_CSS) ? 1 : 0) != 0);
    }

    public void testDTDExists() {
        String id = "org.eclipse.wst.dtd.core.dtdsource";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have DTD type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testDTDExistsFromFilename() throws IOException {
        String filename = "test.dtd";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have DTD type ", (handler != null && handler.getAssociatedContentTypeId().equals("org.eclipse.wst.dtd.core.dtdsource") ? 1 : 0) != 0);
    }

    public void testHTMLExists() {
        String id = ContentTypeIdForHTML.ContentTypeID_HTML;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have HTML type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testHTMLExistsFromFilename() throws IOException {
        String filename = "test.html";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have HTML type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForHTML.ContentTypeID_HTML) ? 1 : 0) != 0);
    }

    public void testJSPExists() {
        String id = ContentTypeIdForJSP.ContentTypeID_JSP;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have JSP type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testJSPExistsFromFilename() throws IOException {
        String filename = "test.jsp";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have JSP type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForJSP.ContentTypeID_JSP) ? 1 : 0) != 0);
    }

    public void testXMLExists() {
        String id = ContentTypeIdForXML.ContentTypeID_XML;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertEquals((String)"model handler registry does not have XML type ", (String)id, (String)handler.getAssociatedContentTypeId());
    }

    public void testXMLExistsFromFilename() throws IOException {
        String filename = "test.xml";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertEquals((String)"model handler registry does not have XML type ", (String)ContentTypeIdForXML.ContentTypeID_XML, (String)handler.getAssociatedContentTypeId());
    }

    public void testDirtyStateForEmbeddedContentTypeTextHTML() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("html.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }

    public void testDirtyStateForEmbeddedContentTypeTextCSS() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("css.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }

    public void testDirtyStateForEmbeddedContentTypeTextXML() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("xml.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDirtyStateForMisspelledEmbeddedCharset() throws Exception {
        IProject project;
        block10: {
            String projectName = "TestModelHandlers." + this.getName();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.isAccessible()) {
                project = BundleResourceUtil.createSimpleProject(projectName, null, null);
            }
            IFile testFile = project.getFile("charaset.jsp");
            String contents = "<%@ page language=\"java\" contentType=\"text/xml; charaset=UTF-8\" pageEncoding=\"UTF-8\"%>\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Contents>\n<Error state=\"fatal\" code=\"\">\n</Error>\n</Contents>";
            if (!testFile.exists()) {
                testFile.create((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            } else {
                testFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            }
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(testFile);
                IDOMDocument doc = ((IDOMModel)model).getDocument();
                INodeNotifier iNodeNotifier = (INodeNotifier)doc;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
                EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
                TestModelHandlers.assertFalse((String)("newly opened model was dirty, embedded handler changed? current family:" + embeddedHandler.getFamilyId()), (boolean)model.isDirty());
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (model == null) break block10;
            }
            model.releaseFromRead();
        }
        project.delete(true, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDirtyStateForEmbeddedCharsetWithoutContentType() throws Exception {
        IProject project;
        block10: {
            String projectName = "TestModelHandlers." + this.getName();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.isAccessible()) {
                project = BundleResourceUtil.createSimpleProject(projectName, null, null);
            }
            IFile testFile = project.getFile("charaset.jsp");
            String contents = "<%@ page language=\"java\" contentType=\"charset=UTF-8\" pageEncoding=\"UTF-8\"%>\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Contents>\n<Error state=\"fatal\" code=\"\">\n</Error>\n</Contents>";
            if (!testFile.exists()) {
                testFile.create((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            } else {
                testFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            }
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(testFile);
                IDOMDocument doc = ((IDOMModel)model).getDocument();
                INodeNotifier iNodeNotifier = (INodeNotifier)doc;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
                EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
                TestModelHandlers.assertFalse((String)("newly opened model was dirty, embedded handler changed? current family:" + embeddedHandler.getFamilyId()), (boolean)model.isDirty());
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (model == null) break block10;
            }
            model.releaseFromRead();
        }
        project.delete(true, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDirtyStateForUnsupportedEmbeddedContentType() throws Exception {
        IProject project;
        block7: {
            String projectName = "TestModelHandlers." + this.getName();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.isAccessible()) {
                project = BundleResourceUtil.createSimpleProject(projectName, null, null);
            }
            IFile testFile = project.getFile("unsupported.jsp");
            String contents = "<%@ page language=\"java\" contentType=\"image/gif\"%>\nout.write(\"GIF89a\"";
            if (!testFile.exists()) {
                testFile.create((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            } else {
                testFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes("utf8")), 1, null);
            }
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(testFile);
                TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (model == null) break block7;
            }
            model.releaseFromRead();
        }
        project.delete(true, null);
    }

    public void testDirtyStateForEmbeddedContentTypeSubXML() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("rdf.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }

    public void testDirtyStateForDefaultEmbeddedContentType() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("default.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }

    public void testDirtyStateWithNoPageDirective() throws Exception {
        String name = "bug243243";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isAccessible()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug243243", "/bug243243");
        }
        IFile testFile = project.getFile("nodirective.jsp");
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(testFile);
        TestModelHandlers.assertFalse((String)("newly opened model was dirty " + testFile.getName()), (boolean)model.isDirty());
        model.releaseFromRead();
        project.delete(true, null);
    }
}

