/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.translation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPJavaTranslatorCustomTagTest
extends TestCase {
    static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    String wtp_autotest_noninteractive = null;

    public JSPJavaTranslatorCustomTagTest() {
    }

    public JSPJavaTranslatorCustomTagTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, this.wtp_autotest_noninteractive);
        }
    }

    public void test_310085() throws Exception {
        String projectName = "bug_310085";
        IProject project = BundleResourceUtil.createJavaWebProject(projectName);
        JSPJavaTranslatorCustomTagTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + projectName, "/" + projectName);
        IFile file = project.getFile("WebContent/test310085.jsp");
        JSPJavaTranslatorCustomTagTest.assertTrue((boolean)file.exists());
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        helper.setURI(file.getFullPath().toString());
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        String strings = "";
        int i = 0;
        while (i < reporter.getMessages().size()) {
            strings = String.valueOf(strings) + ((IMessage)reporter.getMessages().get(i)).getText() + "\n";
            ++i;
        }
        JSPJavaTranslatorCustomTagTest.assertTrue((String)("Found JSP Java problem(s) for custom tag: " + strings), (boolean)reporter.getMessages().isEmpty());
    }

    public void test_326193() throws Exception {
        String projectName = "bug_326193";
        IProject project = BundleResourceUtil.createJavaWebProject(projectName);
        JSPJavaTranslatorCustomTagTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + projectName, "/" + projectName);
        IFile file = project.getFile("WebContent/test326193.jsp");
        JSPJavaTranslatorCustomTagTest.assertTrue((boolean)file.exists());
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        helper.setURI(file.getFullPath().toOSString());
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        String strings = "";
        int i = 0;
        while (i < reporter.getMessages().size()) {
            strings = String.valueOf(strings) + ((IMessage)reporter.getMessages().get(i)).getText() + "\n";
            ++i;
        }
        JSPJavaTranslatorCustomTagTest.assertTrue((String)("found jsp java error for empty end tag in xml comment in script:" + strings), (boolean)reporter.getMessages().isEmpty());
    }
}

