/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;

public class FMCSTests
extends TestCase {
    private IProject createProject(String name) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            project = BundleResourceUtil.createSimpleProject(name, null, null);
        } else if (!project.isAccessible()) {
            project.open(null);
        }
        return project;
    }

    public void testFacetModuleAbstractionWithWebFragment() throws IOException, CoreException {
        IProject bd1 = this.createProject("BugDemo1");
        IProject bd2 = this.createProject("BugDemo2");
        BundleResourceUtil.copyBundleZippedEntriesIntoWorkspace("/testfiles/jsp_include_false_error.zip", (IPath)Path.ROOT);
        bd1.refreshLocal(2, null);
        bd2.refreshLocal(2, null);
        FMCSTests.assertEquals((String)"/BugDemo2/src/META-INF/resources/referenced.jsp", (String)("" + FacetModuleCoreSupport.resolve((IPath)new Path("BugDemo1/WebContent/index.jsp"), (String)"referenced.jsp")));
    }

    public void testFacetModuleAbstractionWithoutWebFragment() throws Exception {
        IProject bd1 = this.createProject("BugDemo1");
        IProject bd2 = this.createProject("BugDemo2");
        BundleResourceUtil.copyBundleZippedEntriesIntoWorkspace("/testfiles/jsp_include_false_error.zip", (IPath)Path.ROOT);
        bd1.refreshLocal(2, null);
        bd2.refreshLocal(2, null);
        FMCSTests.assertEquals((String)"/BugDemo2/src/WEB-INF/web.xml", (String)("" + FacetModuleCoreSupport.resolve((IPath)new Path("/BugDemo2/src/META-INF/resources/referenced.jsp"), (String)"/WEB-INF/web.xml")));
    }

    public void testFacetModuleAbstractionInDynamicWebProject() throws Exception {
        IProject bd1 = this.createProject("bug_399017");
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_399017", bd1.getFullPath().toString());
        bd1.refreshLocal(2, null);
        FMCSTests.assertEquals((String)"/bug_399017/WebContent/header.jspf", (String)("" + FacetModuleCoreSupport.resolve((IPath)new Path("/bug_399017/WebContent/main.jsp"), (String)"header.jspf")));
    }
}

