/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPDirectiveValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.util.Sorter;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;

public class JSPDirectiveValidatorTest
extends TestCase {
    private String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "testvalidatejspdirectives";
    private static final String FRAGMENT_NAME = "fragmentThatDoesntExist.jspf";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            BundleResourceUtil.createJavaWebProject(PROJECT_NAME);
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testvalidatejspdirectives", "/testvalidatejspdirectives");
        }
        JSPDirectiveValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testBug265710Expression() throws Exception {
        JSPDirectiveValidator validator = new JSPDirectiveValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspdirectives/WebContent/bug265710expression.jsp";
        JSPDirectiveValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        if (reporter.getMessages().size() > 0) {
            Iterator it = reporter.getMessages().iterator();
            while (it.hasNext()) {
                IMessage message = (IMessage)it.next();
                if (message.getLineNumber() != 14 || message.getSeverity() != 1) continue;
                JSPDirectiveValidatorTest.fail((String)"JSP Directive Validator flagged a JSP expression in the import directive");
            }
        }
    }

    public void testBug265710El() throws Exception {
        JSPDirectiveValidator validator = new JSPDirectiveValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspdirectives/WebContent/bug265710el.jsp";
        JSPDirectiveValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        if (reporter.getMessages().size() > 0) {
            Iterator it = reporter.getMessages().iterator();
            while (it.hasNext()) {
                IMessage message = (IMessage)it.next();
                if (message.getLineNumber() != 11 || message.getSeverity() != 1) continue;
                JSPDirectiveValidatorTest.fail((String)"JSP Directive Validator flagged JSP EL in the import directive");
            }
        }
    }

    public void testIncludeDirective() throws Exception {
        JSPDirectiveValidator validator = new JSPDirectiveValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspdirectives/WebContent/testinclude.jsp";
        JSPDirectiveValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        boolean foundMissingInclude = false;
        boolean foundIncludeWithError = false;
        if (reporter.getMessages().size() > 0) {
            Iterator it = reporter.getMessages().iterator();
            boolean foundError = false;
            while (it.hasNext() && !foundError) {
                IMessage message = (IMessage)it.next();
                if (message.getLineNumber() == 11) {
                    foundIncludeWithError = true;
                    continue;
                }
                if (message.getLineNumber() != 12) continue;
                String expectedMsg = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_4, (Object[])new String[]{FRAGMENT_NAME, "/testvalidatejspdirectives/WebContent/fragmentThatDoesntExist.jspf"});
                if (!expectedMsg.equals(message.getText())) {
                    JSPDirectiveValidatorTest.fail((String)"Error found on line 12, but was not a missing fragment error.");
                }
                foundMissingInclude = true;
                break;
            }
        }
        JSPDirectiveValidatorTest.assertFalse((String)"JSP Directive Validator reported an error for a fragment that should be locatable.", (boolean)foundIncludeWithError);
        JSPDirectiveValidatorTest.assertTrue((String)"JSP Directive Validator did not report the missing fragment.", (boolean)foundMissingInclude);
    }

    public void testIncludeDirectiveXML() throws Exception {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<jsp:root xmlns:jsp=\"http://java.sun.com/JSP/Page\" version=\"2.0\">\n<jsp:directive.include  file=\"missing.jspf\"/>\n";
        this.runNegativeTest("/" + this.getName() + "/test.jsp", contents, (AbstractValidator)new JSPBatchValidator(), "Fragment \"missing.jspf\" was not found at expected path /testIncludeDirectiveXML/missing.jspf");
    }

    public void testIncludeDirective2() throws Exception {
        String contents = "<%@include file=\"missing.jspf\"%>\n";
        this.runNegativeTest("/" + this.getName() + "/test.jsp", contents, (AbstractValidator)new JSPBatchValidator(), "Fragment \"missing.jspf\" was not found at expected path /testIncludeDirective2/missing.jspf");
    }

    public void testIncludeAction() throws Exception {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<jsp:root xmlns:jsp=\"http://java.sun.com/JSP/Page\" version=\"2.0\">\n<jsp:include page=\"missing.jspf\"/>\n";
        this.runNegativeTest("/" + this.getName() + "/test.jsp", contents, (AbstractValidator)new JSPBatchValidator(), "Fragment \"missing.jspf\" was not found at expected path /testIncludeAction/missing.jspf");
    }

    public void testIncludeMappedURL() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("delos");
        if (!project.exists()) {
            BundleResourceUtil.createSimpleProject("delos", null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/delos", "/delos");
        }
        JSPDirectiveValidatorTest.assertTrue((String)"project could not be created", (boolean)project.exists());
        JSPDirectiveValidator validator = new JSPDirectiveValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/delos/WebContent/1.jsp";
        JSPDirectiveValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPDirectiveValidatorTest.assertTrue((String)"problems were found in JSP file", (boolean)reporter.getMessages().isEmpty());
        try {
            project.delete(true, null);
        }
        catch (CoreException coreException) {}
    }

    protected void runNegativeTest(String filePath, String content, AbstractValidator validator, String expectedProblemMessages) throws Exception {
        Path path = new Path(filePath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (!project.exists()) {
            BundleResourceUtil.createJavaWebProject(path.segment(0));
        }
        ResourcesPlugin.getWorkspace().checkpoint(true);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        file.create((InputStream)new ByteArrayInputStream(content.getBytes("utf8")), true, null);
        ValidationResult result = validator.validate((IResource)file, 1, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        JSPDirectiveValidatorTest.assertEquals((String)expectedProblemMessages, (String)this.sortMessages(result.getReporter((IProgressMonitor)new NullProgressMonitor()).getMessages()));
    }

    private String sortMessages(List messages) {
        Object[] sorted = new ValidatorMessageSorter().sort(messages.toArray());
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < sorted.length) {
            if (sorted[i] instanceof ValidationMessage) {
                s.append(((ValidationMessage)sorted[i]).getMessage());
            } else {
                s.append(((IMessage)sorted[i]).getText());
            }
            ++i;
        }
        return s.toString();
    }

    static class ValidatorMessageSorter
    extends Sorter {
        ValidatorMessageSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            if (elementOne instanceof ValidationMessage) {
                return ((ValidationMessage)elementTwo).getMessage().compareTo(((ValidationMessage)elementOne).getMessage()) > 0;
            }
            return ((IMessage)elementTwo).getOffset() > ((IMessage)elementOne).getOffset();
        }
    }
}

