/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests.ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeTestCase
extends TestCase {
    protected static IProject project;
    protected static ProjectProperties props;
    protected static IRuntime runtime;
    protected static IRuntimeWorkingCopy runtimeWC;
    private static final PropertyChangeListener pcl;

    static {
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
            }
        };
    }

    protected IRuntime getRuntime() throws Exception {
        if (runtime == null) {
            runtime = this.createRuntime();
        }
        return runtime;
    }

    protected IProject getProject() throws CoreException {
        if (project == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject("test")) != null && !project.exists()) {
            project.create(null);
            project.open(null);
        }
        return project;
    }

    protected ProjectProperties getProjectProperties() throws CoreException {
        if (props == null) {
            props = ServerPlugin.getProjectProperties((IProject)this.getProject());
        }
        return props;
    }

    protected IRuntimeWorkingCopy getRuntimeWorkingCopy() throws Exception {
        if (runtimeWC == null) {
            runtimeWC = this.getRuntime().createWorkingCopy();
        }
        return runtimeWC;
    }

    public abstract IRuntime createRuntime() throws Exception;

    public abstract void deleteRuntime(IRuntime var1) throws Exception;

    public static void addOrderedTests(Class<? extends TestCase> testClass, TestSuite suite) {
        suite.addTest(TestSuite.createTest(testClass, (String)"deleteProject"));
        suite.addTest(TestSuite.createTest(testClass, (String)"createWorkingCopy"));
        suite.addTest(TestSuite.createTest(testClass, (String)"isWorkingCopyDirty"));
        suite.addTest(TestSuite.createTest(testClass, (String)"setReadOnly"));
        suite.addTest(TestSuite.createTest(testClass, (String)"setStub"));
        suite.addTest(TestSuite.createTest(testClass, (String)"isWorkingCopyDirty2"));
        suite.addTest(TestSuite.createTest(testClass, (String)"addPropertyChangeListener"));
        suite.addTest(TestSuite.createTest(testClass, (String)"removePropertyChangeListener"));
    }

    public static void addFinalTests(Class<? extends TestCase> testClass, TestSuite suite) {
        suite.addTest(TestSuite.createTest(testClass, (String)"clearWorkingCopy"));
        suite.addTest(TestSuite.createTest(testClass, (String)"deleteRuntime"));
    }

    public void testGetProperties() throws Exception {
        this.getProjectProperties();
    }

    public void testGetRuntime() throws Exception {
        AbstractRuntimeTestCase.assertNull((Object)this.getProjectProperties().getRuntimeTarget());
    }

    public void deleteProject() throws Exception {
        this.getProject().delete(true, true, null);
    }

    public void testGetAdapter() throws Exception {
        this.getRuntime().getAdapter(RuntimeDelegate.class);
    }

    public void testLoadAdapter() throws Exception {
        this.getRuntime().loadAdapter(RuntimeDelegate.class, null);
    }

    public void testValidate() throws Exception {
        IStatus status = this.getRuntime().validate(null);
        AbstractRuntimeTestCase.assertTrue((status.isOK() || status.getSeverity() == 2 ? 1 : 0) != 0);
    }

    public void testValidate2() throws Exception {
        IRuntimeWorkingCopy wc = this.getRuntime().createWorkingCopy();
        wc.setLocation(null);
        IStatus status = wc.validate(null);
        AbstractRuntimeTestCase.assertTrue((!status.isOK() ? 1 : 0) != 0);
    }

    public void testModifyRuntime() throws Exception {
        IRuntimeWorkingCopy wc = this.getRuntime().createWorkingCopy();
        String name = wc.getName();
        wc.setName(String.valueOf(name) + "x");
        wc.setName(name);
        wc.save(false, null);
    }

    public void testIsPrivate() throws Exception {
        ((Runtime)this.getRuntime()).isPrivate();
    }

    public void testIsReadOnly() throws Exception {
        this.getRuntime().isReadOnly();
    }

    public void testGetId() throws Exception {
        this.getRuntime().getId();
    }

    public void testGetName() throws Exception {
        this.getRuntime().getName();
    }

    public void testGetTimestamp() throws Exception {
        ((Runtime)this.getRuntime()).getTimestamp();
    }

    public void testGetRuntimeType() throws Exception {
        AbstractRuntimeTestCase.assertNotNull((Object)this.getRuntime().getRuntimeType());
    }

    public void testGetLocation() throws Exception {
        AbstractRuntimeTestCase.assertNotNull((Object)this.getRuntime().getLocation());
    }

    public void testIsStub() throws Exception {
        this.getRuntime().isStub();
    }

    public void createWorkingCopy() throws Exception {
        this.getRuntimeWorkingCopy();
    }

    public void isWorkingCopyDirty() throws Exception {
        AbstractRuntimeTestCase.assertFalse((boolean)this.getRuntimeWorkingCopy().isDirty());
    }

    public void setReadOnly() throws Exception {
        this.getRuntimeWorkingCopy().setReadOnly(true);
        this.getRuntimeWorkingCopy().setReadOnly(false);
    }

    public void setStub() throws Exception {
        this.getRuntimeWorkingCopy().setStub(true);
        this.getRuntimeWorkingCopy().setStub(false);
    }

    public void isWorkingCopyDirty2() throws Exception {
        AbstractRuntimeTestCase.assertTrue((boolean)this.getRuntimeWorkingCopy().isDirty());
    }

    public void addPropertyChangeListener() throws Exception {
        this.getRuntimeWorkingCopy().addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener() throws Exception {
        this.getRuntimeWorkingCopy().removePropertyChangeListener(pcl);
    }

    public void clearWorkingCopy() {
        runtimeWC = null;
    }

    public void deleteRuntime() throws Exception {
        this.deleteRuntime(this.getRuntime());
        runtime = null;
    }
}

