/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.tests;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;

public class FileSchemeTests
extends TestCase {
    private final String projectName_ = "TestProject";

    public FileSchemeTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FileSchemeTests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            FileSchemeTests.runOne(methodToRun);
        }
    }

    public static Test suite() {
        return new TestSuite(FileSchemeTests.class);
    }

    protected static void runAll() {
        TestRunner.run((Test)FileSchemeTests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        FileSchemeTests test = new FileSchemeTests(methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject("TestProject");
        if (project != null && project.exists()) {
            project.delete(true, null);
        }
        IProjectDescription desc = workspaceRoot.getWorkspace().newProjectDescription("TestProject");
        project.create(desc, null);
        project.open(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject("TestProject");
        project.delete(true, null);
    }

    public static Test getTest() {
        return new FileSchemeTests("FileSchemeTests");
    }

    public void testBadURIs() {
        IURI newURI;
        IURIScheme scheme = EnvironmentService.getFileScheme();
        try {
            newURI = scheme.newURI("bogus:/somefolder/somefile.txt");
            FileSchemeTests.assertTrue((String)"Non file protocol should cause an exception", (boolean)false);
            newURI.asFile();
        }
        catch (URIException uRIException) {}
        try {
            newURI = scheme.newURI(":/somefolder/somefile.txt");
            FileSchemeTests.assertTrue((String)"Non file protocol should cause an exception", (boolean)false);
            newURI.asFile();
        }
        catch (URIException uRIException) {}
        try {
            newURI = scheme.newURI(null);
            FileSchemeTests.assertTrue((String)"Non file protocol should cause an exception", (boolean)false);
            newURI.asFile();
        }
        catch (URIException uRIException) {}
        try {
            newURI = scheme.newURI(null);
            FileSchemeTests.assertTrue((String)"Non file protocol should cause an exception", (boolean)false);
            newURI.asFile();
        }
        catch (URIException uRIException) {}
        try {
            newURI = scheme.newURI(null);
            FileSchemeTests.assertTrue((String)"Non file protocol should cause an exception", (boolean)false);
            newURI.asFile();
        }
        catch (URIException uRIException) {}
    }

    public void testNewURI() {
        IURIScheme scheme = EnvironmentService.getFileScheme();
        try {
            IURI uri1 = scheme.newURI("file:/tmp/myfile");
            IURI uri2 = scheme.newURI("relativedirectory/relativefile");
            IURI uri3 = scheme.newURI(uri1);
            IURI uri4 = scheme.newURI(uri2);
            IURI uri5 = scheme.newURI(new URL(uri1.asString()));
            File file1 = uri1.asFile();
            uri1.touchLeaf();
            FileSchemeTests.assertTrue((String)"Is a file", (boolean)file1.isFile());
            FileSchemeTests.assertTrue((String)"File names not the same", (boolean)uri1.asString().equals(uri3.toString()));
            FileSchemeTests.assertTrue((String)"File names not the same", (boolean)uri2.asString().equals(uri4.toString()));
            FileSchemeTests.assertTrue((String)"File names not the same", (boolean)uri1.asString().equals(uri5.toString()));
            FileSchemeTests.assertTrue((String)"Protocol not file", (boolean)uri1.getURIScheme().toString().equals("file"));
            FileSchemeTests.assertTrue((String)"Protocol not file", (boolean)uri3.getURIScheme().toString().equals("file"));
            FileSchemeTests.assertTrue((String)"Protocol not file", (boolean)uri5.getURIScheme().toString().equals("file"));
            FileSchemeTests.assertTrue((String)"Protocol not relative", (boolean)uri2.getURIScheme().toString().equals("relative"));
            FileSchemeTests.assertTrue((String)"Protocol not relative", (boolean)uri4.getURIScheme().toString().equals("relative"));
            uri1.erase();
        }
        catch (URIException exc) {
            FileSchemeTests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileSchemeTests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testHierarchical() {
        IURIScheme scheme = EnvironmentService.getFileScheme();
        FileSchemeTests.assertTrue((String)"Not hierarchical", (boolean)scheme.isHierarchical());
    }

    public void testValidURIs() {
        try {
            IURIScheme scheme = EnvironmentService.getFileScheme();
            IURI uri1 = scheme.newURI("file:/tmp/somedir/somefile");
            IURI uri2 = scheme.newURI("file:/tmp");
            IURI uri3 = scheme.newURI("somerel");
            IURI uri4 = scheme.newURI("somerel/somemorerel");
            IURI uri5 = scheme.newURI("./somerel/somemore");
            FileSchemeTests.assertTrue((String)"URI not valid", (boolean)scheme.isValid(uri1));
            FileSchemeTests.assertTrue((String)"URI not valid", (boolean)scheme.isValid(uri2));
            FileSchemeTests.assertTrue((String)"URI not valid", (boolean)scheme.isValid(uri3));
            FileSchemeTests.assertTrue((String)"URI not valid", (boolean)scheme.isValid(uri4));
            FileSchemeTests.assertTrue((String)"URI not valid", (boolean)scheme.isValid(uri5));
            FileSchemeTests.assertTrue((String)"URI has not valid status", (scheme.validate(uri1).getSeverity() == 0 ? 1 : 0) != 0);
            FileSchemeTests.assertTrue((String)"URI has not valid status", (scheme.validate(uri2).getSeverity() == 0 ? 1 : 0) != 0);
            FileSchemeTests.assertTrue((String)"URI has not valid status", (scheme.validate(uri3).getSeverity() == 0 ? 1 : 0) != 0);
            FileSchemeTests.assertTrue((String)"URI has not valid status", (scheme.validate(uri4).getSeverity() == 0 ? 1 : 0) != 0);
            FileSchemeTests.assertTrue((String)"URI has not valid status", (scheme.validate(uri5).getSeverity() == 0 ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            FileSchemeTests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testInvalidURIs() {
        try {
            IURIScheme eclipseScheme = EnvironmentService.getEclipseScheme();
            IURIScheme fileScheme = EnvironmentService.getFileScheme();
            IURI uri1 = eclipseScheme.newURI("platform:/resource/somedir/somefile");
            FileSchemeTests.assertTrue((String)"URI valid", (!fileScheme.isValid(uri1) ? 1 : 0) != 0);
            FileSchemeTests.assertTrue((String)"URI has a valid status", (fileScheme.validate(uri1).getSeverity() == 4 ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            FileSchemeTests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }
}

