/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.ITestDataModel;
import org.eclipse.wst.common.frameworks.datamodel.tests.TestDataModelProvider;

public class DataModelFactoryTest
extends TestCase {
    public void testBogusExtension() {
        IDataModel dataModel = null;
        try {
            dataModel = DataModelFactory.createDataModel((String)"bogus");
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testInvalidExtensionID() {
        IDataModel dataModel = null;
        try {
            dataModel = DataModelFactory.createDataModel((String)"badID");
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testInvalidExtensionClass() {
        IDataModel dataModel = null;
        try {
            dataModel = DataModelFactory.createDataModel(Object.class);
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testValidExtensionIDAndProviderType() {
        String[] descs = DataModelFactory.getDataModelProviderIDsForKind((String)"testProviderBase");
        IDataModel dataModel = DataModelFactory.createDataModel((String)descs[0]);
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionID() {
        IDataModel dataModel = DataModelFactory.createDataModel((String)"org.eclipse.wst.common.frameworks.datamodel.tests.ITestDataModel");
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionClass() {
        IDataModel dataModel = DataModelFactory.createDataModel(ITestDataModel.class);
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionInstance() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new TestDataModelProvider());
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }
}

