/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.TestListener;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;

public class SimpleDataModelTest
extends TestCase {
    private String id;
    private List extendedContext;
    private IDataModel dm;
    private TestListener dmL;

    protected void setUp() throws Exception {
        super.setUp();
        this.dm = DataModelFactory.createDataModel((IDataModelProvider)new DMProvider());
        this.dmL = new TestListener();
        this.dm.addListener((IDataModelListener)this.dmL);
    }

    public void testBasics() {
        this.id = null;
        SimpleDataModelTest.assertEquals((String)"", (String)this.dm.getID());
        this.id = "foo";
        SimpleDataModelTest.assertEquals((String)"foo", (String)this.dm.getID());
        this.extendedContext = null;
        SimpleDataModelTest.assertNotNull((Object)this.dm.getExtendedContext());
        this.extendedContext = new ArrayList();
        SimpleDataModelTest.assertTrue((this.dm.getExtendedContext() == this.extendedContext ? 1 : 0) != 0);
        this.extendedContext.add("foo");
        SimpleDataModelTest.assertTrue((this.dm.getExtendedContext() == this.extendedContext ? 1 : 0) != 0);
        SimpleDataModelTest.assertNotNull((Object)this.dm.getDefaultOperation());
    }

    public void testInvalidProperty() {
        String PROPERTY_NOT_LOCATED_ = WTPResourceHandler.getString((String)"20");
        RuntimeException ex = null;
        try {
            this.dm.getProperty("foo");
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(PROPERTY_NOT_LOCATED_));
        ex = null;
        try {
            this.dm.getIntProperty("foo");
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(PROPERTY_NOT_LOCATED_));
        ex = null;
        ex = null;
        try {
            this.dm.getBooleanProperty("foo");
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(PROPERTY_NOT_LOCATED_));
        ex = null;
        ex = null;
        try {
            this.dm.getStringProperty("foo");
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(PROPERTY_NOT_LOCATED_));
        ex = null;
        try {
            this.dm.getStringProperty(null);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(PROPERTY_NOT_LOCATED_));
    }

    public void testPropertyDescriptors() {
        int value;
        DataModelPropertyDescriptor[] descriptors = this.dm.getValidPropertyDescriptors("INT_PROP2");
        int i = 0;
        while (i < descriptors.length) {
            int value2 = i + 1;
            SimpleDataModelTest.assertEquals((int)value2, (int)((Integer)descriptors[i].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)("" + value2), (String)descriptors[i].getPropertyDescription());
            ++i;
        }
        descriptors = this.dm.getValidPropertyDescriptors("INT_PROP3");
        String[] descriptions = new String[]{"one", "two", "three"};
        int i2 = 0;
        while (i2 < descriptors.length) {
            value = i2 + 1;
            SimpleDataModelTest.assertEquals((int)value, (int)((Integer)descriptors[i2].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)descriptions[i2], (String)descriptors[i2].getPropertyDescription());
            ++i2;
        }
        descriptors = this.dm.getValidPropertyDescriptors("INT_PROP4");
        i2 = 0;
        while (i2 < descriptors.length) {
            value = i2 + 1;
            SimpleDataModelTest.assertEquals((int)value, (int)((Integer)descriptors[i2].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)descriptions[i2], (String)descriptors[i2].getPropertyDescription());
            ++i2;
        }
        i2 = 1;
        while (i2 < 4) {
            this.dm.setIntProperty("INT_PROP2", i2);
            DataModelPropertyDescriptor descriptor = this.dm.getPropertyDescriptor("INT_PROP2");
            SimpleDataModelTest.assertEquals((Object)descriptor.getPropertyValue(), (Object)this.dm.getProperty("INT_PROP2"));
            SimpleDataModelTest.assertEquals((int)((Integer)descriptor.getPropertyValue()), (int)this.dm.getIntProperty("INT_PROP2"));
            SimpleDataModelTest.assertTrue((boolean)descriptor.getPropertyDescription().equals(Integer.toString(i2)));
            this.dm.setIntProperty("INT_PROP3", i2);
            descriptor = this.dm.getPropertyDescriptor("INT_PROP3");
            SimpleDataModelTest.assertEquals((Object)descriptor.getPropertyValue(), (Object)this.dm.getProperty("INT_PROP3"));
            SimpleDataModelTest.assertEquals((int)((Integer)descriptor.getPropertyValue()), (int)this.dm.getIntProperty("INT_PROP3"));
            SimpleDataModelTest.assertTrue((boolean)descriptor.getPropertyDescription().equals(descriptions[i2 - 1]));
            this.dm.setIntProperty("INT_PROP4", i2);
            descriptor = this.dm.getPropertyDescriptor("INT_PROP4");
            SimpleDataModelTest.assertEquals((Object)descriptor.getPropertyValue(), (Object)this.dm.getProperty("INT_PROP4"));
            SimpleDataModelTest.assertEquals((int)((Integer)descriptor.getPropertyValue()), (int)this.dm.getIntProperty("INT_PROP4"));
            SimpleDataModelTest.assertTrue((boolean)descriptor.getPropertyDescription().equals(descriptions[i2 - 1]));
            ++i2;
        }
    }

    public void testDefaults() {
        SimpleDataModelTest.assertEquals((boolean)true, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
        SimpleDataModelTest.assertEquals((boolean)true, (boolean)((Boolean)this.dm.getProperty("BOOLEAN_PROP")));
        SimpleDataModelTest.assertEquals((int)10, (int)this.dm.getIntProperty("INT_PROP"));
        SimpleDataModelTest.assertEquals((int)10, (int)((Integer)this.dm.getProperty("INT_PROP")));
        SimpleDataModelTest.assertEquals((String)"foo10true", (String)((String)this.dm.getProperty("STRING_PROP")));
        SimpleDataModelTest.assertEquals((String)"foo10true", (String)this.dm.getStringProperty("STRING_PROP"));
    }

    public void testPropertyChangedOnListener() {
        this.dmL.clearEvents();
        DataModelEvent event = new DataModelEvent(this.dm, "A.P", 1);
        this.dmL.propertyChanged(event);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        SimpleDataModelTest.assertTrue((boolean)events.contains(event));
        this.dmL.clearEvents();
        TestListener idml = this.dmL;
        idml.propertyChanged(event);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        SimpleDataModelTest.assertTrue((boolean)events.contains(event));
    }

    public void testAddRemoveListener() {
        this.dmL.clearEvents();
        this.dm.notifyPropertyChange("INT_PROP2", 2);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        this.dmL.clearEvents();
        this.dm.removeListener((IDataModelListener)this.dmL);
        this.dm.notifyPropertyChange("INT_PROP2", 2);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)0, (int)events.size());
        this.dmL.clearEvents();
        this.dm.addListener((IDataModelListener)this.dmL);
        this.dm.addListener((IDataModelListener)this.dmL);
        this.dm.addListener((IDataModelListener)this.dmL);
        this.dm.addListener((IDataModelListener)this.dmL);
        this.dm.addListener((IDataModelListener)this.dmL);
        this.dm.notifyPropertyChange("INT_PROP2", 2);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        this.dmL.clearEvents();
        this.dm.removeListener((IDataModelListener)this.dmL);
        this.dm.notifyPropertyChange("INT_PROP2", 2);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)0, (int)events.size());
    }

    public void testFiringEvents() {
        this.dmL.clearEvents();
        this.dm.notifyPropertyChange("INT_PROP2", 2);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        DataModelEvent event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        this.dmL.clearEvents();
        this.dm.notifyPropertyChange("INT_PROP2", 4);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)4, (int)event.getFlag());
    }

    public void testSimpleSetEvents() {
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 100);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        DataModelEvent event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)100, (int)this.dm.getIntProperty("INT_PROP2"));
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 100);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)0, (int)events.size());
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 101);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
    }

    public void testComplexEvents() {
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP", 11);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)4, (int)events.size());
        DataModelEvent event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)11, (int)((Integer)this.dm.getProperty("INT_PROP2")));
        event = (DataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)4, (int)event.getFlag());
        DataModelPropertyDescriptor[] descriptors = event.getValidPropertyDescriptors();
        DataModelPropertyDescriptor[] descriptors2 = this.dm.getValidPropertyDescriptors("INT_PROP2");
        SimpleDataModelTest.assertEquals((int)11, (int)descriptors.length);
        SimpleDataModelTest.assertEquals((int)11, (int)descriptors2.length);
        event = (DataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11true", (Object)event.getProperty());
        SimpleDataModelTest.assertEquals((Object)"foo11true", (Object)this.dm.getDefaultProperty("STRING_PROP"));
        SimpleDataModelTest.assertEquals((Object)"foo11true", (Object)this.dm.getProperty("STRING_PROP"));
        event = (DataModelEvent)events.get(3);
        SimpleDataModelTest.assertEquals((String)"INT_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)11, (int)((Integer)this.dm.getProperty("INT_PROP")));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", false);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)3, (int)events.size());
        event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)3, (int)event.getFlag());
        SimpleDataModelTest.assertFalse((boolean)this.dm.isPropertyEnabled("BOOLEAN_PROP2"));
        SimpleDataModelTest.assertFalse((boolean)event.isPropertyEnabled());
        event = (DataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)event.getProperty());
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)this.dm.getDefaultProperty("STRING_PROP"));
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)this.dm.getProperty("STRING_PROP"));
        event = (DataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((boolean)false, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
        this.dm.setStringProperty("STRING_PROP", "bar");
        SimpleDataModelTest.assertEquals((String)"bar", (String)this.dm.getStringProperty("STRING_PROP"));
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)this.dm.getDefaultProperty("STRING_PROP"));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", true);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)2, (int)events.size());
        event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        event = (DataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((String)"bar", (String)this.dm.getStringProperty("STRING_PROP"));
        this.dm.setStringProperty("STRING_PROP", null);
        SimpleDataModelTest.assertEquals((String)"foo11true", (String)this.dm.getStringProperty("STRING_PROP"));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", false);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)3, (int)events.size());
        event = (DataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)3, (int)event.getFlag());
        SimpleDataModelTest.assertFalse((boolean)this.dm.isPropertyEnabled("BOOLEAN_PROP2"));
        SimpleDataModelTest.assertFalse((boolean)event.isPropertyEnabled());
        event = (DataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)event.getProperty());
        event = (DataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((boolean)false, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
    }

    private class DMProvider
    extends AbstractDataModelProvider {
        public static final String INT_PROP = "INT_PROP";
        public static final String INT_PROP2 = "INT_PROP2";
        public static final String INT_PROP3 = "INT_PROP3";
        public static final String INT_PROP4 = "INT_PROP4";
        public static final String BOOLEAN_PROP = "BOOLEAN_PROP";
        public static final String BOOLEAN_PROP2 = "BOOLEAN_PROP2";
        public static final String STRING_PROP = "STRING_PROP";

        private DMProvider() {
        }

        public Set getPropertyNames() {
            Set propertyNames = super.getPropertyNames();
            propertyNames.add(INT_PROP);
            propertyNames.add(INT_PROP2);
            propertyNames.add(INT_PROP3);
            propertyNames.add(INT_PROP4);
            propertyNames.add(BOOLEAN_PROP);
            propertyNames.add(BOOLEAN_PROP2);
            propertyNames.add(STRING_PROP);
            return propertyNames;
        }

        public Object getDefaultProperty(String propertyName) {
            if (propertyName.equals(INT_PROP)) {
                return new Integer(10);
            }
            if (propertyName.equals(INT_PROP2)) {
                return this.getProperty(INT_PROP);
            }
            if (propertyName.equals(BOOLEAN_PROP)) {
                return Boolean.TRUE;
            }
            if (propertyName.equals(STRING_PROP)) {
                return "foo" + this.getProperty(INT_PROP) + this.getProperty(BOOLEAN_PROP);
            }
            return super.getDefaultProperty(propertyName);
        }

        public boolean isPropertyEnabled(String propertyName) {
            if (propertyName.equals(BOOLEAN_PROP2)) {
                return this.getBooleanProperty(BOOLEAN_PROP);
            }
            return true;
        }

        public boolean propertySet(String propertyName, Object propertyValue) {
            if (propertyName.equals(INT_PROP)) {
                this.model.notifyPropertyChange(INT_PROP2, 1);
                this.model.notifyPropertyChange(INT_PROP2, 4);
                this.model.notifyPropertyChange(STRING_PROP, 2);
            }
            if (propertyName.equals(BOOLEAN_PROP)) {
                this.model.notifyPropertyChange(BOOLEAN_PROP2, 3);
                this.model.notifyPropertyChange(STRING_PROP, 2);
            }
            return true;
        }

        public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
            if (INT_PROP2.equals(propertyName)) {
                int range = this.getIntProperty(INT_PROP);
                Object[] ints = new Integer[range];
                int i = 0;
                while (i < ints.length) {
                    ints[i] = new Integer(i + 1);
                    ++i;
                }
                return DataModelPropertyDescriptor.createDescriptors((Object[])ints);
            }
            if (INT_PROP3.equals(propertyName)) {
                int range = 3;
                Object[] ints = new Integer[range];
                int i = 0;
                while (i < ints.length) {
                    ints[i] = new Integer(i + 1);
                    ++i;
                }
                String[] descriptions = new String[]{"one", "two", "three"};
                return DataModelPropertyDescriptor.createDescriptors((Object[])ints, (String[])descriptions);
            }
            if (INT_PROP4.equals(propertyName)) {
                DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[3];
                String[] descriptions = new String[]{"one", "two", "three"};
                int i = 0;
                while (i < descriptors.length) {
                    descriptors[i] = new DataModelPropertyDescriptor((Object)new Integer(i + 1), descriptions[i]);
                    ++i;
                }
                return descriptors;
            }
            return null;
        }

        public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
            Object property = this.getProperty(propertyName);
            if (INT_PROP2.equals(propertyName)) {
                return new DataModelPropertyDescriptor(property);
            }
            if (INT_PROP3.equals(propertyName) || INT_PROP4.equals(propertyName)) {
                String[] descriptions = new String[]{"one", "two", "three"};
                int value = (Integer)property;
                return new DataModelPropertyDescriptor(property, descriptions[value - 1]);
            }
            return null;
        }

        public String getID() {
            return SimpleDataModelTest.this.id;
        }

        public List getExtendedContext() {
            return SimpleDataModelTest.this.extendedContext;
        }
    }
}

