/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Test_TransformOperations
extends TestCase {
    private static final String OUTPUT_PREFIX = "[Test_TransformOperations]";
    private WebProjectTestEnvironment webProjectTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this.webProjectTestEnv = new WebProjectTestEnvironment("Test_TransformOperations_" + this.getName());
        this.webProjectTestEnv.createProject(false);
        Test_TransformOperations.assertNotNull((Object)this.webProjectTestEnv);
        Test_TransformOperations.assertNotNull((Object)this.webProjectTestEnv.getTestProject());
        Test_TransformOperations.assertTrue((boolean)this.webProjectTestEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacetedTestEnv = new JSFFacetedTestEnvironment(this.webProjectTestEnv);
        jsfFacetedTestEnv.initialize("1.1");
        this.webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/Test_TransformOperations.jsp.data", "/Test_TransformOperations.jsp");
        Test_TransformOperations.assertTrue((boolean)JSFCoreUtilHelper.addJSFRuntimeJarsToClasspath((JSFVersion)JSFVersion.V1_1, (JSFFacetedTestEnvironment)jsfFacetedTestEnv));
    }

    public void testSanity() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/Test_TransformOperations.jsp", 477);
                IStructuredDocumentContext context = wrapper.getContext();
                IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                Node node = resolver.getNode();
                Test_TransformOperations.assertTrue((boolean)(node instanceof Element));
                Test_TransformOperations.assertEquals((String)"h", (String)node.getPrefix());
                Test_TransformOperations.assertEquals((String)"selectManyListbox", (String)node.getLocalName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Test_TransformOperations.fail((String)ex.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testAppendChildElementOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Element));
            Element firstChildElement = (Element)firstChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)firstChildElement.getLocalName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testAppendChildTextFromXPathOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Element));
            Element firstChildElement = (Element)firstChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)firstChildElement.getLocalName());
            Node firstGrandChildNode = firstChildElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstGrandChildNode instanceof Text));
            Text firstGrandChildText = (Text)firstGrandChildNode;
            Test_TransformOperations.assertEquals((String)"selectItem One", (String)firstGrandChildText.getData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testAppendChildTextOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            NodeList childNodes = resultElement.getChildNodes();
            Test_TransformOperations.assertTrue((childNodes.getLength() > 1 ? 1 : 0) != 0);
            Node secondChildNode = childNodes.item(1);
            Test_TransformOperations.assertTrue((boolean)(secondChildNode instanceof Element));
            Element secondChildElement = (Element)secondChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)secondChildElement.getLocalName());
            Node firstGrandChildNode = secondChildElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstGrandChildNode instanceof Text));
            Text firstGrandChildText = (Text)firstGrandChildNode;
            Test_TransformOperations.assertEquals((String)"selectItem", (String)firstGrandChildText.getData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCheckModeOperation() {
        try {
            Element resultElement;
            ITagConverter tagConverter;
            String localName;
            String prefix;
            this.webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/checkmodeop/checkModeOp.tld.data", "/META-INF/checkModeOp.tld");
            this.webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/checkmodeop/testCheckModeOperation.jsp.data", "/testCheckModeOperation.jsp");
            ContextWrapper wrapper = null;
            try {
                wrapper = this.getDocumentContext("/WebContent/testCheckModeOperation.jsp", 365);
                prefix = "cmo";
                localName = "testTagOne";
                tagConverter = this.getTagConverter(wrapper, prefix, localName, 0);
                Test_TransformOperations.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                resultElement = tagConverter.getResultElement();
                Test_TransformOperations.assertNotNull((Object)resultElement);
                Test_TransformOperations.assertEquals((String)"div", (String)resultElement.getLocalName());
                List childNodes = tagConverter.getChildModeList();
                Test_TransformOperations.assertTrue((childNodes.size() > 1 ? 1 : 0) != 0);
                Node secondChildNode = (Node)childNodes.get(1);
                Test_TransformOperations.assertTrue((boolean)(secondChildNode instanceof Element));
                Element secondChildElement = (Element)secondChildNode;
                Test_TransformOperations.assertEquals((String)"span", (String)secondChildElement.getLocalName());
                Test_TransformOperations.assertEquals((String)"t1ChildSpan", (String)secondChildElement.getAttribute("id"));
                tagConverter = this.getTagConverter(wrapper, prefix, localName, 1);
                Test_TransformOperations.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                resultElement = tagConverter.getResultElement();
                Test_TransformOperations.assertNull((Object)resultElement);
            }
            finally {
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
            try {
                wrapper = this.getDocumentContext("/WebContent/testCheckModeOperation.jsp", 531);
                prefix = "cmo";
                localName = "testTagTwo";
                tagConverter = this.getTagConverter(wrapper, prefix, localName, 0);
                Test_TransformOperations.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                resultElement = tagConverter.getResultElement();
                Test_TransformOperations.assertNotNull((Object)resultElement);
                Test_TransformOperations.assertEquals((String)"div", (String)resultElement.getLocalName());
                Test_TransformOperations.assertEquals((String)"designId", (String)resultElement.getAttribute("id"));
                tagConverter = this.getTagConverter(wrapper, prefix, localName, 1);
                Test_TransformOperations.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                resultElement = tagConverter.getResultElement();
                Test_TransformOperations.assertNotNull((Object)resultElement);
                Test_TransformOperations.assertEquals((String)"div", (String)resultElement.getLocalName());
                Test_TransformOperations.assertEquals((String)"previewId", (String)resultElement.getAttribute("id"));
            }
            finally {
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testConvertAttributeToTextOperation() {
        try {
            Element resultElement = this.getResultElement(620, "h", "commandLink");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"a", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Text));
            Text firstChildText = (Text)firstChildNode;
            Test_TransformOperations.assertEquals((String)"commandLink value", (String)firstChildText.getData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCopyAllAttributesOperation() {
        try {
            Element resultElement = this.getResultElement(620, "h", "commandLink");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"a", (String)resultElement.getLocalName());
            String attr1Value = resultElement.getAttribute("attr1");
            Test_TransformOperations.assertEquals((String)"attr1_value", (String)attr1Value);
            String attr2Value = resultElement.getAttribute("attr2");
            Test_TransformOperations.assertEquals((String)"attr2_value", (String)attr2Value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCopyAttributeOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Element));
            Element firstChildElement = (Element)firstChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)firstChildElement.getLocalName());
            String valueAttrValue = firstChildElement.getAttribute("value");
            Test_TransformOperations.assertEquals((String)"selectItem_1", (String)valueAttrValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCopyChildrenOperation() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/Test_TransformOperations.jsp", 620);
                ITagConverter tagConverter = this.getTagConverter(wrapper, "h", "commandLink", 0);
                Test_TransformOperations.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                List childNodes = tagConverter.getChildModeList();
                Test_TransformOperations.assertTrue((childNodes.size() > 1 ? 1 : 0) != 0);
                Node secondChildNode = (Node)childNodes.get(1);
                Test_TransformOperations.assertTrue((boolean)(secondChildNode instanceof Element));
                Element secondChildElement = (Element)secondChildNode;
                Test_TransformOperations.assertEquals((String)"f", (String)secondChildElement.getPrefix());
                Test_TransformOperations.assertEquals((String)"actionListener", (String)secondChildElement.getLocalName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Test_TransformOperations.fail((String)ex.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testCreateAttributeFromXPathOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            String sizeAttrValue = resultElement.getAttribute("size");
            Test_TransformOperations.assertEquals((String)"2", (String)sizeAttrValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCreateAttributeOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            String multipleAttrValue = resultElement.getAttribute("multiple");
            Test_TransformOperations.assertEquals((String)"multiple", (String)multipleAttrValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testCreateElementOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testIfNotOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            String sizeAttrValue = resultElement.getAttribute("size");
            Test_TransformOperations.assertEquals((String)"2", (String)sizeAttrValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testIfOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Element));
            Element firstChildElement = (Element)firstChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)firstChildElement.getLocalName());
            Node firstGrandChildNode = firstChildElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstGrandChildNode instanceof Text));
            Text firstGrandChildText = (Text)firstGrandChildNode;
            Test_TransformOperations.assertEquals((String)"selectItem One", (String)firstGrandChildText.getData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testIterateOverElementsOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            NodeList childNodes = resultElement.getChildNodes();
            Test_TransformOperations.assertEquals((int)2, (int)childNodes.getLength());
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                Test_TransformOperations.assertTrue((boolean)(childNode instanceof Element));
                Element childElement = (Element)childNode;
                Test_TransformOperations.assertEquals((String)"option", (String)childElement.getLocalName());
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testMakeParentElementCurrentOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            NodeList childNodes = resultElement.getChildNodes();
            Test_TransformOperations.assertEquals((int)2, (int)childNodes.getLength());
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                Test_TransformOperations.assertTrue((boolean)(childNode instanceof Element));
                Element childElement = (Element)childNode;
                Test_TransformOperations.assertEquals((String)"option", (String)childElement.getLocalName());
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testRemoveAttributeOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            String multipleAttrValue = resultElement.getAttribute("multiple");
            Test_TransformOperations.assertEquals((String)"multiple", (String)multipleAttrValue);
            ITransformOperation removeAttrOp = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_RemoveAttributeOperation, new String[]{"multiple"});
            removeAttrOp.transform(null, resultElement);
            Attr multipleAttrNode = resultElement.getAttributeNode("multiple");
            Test_TransformOperations.assertNull((Object)multipleAttrNode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    public void testRenameAttributeOperation() {
        try {
            Element resultElement = this.getResultElement(477, "h", "selectManyListbox");
            Test_TransformOperations.assertNotNull((Object)resultElement);
            Test_TransformOperations.assertEquals((String)"select", (String)resultElement.getLocalName());
            Node firstChildNode = resultElement.getFirstChild();
            Test_TransformOperations.assertTrue((boolean)(firstChildNode instanceof Element));
            Element firstChildElement = (Element)firstChildNode;
            Test_TransformOperations.assertEquals((String)"option", (String)firstChildElement.getLocalName());
            String valueAttrValue = firstChildElement.getAttribute("value");
            Test_TransformOperations.assertEquals((String)"selectItem_1", (String)valueAttrValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Test_TransformOperations.fail((String)ex.getLocalizedMessage());
        }
    }

    private Element getResultElement(int docOffset, String prefix, String localName) throws Exception {
        Element resultElement = null;
        ContextWrapper wrapper = null;
        try {
            wrapper = this.getDocumentContext("/WebContent/Test_TransformOperations.jsp", docOffset);
            ITagConverter tagConverter = this.getTagConverter(wrapper, prefix, localName, 0);
            if (tagConverter != null) {
                tagConverter.convertRefresh(null);
                resultElement = tagConverter.getResultElement();
            } else {
                System.out.printf("%s getTagConverter(...) returned null for %s:%s at document offset %d\n", OUTPUT_PREFIX, prefix, localName, docOffset);
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
        return resultElement;
    }

    private ITagConverter getTagConverter(ContextWrapper wrapper, String prefix, String localName, int mode) throws Exception {
        ITagConverter tagConverter = null;
        IStructuredDocumentContext context = wrapper.getContext();
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node node = resolver.getNode();
        if (node instanceof Element && node.getPrefix().equals(prefix) && node.getLocalName().equals(localName)) {
            Element element = (Element)node;
            IStructuredModel model = wrapper.getModel();
            if (model instanceof IDOMModel) {
                IDOMDocument document = ((IDOMModel)model).getDocument();
                if (document != null) {
                    tagConverter = DTManager.getInstance().getTagConverter(element, mode, document);
                } else {
                    System.out.printf("%s model.getDocument() returned null for %s:%s\n", OUTPUT_PREFIX, prefix, localName);
                }
            } else {
                System.out.printf("%s wrapper.getModel() returned unexpected result for %s:%s\n", OUTPUT_PREFIX, prefix, localName);
            }
        } else if (node instanceof Element) {
            if (node.getPrefix().equals(prefix)) {
                if (!node.getLocalName().equals(localName)) {
                    System.out.printf("%s resolver.getNode().getLocalName() is incorrect for %s:%s\n", OUTPUT_PREFIX, prefix, localName);
                }
            } else {
                System.out.printf("%s resolver.getNode().getPrefix() is incorrect for %s:%s\n", OUTPUT_PREFIX, prefix, localName);
            }
        } else if (node != null) {
            if (node instanceof Text) {
                System.out.printf("%s resolver.getNode() returned Text (\"%s\") instead of Element for %s:%s\n", OUTPUT_PREFIX, ((Text)node).getNodeValue(), prefix, localName);
            } else {
                System.out.printf("%s resolver.getNode() returned %s (when Element was expected) for %s:%s\n", OUTPUT_PREFIX, node.getClass().getName(), prefix, localName);
            }
        } else {
            System.out.printf("%s resolver.getNode() returned null for %s:%s\n", OUTPUT_PREFIX, prefix, localName);
        }
        return tagConverter;
    }

    private ContextWrapper getDocumentContext(String path, int offset) throws Exception {
        IProject project = this.webProjectTestEnv.getTestProject();
        IFile jspFile = project.getFile((IPath)new Path(path));
        Test_TransformOperations.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        Test_TransformOperations.assertTrue((boolean)(model instanceof DOMModelForJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
        return new ContextWrapper(context, model);
    }

    private static class ContextWrapper {
        private final IStructuredDocumentContext context;
        private final IStructuredModel model;

        ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this.context = context;
            this.model = model;
        }

        IStructuredDocumentContext getContext() {
            return this.context;
        }

        IStructuredModel getModel() {
            return this.model;
        }

        void dispose() {
            this.model.releaseFromRead();
        }
    }
}

