/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.core.tests.SocketUtil;

public class MonitorTestCase
extends TestCase {
    private static IMonitor monitor;

    protected IMonitor getMonitor() throws Exception {
        if (monitor == null) {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            int port = SocketUtil.findUnusedPort(22100, 22200);
            MonitorTestCase.assertTrue((String)"Could not find free local port", (port != -1 ? 1 : 0) != 0);
            wc.setLocalPort(port);
            wc.setRemoteHost("www.eclipse.org");
            wc.setRemotePort(80);
            monitor = wc.save();
        }
        return monitor;
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"getMonitors"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"deleteMonitors"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"createMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"findMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"startMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"startMonitor2"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"stopMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"stopMonitor2"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"restartMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"deleteMonitor"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"deleteMonitor2"));
        suite.addTest(TestSuite.createTest(MonitorTestCase.class, (String)"findMonitor2"));
    }

    public void deleteMonitors() {
        IMonitor[] monitors = MonitorCore.getMonitors();
        int i = 0;
        while (i < monitors.length) {
            monitors[i].delete();
            ++i;
        }
        monitor = null;
    }

    public void getMonitors() throws Exception {
        MonitorTestCase.assertNotNull((Object)MonitorCore.getMonitors());
        MonitorTestCase.assertEquals((int)0, (int)MonitorCore.getMonitors().length);
    }

    public void createMonitor() throws Exception {
        MonitorTestCase.assertTrue((this.getMonitor() != null ? 1 : 0) != 0);
        MonitorTestCase.assertEquals((int)1, (int)MonitorCore.getMonitors().length);
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((!this.getMonitor().isWorkingCopy() ? 1 : 0) != 0);
    }

    public void findMonitor() throws Exception {
        IMonitor[] monitors;
        int count = 0;
        IMonitor[] iMonitorArray = monitors = MonitorCore.getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitor m = iMonitorArray[n2];
            if (this.getMonitor().equals(m)) {
                ++count;
            }
            ++n2;
        }
        MonitorTestCase.assertEquals((int)1, (int)count);
    }

    public void startMonitor() throws Exception {
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
        this.getMonitor().start();
        MonitorTestCase.assertTrue((boolean)this.getMonitor().isRunning());
    }

    public void startMonitor2() throws Exception {
        MonitorTestCase.assertTrue((boolean)this.getMonitor().isRunning());
        this.getMonitor().start();
        MonitorTestCase.assertTrue((boolean)this.getMonitor().isRunning());
    }

    public void testStartWorkingCopyMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            wc.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void testStartWorkingCopyMonitor2() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            IMonitor m = wc.save();
            m.delete();
            m.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void stopMonitor() throws Exception {
        MonitorTestCase.assertTrue((boolean)this.getMonitor().isRunning());
        this.getMonitor().stop();
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
    }

    public void stopMonitor2() throws Exception {
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
        this.getMonitor().stop();
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
    }

    public void restartMonitor() throws Exception {
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
        try {
            this.getMonitor().start();
        }
        catch (CoreException coreException) {
            Thread.sleep(5000L);
            this.getMonitor().start();
        }
        MonitorTestCase.assertTrue((boolean)this.getMonitor().isRunning());
        this.getMonitor().stop();
        MonitorTestCase.assertTrue((!this.getMonitor().isRunning() ? 1 : 0) != 0);
    }

    public void testStopWorkingCopyMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            wc.stop();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void testStopDeletedMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            IMonitor m = wc.save();
            m.delete();
            m.stop();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void testValidateMonitor() throws Exception {
        MonitorTestCase.assertTrue((boolean)this.getMonitor().validate().isOK());
    }

    public void testModifyMonitor() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(1);
        wc.setRemoteHost("a");
        wc.setRemotePort(2);
        IMonitor monitor2 = wc.save();
        MonitorTestCase.assertEquals((Object)monitor2, (Object)this.getMonitor());
        MonitorTestCase.assertEquals((int)1, (int)this.getMonitor().getLocalPort());
        MonitorTestCase.assertEquals((String)"a", (String)this.getMonitor().getRemoteHost());
        MonitorTestCase.assertEquals((int)2, (int)this.getMonitor().getRemotePort());
    }

    public void deleteMonitor() throws Exception {
        this.getMonitor().delete();
        MonitorTestCase.assertEquals((int)0, (int)MonitorCore.getMonitors().length);
    }

    public void deleteMonitor2() throws Exception {
        this.getMonitor().delete();
    }

    public void testDeleteWorkingCopyMonitor() throws Exception {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.delete();
    }

    public void findMonitor2() throws Exception {
        IMonitor[] monitors;
        int count = 0;
        IMonitor[] iMonitorArray = monitors = MonitorCore.getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitor m = iMonitorArray[n2];
            if (this.getMonitor().equals(m)) {
                ++count;
            }
            ++n2;
        }
        MonitorTestCase.assertEquals((int)0, (int)count);
    }

    public void testCreateMonitor() throws Exception {
        int num = MonitorCore.getMonitors().length;
        MonitorCore.createMonitor();
        MonitorTestCase.assertEquals((int)num, (int)MonitorCore.getMonitors().length);
    }

    public void testCreateMonitor2() {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.setProtocol(null);
        MonitorTestCase.assertNull((Object)wc.getOriginal());
    }

    public void testValidateMonitorLocalPort() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(-1);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemotePort() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(-1);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost(null);
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost2() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost3() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("  ");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost4() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("hi&bye");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost5() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("xyz:");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorRemoteHost6() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((boolean)wc.validate().isOK());
    }

    public void testValidateMonitorLocalHost() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("localhost");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void testValidateMonitorStartLocalHost() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("localhost");
        wc.setRemotePort(80);
        IMonitor monitor2 = wc.save();
        try {
            monitor2.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
        monitor2.delete();
    }

    public void testGetId() throws Exception {
        this.getMonitor().getId();
    }

    public void testGetProtocol() throws Exception {
        MonitorTestCase.assertNotNull((Object)this.getMonitor().getProtocol());
    }

    public void testCheckListener() throws Exception {
        IRequestListener listener2 = new IRequestListener(){

            public void requestAdded(IMonitor monitor2, Request request) {
            }

            public void requestChanged(IMonitor monitor2, Request request) {
            }
        };
        listener2.requestAdded(null, null);
        listener2.requestChanged(null, null);
    }
}

