/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentassist;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPELContentAssistProcessor;
import org.eclipse.jst.jsp.ui.tests.util.FileUtil;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUnzipUtility;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class JSPELContentAssistTest
extends TestCase {
    private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    private String previousWTPAutoTestNonINteractivePropValue = null;
    private static final String TEST_PROJECT_NAME = "testJSPELContentAssist";
    private static final String CONTENT_DIR = "WebContent";
    private static final String STRUCTURED_EDITOR_TYPE = "org.eclipse.wst.sse.ui.StructuredTextEditor.test";
    private static final String FILE_0_PATH = "WebContent/Test0.jsp";
    private static final String FILE_1_PATH = "WebContent/Test1.jsp";
    private static final String FILE_2_PATH = "WebContent/Test2.jsp";
    private static final String[] TEST_0_EXPECTED_PROPS = new String[]{"errorData", "exception", "expressionEvaluator", "out", "page", "request", "response", "servletConfig", "servletContext", "session", "variableResolver"};
    private static final String[] TEST_1_EXPECTED_PROPS = new String[]{"request", "response"};
    private static final String[] TEST_2_EXPECTED_PROPS = new String[]{"request"};
    private static final int TEST_0_DOC_LOC = 371;
    private static final int TEST_1_DOC_LOC = 372;
    private static final int TEST_2_DOC_LOC = 374;
    private IProject project;
    private IWorkbenchPage page;

    public JSPELContentAssistTest() {
        super("JSP EL Content Assist Tests");
    }

    public JSPELContentAssistTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initializeResource();
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        this.previousWTPAutoTestNonINteractivePropValue = noninteractive != null ? noninteractive : "false";
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.previousWTPAutoTestNonINteractivePropValue != null) {
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, this.previousWTPAutoTestNonINteractivePropValue);
        }
    }

    private void initializeResource() throws Exception {
        ProjectUnzipUtility fProjUtil = new ProjectUnzipUtility();
        Location platformLocation = Platform.getInstanceLocation();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(TEST_PROJECT_NAME);
        if (!(platformLocation == null || this.project != null && this.project.isAccessible())) {
            File zipFile = FileUtil.makeFileFor("projecttestfiles", "testJSPELContentAssist.zip", "projecttestfiles");
            fProjUtil.unzipAndImport(zipFile, platformLocation.getURL().getPath());
            fProjUtil.initJavaProject(TEST_PROJECT_NAME);
            this.project = root.getProject(TEST_PROJECT_NAME);
        }
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.page = workbenchWindow.getActivePage();
    }

    public void testELProposals_0() throws Exception {
        ICompletionProposal[] props = this.getCompletionProposals(FILE_0_PATH, 371);
        this.verifyProposals(props, TEST_0_EXPECTED_PROPS);
    }

    public void testELProposals_1() throws Exception {
        ICompletionProposal[] props = this.getCompletionProposals(FILE_1_PATH, 372);
        this.verifyProposals(props, TEST_1_EXPECTED_PROPS);
    }

    public void testELProposals_2() throws Exception {
        ICompletionProposal[] props = this.getCompletionProposals(FILE_2_PATH, 374);
        this.verifyProposals(props, TEST_2_EXPECTED_PROPS);
    }

    public void testELChosenProposalCompletion() throws Exception {
        IFile file = this.getFile(FILE_1_PATH);
        ICompletionProposal[] props = this.getCompletionProposals(file, 372);
        this.verifyProposals(props, TEST_1_EXPECTED_PROPS);
        StructuredTextEditor editor = this.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        IDocument document = viewer.getDocument();
        props[0].apply(document);
        String inserted = document.get(371, TEST_1_EXPECTED_PROPS[0].length());
        JSPELContentAssistTest.assertEquals((String)("The completed proposal " + inserted + " does not match the expected completion " + TEST_1_EXPECTED_PROPS[0]), (String)TEST_1_EXPECTED_PROPS[0], (String)inserted);
        editor.getSite().getPage().saveEditor((IEditorPart)editor, false);
    }

    private IFile getFile(String filePath) {
        IFile retFile = this.project.getFile(filePath);
        JSPELContentAssistTest.assertTrue((String)(retFile + " testing file does not exist."), (boolean)retFile.exists());
        return retFile;
    }

    private ICompletionProposal[] getCompletionProposals(String filePath, int documentLocation) throws PartInitException {
        IFile file = this.getFile(filePath);
        StructuredTextEditor editor = this.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        return this.getCompletionProposals(viewer, documentLocation);
    }

    private ICompletionProposal[] getCompletionProposals(IFile file, int documentLocation) throws PartInitException {
        StructuredTextEditor editor = this.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        return this.getCompletionProposals(viewer, documentLocation);
    }

    private ICompletionProposal[] getCompletionProposals(StructuredTextViewer viewer, int documentLocation) throws PartInitException {
        JSPELContentAssistProcessor processor = new JSPELContentAssistProcessor();
        ICompletionProposal[] props = processor.computeCompletionProposals((ITextViewer)viewer, documentLocation);
        return props;
    }

    private StructuredTextEditor getEditor(IFile file) throws PartInitException {
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart part = this.page.openEditor((IEditorInput)input, STRUCTURED_EDITOR_TYPE, true);
        JSPELContentAssistTest.assertTrue((String)"Unable to open structured text editor", (boolean)(part instanceof StructuredTextEditor));
        return (StructuredTextEditor)part;
    }

    private void verifyProposals(ICompletionProposal[] props, String[] expectedProps) {
        int i = 0;
        while (i < expectedProps.length) {
            JSPELContentAssistTest.assertTrue((String)("The expected proposal \"" + expectedProps[i] + "\" was not given"), (boolean)this.findPropsoal(props, expectedProps[i]));
            ++i;
        }
    }

    private boolean findPropsoal(ICompletionProposal[] props, String expectedProp) {
        boolean found = false;
        int i = 0;
        while (i < props.length && !found) {
            found = props[i].getDisplayString().startsWith(expectedProp);
            ++i;
        }
        return found;
    }
}

