/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTagParser;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.xml.core.internal.modelhandler.ModelHandlerForXML;

public class ScannerUnitTests
extends TestCase {
    protected IStructuredDocument fModel;
    protected String input;
    private BlockTagParser parser;
    protected Object type;
    static /* synthetic */ Class class$0;

    public static boolean checkComplexRegionTypes(ITextRegionList regions, String[] contexts, String[][] embeddedContexts) {
        int embedCount = 0;
        Iterator iterator = regions.iterator();
        int i = 0;
        while (i < contexts.length) {
            if (!iterator.hasNext()) {
                return false;
            }
            ITextRegion region = (ITextRegion)iterator.next();
            ScannerUnitTests.assertEquals((String)("context " + i + " incorrect"), (String)contexts[i], (String)region.getType());
            if (region instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)region;
                boolean embeddedResult = ScannerUnitTests.checkSimpleRegionCount(container, embeddedContexts[embedCount].length) && ScannerUnitTests.checkSimpleRegionTypes(container.getRegions(), embeddedContexts[embedCount]);
                ++embedCount;
                ScannerUnitTests.assertTrue((boolean)embeddedResult);
            }
            ++i;
        }
        return true;
    }

    public static boolean checkModelLength(IStructuredDocument document, int length) {
        return ScannerUnitTests.checkModelLength(document.getLastStructuredDocumentRegion(), length);
    }

    public static boolean checkModelLength(IStructuredDocumentRegion region, int length) {
        return region.getEndOffset() == length;
    }

    public static boolean checkSimpleRegionCount(ITextRegionContainer regionContainer, int size) {
        ScannerUnitTests.assertEquals((String)"region count", (int)size, (int)regionContainer.getNumberOfRegions());
        return true;
    }

    public static boolean checkSimpleRegionCounts(IStructuredDocumentRegionList regionContainers, int[] sizes) {
        int containers = regionContainers.getLength();
        ScannerUnitTests.assertEquals((String)"different number of containers", (int)sizes.length, (int)containers);
        int i = 0;
        while (i < sizes.length) {
            ScannerUnitTests.assertEquals((String)("container " + i + " is different"), (int)sizes[i], (int)regionContainers.item(i).getNumberOfRegions());
            ++i;
        }
        return true;
    }

    public static boolean checkSimpleRegionTypes(ITextRegionList regions, String[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            ITextRegion region = regions.get(i);
            ScannerUnitTests.assertEquals((String)("region type " + i), (String)contexts[i], (String)region.getType());
            ++i;
        }
        return true;
    }

    public static String loadChars(InputStream input) {
        StringBuffer s = new StringBuffer();
        try {
            int c = -1;
            while ((c = input.read()) >= 0) {
                if (c > 255) break;
                s.append((char)c);
            }
            input.close();
        }
        catch (IOException e) {
            System.out.println("An I/O error occured while scanning :");
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            ScannerUnitTests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            ScannerUnitTests.runOne(methodToRun);
        }
    }

    protected static void runAll() {
        TestRunner.run((Test)ScannerUnitTests.suite());
    }

    protected static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        ScannerUnitTests test = new ScannerUnitTests(methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.ui.tests.other.ScannerUnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void verifyLengths(int startOffset, IStructuredDocumentRegion firstDocumentRegion, String text) {
        IStructuredDocumentRegion holdRegion = firstDocumentRegion;
        ScannerUnitTests.assertTrue((String)"document does not start at expected offset", (holdRegion.getStartOffset() == startOffset ? 1 : 0) != 0);
        int lastEnd = 0;
        while (holdRegion != null && holdRegion.getEndOffset() > 0) {
            ScannerUnitTests.assertTrue((String)"zero-length StructuredDocumentRegion found", (holdRegion.getStartOffset() == lastEnd ? 1 : 0) != 0);
            ScannerUnitTests.assertTrue((String)"TextRegionless StructuredDocumentRegion found", (holdRegion.getNumberOfRegions() > 0 ? 1 : 0) != 0);
            ITextRegionList list = holdRegion.getRegions();
            int index = 0;
            int i = 0;
            while (i < list.size()) {
                ITextRegion region = list.get(i);
                ScannerUnitTests.assertTrue((String)"text region seams don't match", (region.getStart() == index ? 1 : 0) != 0);
                index += region.getLength();
                ++i;
            }
            lastEnd = holdRegion.getEndOffset();
            holdRegion = holdRegion.getNext();
        }
        holdRegion = firstDocumentRegion;
        while (holdRegion != null && holdRegion.getNext() != null) {
            holdRegion = holdRegion.getNext();
        }
        ScannerUnitTests.checkModelLength(holdRegion, text.length());
    }

    public static void verifyLengths(int startOffset, IStructuredDocumentRegionList list, String text) {
        ScannerUnitTests.verifyLengths(startOffset, list.item(0), text);
    }

    public static void verifyLengths(IStructuredDocument document, String text) {
        ScannerUnitTests.verifyLengths(0, document.getFirstStructuredDocumentRegion(), text);
    }

    public static void verifyLengths(IStructuredModel model, String text) {
        ScannerUnitTests.verifyLengths(model.getStructuredDocument(), text);
    }

    public ScannerUnitTests(String name) {
        super(name);
    }

    protected void appendTagBlock(StringBuffer buffer, String tagname, int length) {
        buffer.append('<');
        buffer.append(tagname);
        buffer.append('>');
        int i = 0;
        while (i < length) {
            buffer.append('_');
            ++i;
        }
        buffer.append("</");
        buffer.append(tagname);
        buffer.append('>');
    }

    protected void setUp() {
        this.setUpXML(null);
    }

    protected IStructuredDocumentRegionList setUpJSP(String text) {
        this.setupModel((IModelHandler)new ModelHandlerForJSP());
        this.parser.addBlockMarker(new BlockMarker("script", null, "BLOCK_TEXT", false));
        this.parser.addBlockMarker(new BlockMarker("style", null, "BLOCK_TEXT", false));
        this.parser.addBlockMarker(new BlockMarker("disallowJSP", null, "BLOCK_TEXT", true, false));
        this.input = text;
        this.fModel.set(this.input);
        return this.fModel.getRegionList();
    }

    protected void setupModel(IModelHandler contentType) {
        this.fModel = (IStructuredDocument)contentType.getDocumentLoader().createNewStructuredDocument();
        this.parser = (BlockTagParser)this.fModel.getParser();
    }

    protected IStructuredDocumentRegionList setUpXML(String text) {
        this.setupModel((IModelHandler)new ModelHandlerForXML());
        this.parser.addBlockMarker(new BlockMarker("script", null, "BLOCK_TEXT", false));
        this.parser.addBlockMarker(new BlockMarker("style", null, "BLOCK_TEXT", false));
        this.parser.addBlockMarker(new BlockMarker("disallowJSP", null, "BLOCK_TEXT", true, false));
        this.input = text;
        this.fModel.set(this.input);
        return this.fModel.getRegionList();
    }

    protected void testBlockScanBufferBoundaries(String contentTypeID) {
        IStructuredDocument document = null;
        int i = 16409;
        while (i > 16339) {
            StringBuffer text = new StringBuffer();
            document = StructuredModelManager.getModelManager().createStructuredDocumentFor(contentTypeID);
            this.appendTagBlock(text, "script", i);
            String string = text.toString();
            try {
                document.setText((Object)this, string);
                ScannerUnitTests.verifyLengths(document, string);
                ScannerUnitTests.assertTrue((String)("too few document regions [run value " + i + "] "), (new CoreNodeList(document.getFirstStructuredDocumentRegion()).getLength() == 3 ? 1 : 0) != 0);
                ScannerUnitTests.verifyLengths(document, string);
                IStructuredDocumentRegion startTag = document.getFirstStructuredDocumentRegion();
                IStructuredDocumentRegion middleBlock = startTag.getNext();
                ScannerUnitTests.assertTrue((String)"not block text in middle", (middleBlock.getFirstRegion().getType() == "BLOCK_TEXT" ? 1 : 0) != 0);
            }
            catch (Exception e) {
                ScannerUnitTests.assertNull((String)("exception caught" + e), (Object)e);
            }
            --i;
        }
    }

    public void testBlockScanBufferBoundariesForHTML() {
        this.testBlockScanBufferBoundaries("org.eclipse.wst.html.core.htmlsource");
    }

    public void testBlockScanBufferBoundariesForJSP() {
        this.testBlockScanBufferBoundaries("org.eclipse.jst.jsp.core.jspsource");
    }

    private void testBlockTag(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 6, 1, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"BLOCK_TEXT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testCommentMarkupLike() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<!-- if (a<b) -->");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testCommentMarkup() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<!-- <div>Commented Out</div>-->");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testCommentEmbeddedCustomTag() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<!--<link HREF='<c:out value='localhost/file.css'/>'>--> Some text");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testBlockTag_JSP() {
        this.testBlockTag(this.setUpJSP("begin <scrIPt type=\"pl2\"> </scrip t></scripts></scripts <///<!- ---></sCrIPt> end"));
    }

    public void testBlockTag_XML() {
        this.testBlockTag(this.setUpXML("begin <scrIPt type=\"pl2\"> </scrip t></scripts></scripts <///<!- ---></sCrIPt> end"));
    }

    public void testBlockTagWithJSPExpressions() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("begin <script type=\"pl2\"> <%= \"expression\"%> </scrIPt> <a></a> <disallowJSP> <%= \"expression\" %> </disallowJSP> end");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 6, 3, 3, 1, 3, 3, 1, 3, 1, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        int i = 0;
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(i++).getRegions(), new String[]{"BLOCK_TEXT", "BLOCK_TEXT", "BLOCK_TEXT"}, new String[][]{{"JSP_EXPRESSION_OPEN", "JSP_CONTENT", "JSP_CLOSE"}}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"BLOCK_TEXT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(i++).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    private void testBufferUnderRun_1(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 6, 2});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion region count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testBufferUnderRun_1_JSP() {
        this.testBufferUnderRun_1(this.setUpJSP("content <tag a=b/><!--c"));
    }

    public void testBufferUnderRun_1_XML() {
        this.testBufferUnderRun_1(this.setUpXML("content <tag a=b/><!--c"));
    }

    private void testBufferUnderRun_2(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 6, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion region count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_COMMENT_OPEN"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testBufferUnderRun_2_JSP() {
        this.testBufferUnderRun_2(this.setUpJSP("content <tag a=b/><!--"));
    }

    public void testBufferUnderRun_2_XML() {
        this.testBufferUnderRun_2(this.setUpXML("content <tag a=b/><!--"));
    }

    private void testCDATA(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CDATA_OPEN", "XML_CDATA_TEXT", "XML_CDATA_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testCDATA_JSP() {
        this.testCDATA(this.setUpJSP("a <![CDATA[<>!!<!!></&&&--<!--]]> b"));
    }

    public void testCDATA_XML() {
        this.testCDATA(this.setUpXML("a <![CDATA[<>!!<!!></&&&--<!--]]> b"));
    }

    public void testCDATAinBlockJSP1() {
        this.setUpJSP("<script><![CDATA[ contents]]></script>");
    }

    public void testCDATAinBlockJSP2() {
        this.setUpJSP("<script><![CDATA[</script>]]></script>");
    }

    public void testCDATAinBlockJSP2a() {
        this.setUpJSP("<script><![CDATA[contents</script>]]></script>");
    }

    public void testCDATAinBlockJSP2b() {
        this.setUpJSP("<script><![CDATA[</script>contents]]></script>");
    }

    public void testCDATAinBlockJSP3() {
        this.setUpJSP("<script><![CDATA[]]></script>");
    }

    public void testCDATAinBlockJSP4() {
        this.setUpJSP("<script><![CDATA[ ]]>");
    }

    public void testCDATAinBlockJSP5() {
        this.setUpJSP("<script><![CDATA[ ]]]>");
    }

    public void testCDATAinBlockJSP6() {
        this.setUpJSP("<script><![CDATA[ ]]");
    }

    public void testCDATAinBlockJSP7() {
        this.setUpJSP("<script><![CDATA[ ");
    }

    public void testCDATAinBlockJSP8() {
        this.setUpJSP("<script><![CDATA[");
    }

    public void testCDATAinBlockXML1() {
        this.setUpXML("<script><![CDATA[ ]]></script>");
    }

    public void testCDATAinBlockXML2() {
        this.setUpXML("<script><![CDATA[</script>]]></script>");
    }

    public void testCDATAinBlockXML3() {
        this.setUpXML("<script><![CDATA[]]></script>");
    }

    public void testCDATAinBlockXML4() {
        this.setUpXML("<script><![CDATA[ ]]>");
    }

    public void testCDATAinBlockXML5() {
        this.setUpXML("<script><![CDATA[ ]]]>");
    }

    public void testCDATAinBlockXML6() {
        this.setUpXML("<script><![CDATA[ ]]");
    }

    public void testCDATAinBlockXML7() {
        this.setUpXML("<script><![CDATA[ ");
    }

    public void testCDATAinBlockXML8() {
        this.setUpXML("<script><![CDATA[");
    }

    public void testComments_JSP() {
        String text = "a <!-- --><!----><%-- --%> b";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 3, 2, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testComments_XML() {
        String text = "a <!-- --><<!---->b";
        IStructuredDocumentRegionList nodes = this.setUpXML(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 3, 1, 2, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_TAG_OPEN"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    private void testContent(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testContentJSP() {
        this.testContent(this.setUpJSP("hello world"));
    }

    public void testContentXML() {
        this.testContent(this.setUpXML("hello world"));
    }

    public void testDirectiveInTagBody() {
        String text = "<BODY <%@ include file=\"commonEventHandlers.jspf\" %> dir=\"ltr\"> ";
        IStructuredDocumentRegionList documentRegionList = this.setUpJSP(text);
        ScannerUnitTests.verifyLengths(0, documentRegionList, text);
        ScannerUnitTests.checkSimpleRegionTypes(documentRegionList.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"});
        ITextRegionCollection coll = (ITextRegionCollection)documentRegionList.item(0).getRegions().get(2);
        ScannerUnitTests.checkSimpleRegionTypes(coll.getRegions(), new String[]{"JSP_DIRECTIVE_OPEN", "WHITE_SPACE", "JSP_DIRECTIVE_NAME", "WHITE_SPACE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "WHITE_SPACE", "JSP_DIRECTIVE_CLOSE"});
    }

    public void testDollarsign_Leading() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\"$ \"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testDollarsign_Single() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\"$\"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testDollarsign_SingleWithSpaces() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\" $ \"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testELinContent() {
        String text = "${out.foo}";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        sizeCheck = ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(0), 3);
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(0)).getRegions(), new String[]{"JSP_EL_OPEN", "JSP_EL_CONTENT", "JSP_EL_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testELinTag() {
        String text = "<input type=\"button\" ${disabled? 'disabled=\"disabled\"':''}/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{7});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        sizeCheck = ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(5), 9);
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(5)).getRegions(), new String[]{"JSP_EL_OPEN", "JSP_EL_CONTENT", "JSP_EL_SQUOTE", "JSP_EL_QUOTED_CONTENT", "JSP_EL_SQUOTE", "JSP_EL_CONTENT", "JSP_EL_SQUOTE", "JSP_EL_SQUOTE", "JSP_EL_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testELtolerance_transparency_Dquote() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\"${out.foo}\"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 5)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "JSP_EL_OPEN", "JSP_EL_CONTENT", "JSP_EL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"})));
        this.verifyModelLength();
    }

    public void testELtolerance_transparency_DquoteWithSpaces() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\"_${out.foo}_\"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 7)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "XML_TAG_ATTRIBUTE_VALUE", "JSP_EL_OPEN", "JSP_EL_CONTENT", "JSP_EL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"})));
        this.verifyModelLength();
    }

    public void testELtolerance_transparency_Squote() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type='${out.foo}'/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 5)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_SQUOTE", "JSP_EL_OPEN", "JSP_EL_CONTENT", "JSP_EL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_SQUOTE"})));
        this.verifyModelLength();
    }

    public void testEmbeddedJSPDeclaration() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("content <foo bar=\"<%! int foo; %>\" baz=\"il\">");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 9});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}, new String[][]{{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "JSP_DECLARATION_OPEN", "JSP_CONTENT", "JSP_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "WHITE_SPACE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedJSPDeclarationInCDATA() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<![CDATA[<%!%>]]>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkComplexRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CDATA_OPEN", "XML_CDATA_TEXT", "XML_CDATA_CLOSE"}, new String[][]{{"JSP_DECLARATION_OPEN", "JSP_CLOSE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedJSPExpression() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("content <foo bar=\"<%= \"Hello, World\"%>\" baz=\"il\">");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 9});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}, new String[][]{{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "JSP_EXPRESSION_OPEN", "JSP_CONTENT", "JSP_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "WHITE_SPACE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedJSPExpressionInCDATA() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<![CDATA[<%=%>]]>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkComplexRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CDATA_OPEN", "XML_CDATA_TEXT", "XML_CDATA_CLOSE"}, new String[][]{{"JSP_EXPRESSION_OPEN", "JSP_CLOSE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedJSPScriptlet() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("content <foo bar=\"<%  %>\" baz=\"il\">");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 9});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}, new String[][]{{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "JSP_SCRIPTLET_OPEN", "JSP_CONTENT", "JSP_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "WHITE_SPACE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedJSPScriptletInCDATA() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<![CDATA[<%%>]]>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkComplexRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CDATA_OPEN", "XML_CDATA_TEXT", "XML_CDATA_CLOSE"}, new String[][]{{"JSP_SCRIPTLET_OPEN", "JSP_CLOSE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testEmbeddedTagInAttr() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a href=\"<jsp:getProperty/>\">");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkComplexRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}, new String[][]{{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "XML_TAG_OPEN", "XML_TAG_NAME", "XML_EMPTY_TAG_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"}});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testJSP_DHTMLimport() {
        String text = "<a> <?import type=\"foo\">";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3, 1, 6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_PI_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_PI_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes, text);
    }

    public void testJSP_PI() {
        String text = "begin <?php asda;lsgjalg;lasjlajglajslkajlgajsljgaljglaj?>end";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 4, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_PI_OPEN", "XML_TAG_NAME", "XML_PI_CONTENT", "XML_PI_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPAmpersandInTagNameInAttValue() {
        String text = "<a href=\"<a&b>\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{7, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count (tag)", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check (tag)", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check (content)", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes, text);
    }

    public void testJSPCommentInXMLComment() {
        String text = "s<!--\n<%--c--%>\n-->\n<html>\n<body><script> <%--c--%> </script>\n";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 5, 1, 3, 1, 3, 3, 3, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        int item = 0;
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_TEXT", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"}, new String[][]{{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE"}}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkComplexRegionTypes(nodes.item(item++).getRegions(), new String[]{"BLOCK_TEXT", "BLOCK_TEXT", "BLOCK_TEXT"}, new String[][]{{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE"}}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(9).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPCommentAtStartOfXMLCommentAndBlockTag() {
        String text = "s<!--<%--c--%>\n-->\n<html>\n<body><script><%--c--%> </script>\n";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 4, 1, 3, 1, 3, 3, 2, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        int item = 0;
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        typeCheck = typeCheck && ScannerUnitTests.checkComplexRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_COMMENT_OPEN", "XML_COMMENT_TEXT", "XML_COMMENT_TEXT", "XML_COMMENT_CLOSE"}, new String[][]{{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE"}});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        typeCheck = typeCheck && ScannerUnitTests.checkComplexRegionTypes(nodes.item(item++).getRegions(), new String[]{"BLOCK_TEXT", "BLOCK_TEXT"}, new String[][]{{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE"}});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_END_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPCommentinXMLTag() {
        String text = "s<a <%--c--%> b=c/>\n";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 7, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        int item = 0;
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        typeCheck = typeCheck && ScannerUnitTests.checkComplexRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "JSP_COMMENT_TEXT", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"}, new String[][]{{"JSP_COMMENT_OPEN", "JSP_COMMENT_TEXT", "JSP_COMMENT_CLOSE", "WHITE_SPACE"}});
        typeCheck = typeCheck && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(item++).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPDirectiveTags() {
        String text = "begin <jsp:directive.taglib> <jsp:directive.page a> <jsp:directive.include a=> <jsp:directive.pages a=b> end";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 3, 1, 4, 1, 5, 1, 6, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "JSP_DIRECTIVE_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"XML_TAG_OPEN", "JSP_DIRECTIVE_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(5).getRegions(), new String[]{"XML_TAG_OPEN", "JSP_DIRECTIVE_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(6).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(7).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(8).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPDollarsign_Trailing() {
        String text = "<a type=\" $\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPDollarsign_TrailingInContent() {
        String text = "nnn$<a type=\" $\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 1, 6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check (content)", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check (content)", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check (tag)", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPExpression() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("begin <%= \"Hello,World\" %> end");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 1, 1, 1, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"JSP_EXPRESSION_OPEN"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"JSP_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"JSP_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testJSPGreaterThanInAttValue() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("<a type=\">next\"/>");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        ScannerUnitTests.assertTrue((String)"region is not somple", (!(nodes.item(0).getRegions().get(4) instanceof ITextRegionContainer) ? 1 : 0) != 0);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testJSPInvalidTagNameInAttValue() {
        String text = "S<a type=\"a<4\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count (tag)", (boolean)sizeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check (tag)", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPLessThanInAttValue() {
        String text = "<button label=\"<previous\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testJSPRootTag() {
        IStructuredDocumentRegionList nodes = this.setUpJSP("begin <jsp:root> <jsp:roots a> <jsp:roo a=> </jsp:root a=b><a>end");
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 3, 1, 4, 1, 5, 1, 6, 3, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "JSP_ROOT_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(3).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(4).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(5).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(6).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(7).getRegions(), new String[]{"XML_END_TAG_OPEN", "JSP_ROOT_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(8).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(9).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testJSPTagInAttValue() {
        String text = "<a type=\"<a/>\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        sizeCheck = ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 5);
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check (tag)", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "XML_TAG_OPEN", "XML_TAG_NAME", "XML_EMPTY_TAG_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"});
        ScannerUnitTests.assertTrue((String)"region context type check (att value)", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes, text);
    }

    public void testNothinginBlockJSP9() {
        String text = "<script>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testNothinginBlockXML9() {
        String text = "<script>";
        IStructuredDocumentRegionList nodes = this.setUpXML(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    private void testSimpleTag(IStructuredDocumentRegionList nodes) {
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 10, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        this.verifyModelLength();
    }

    public void testSimpleTag_JSP() {
        this.testSimpleTag(this.setUpJSP("0 <tagname attr1 attr2=value2 attr3=\"value3\"> 1"));
    }

    public void testSimpleTag_XML() {
        this.testSimpleTag(this.setUpXML("0 <tagname attr1 attr2=value2 attr3=\"value3\"> 1"));
    }

    public void testVBLinContent() {
        String text = "#{out.foo}";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        sizeCheck = ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(0), 3);
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(0)).getRegions(), new String[]{"JSP_VBL_OPEN", "JSP_VBL_CONTENT", "JSP_VBL_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testVBLtolerance_transparency_Dquote() {
        String text = "<a type=\"#{out.foo}\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 5)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "JSP_VBL_OPEN", "JSP_VBL_CONTENT", "JSP_VBL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"})));
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testVBLtolerance_transparency_DquoteWithSpaces() {
        String text = "<a type=\"_#{out.foo}_\"/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 7)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_DQUOTE", "XML_TAG_ATTRIBUTE_VALUE", "JSP_VBL_OPEN", "JSP_VBL_CONTENT", "JSP_VBL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_ATTRIBUTE_VALUE_DQUOTE"})));
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testVBLtolerance_transparency_Squote() {
        String text = "<a type='#{out.foo}'/>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)(sizeCheck &= ScannerUnitTests.checkSimpleRegionCount((ITextRegionContainer)nodes.item(0).getRegions().get(4), 5)));
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)(typeCheck &= ScannerUnitTests.checkSimpleRegionTypes(((ITextRegionContainer)nodes.item(0).getRegions().get(4)).getRegions(), new String[]{"XML_TAG_ATTRIBUTE_VALUE_SQUOTE", "JSP_VBL_OPEN", "JSP_VBL_CONTENT", "JSP_VBL_CLOSE", "XML_TAG_ATTRIBUTE_VALUE_SQUOTE"})));
        ScannerUnitTests.verifyLengths(0, nodes, text);
    }

    public void testXML_DHTMLimport() {
        String text = "<a> <?import type=\"foo\">";
        IStructuredDocumentRegionList nodes = this.setUpXML(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{3, 1, 3});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_PI_OPEN", "XML_TAG_NAME", "XML_PI_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes, text);
    }

    public void testXML_PI() {
        String text = "begin <?php asda;lsgjalg;lasjlajglajslkajlgajsljgaljglaj?>end";
        IStructuredDocumentRegionList nodes = this.setUpXML(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{1, 4, 1});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_CONTENT"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(1).getRegions(), new String[]{"XML_PI_OPEN", "XML_TAG_NAME", "XML_PI_CONTENT", "XML_PI_CLOSE"}) && ScannerUnitTests.checkSimpleRegionTypes(nodes.item(2).getRegions(), new String[]{"XML_CONTENT"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testXMLDollarsign_Trailing() {
        String text = "<a type=\" $\"/>";
        IStructuredDocumentRegionList nodes = this.setUpXML(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{6});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and ITextRegion count", (boolean)sizeCheck);
        boolean typeCheck = ScannerUnitTests.checkSimpleRegionTypes(nodes.item(0).getRegions(), new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"});
        ScannerUnitTests.assertTrue((String)"region context type check", (boolean)typeCheck);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    public void testUndefinedRegionContainer() {
        String text = "<option <elms:inputValue value=\"<%=uomvox.uomID%>\"/><%=uomvox.uomID.equals(uomID) ? \" selected\" : \"\"%>>";
        IStructuredDocumentRegionList nodes = this.setUpJSP(text);
        boolean sizeCheck = ScannerUnitTests.checkSimpleRegionCounts(nodes, new int[]{5});
        ScannerUnitTests.assertTrue((String)"IStructuredDocumentRegion and overall ITextRegion count", (boolean)sizeCheck);
        this.verifyEmbeddedContainerParentage(nodes);
        ScannerUnitTests.verifyLengths(0, nodes.item(0), text);
    }

    private void verifyEmbeddedContainerParentage(IStructuredDocumentRegionList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            IStructuredDocumentRegion r = nodes.item(i);
            ITextRegionList list = r.getRegions();
            int j = 0;
            while (j < list.size()) {
                ITextRegion region = list.get(j);
                if (region instanceof ITextRegionContainer) {
                    ScannerUnitTests.assertNotNull((String)("parent is null for " + region), (Object)((ITextRegionContainer)region).getParent());
                }
                ++j;
            }
            ++i;
        }
    }

    protected boolean verifyModelLength() {
        return ScannerUnitTests.checkModelLength(this.fModel, this.input.length());
    }
}

