/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchScope;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.ui.internal.java.search.BasicJSPSearchRequestor;
import org.eclipse.jst.jsp.ui.tests.util.FileUtil;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUnzipUtility;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class JSPSearchTests
extends TestCase
implements IJavaSearchConstants {
    private ProjectUnzipUtility projUtil = null;
    private boolean isSetup = false;
    static /* synthetic */ Class class$0;

    public JSPSearchTests() {
        super("JSP Search Tests");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        this.projUtil = new ProjectUnzipUtility();
        Location platformLocation = Platform.getInstanceLocation();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "jspsearch_tests.zip", "projecttestfiles");
        this.projUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        this.projUtil.initJavaProject("judo");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIndexWorkspace() {
        JSPSearchSupport support = JSPSearchSupport.getInstance();
        SearchDocument doc = JSPSearchSupport.getInstance().getSearchDocument("/judo/searchTestJSP.java");
        JSPSearchTests.assertNotNull((String)"couldn't retrieve:'/judo/searchTestJSP.java'", (Object)doc);
        doc = support.getSearchDocument("/judo/searchTestJSP2.java");
        JSPSearchTests.assertNotNull((String)"couldn't retrieve:'/judo/searchTestJSP2.java'", (Object)doc);
        doc = support.getSearchDocument("/judo/searchTestJSP3.java");
        JSPSearchTests.assertNotNull((String)"couldn't retrieve:'/judo/searchTestJSP3.java'", (Object)doc);
    }

    public void testSearchField() {
        TestJspSearchRequestor requestor = new TestJspSearchRequestor();
        requestor.addCheckMatch("searchTestJSP.jsp", 93, 106);
        JSPSearchSupport.getInstance().search("searchForThis", (IJavaSearchScope)new JSPSearchScope(), 4, 3, 0, true, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        JSPSearchTests.assertTrue((String)"did not find all expected matches: searchForThis", (boolean)requestor.checkValid());
    }

    public void testSearchMethod() {
        TestJspSearchRequestor requestor = new TestJspSearchRequestor();
        requestor.addCheckMatch("searchTestJSP.jsp", 143, 158);
        requestor.addCheckMatch("searchTestJSP.jsp", 298, 315);
        JSPSearchSupport.getInstance().search("searchForMethod", (IJavaSearchScope)new JSPSearchScope(), 1, 3, 0, true, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        JSPSearchTests.assertTrue((String)"did not find all expected matches: searchForMethod", (boolean)requestor.checkValid());
    }

    public void testSearchPatternMatch() {
        TestJspSearchRequestor requestor = new TestJspSearchRequestor();
        requestor.addCheckMatch("searchTestJSP.jsp", 93, 106);
        requestor.addCheckMatch("searchTestJSP2.jsp", 116, 129);
        requestor.addCheckMatch("searchTestJSP2.jsp", 152, 165);
        JSPSearchSupport.getInstance().search("search*", (IJavaSearchScope)new JSPSearchScope(), 4, 3, 2, true, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        JSPSearchTests.assertTrue((String)"did not find all expected matches: search*", (boolean)requestor.checkValid());
    }

    public void testSearchProjectClasses() {
        TestJspSearchRequestor requestor = new TestJspSearchRequestor();
        requestor.addCheckMatch("searchTestJSP3.jsp", 148, 157);
        requestor.addCheckMatch("searchTestJSP3.jsp", 170, 179);
        requestor.addCheckMatch("searchTestJSP3.jsp", 263, 273);
        requestor.addCheckMatch("searchTestJSP3.jsp", 299, 309);
        requestor.addCheckMatch("searchTestJSP3.jsp", 408, 417);
        requestor.addCheckMatch("searchTestJSP3.jsp", 430, 439);
        JSPSearchSupport.getInstance().search("Jellybean*", (IJavaSearchScope)new JSPSearchScope(), 0, 3, 2, true, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        JSPSearchTests.assertTrue((String)"did not find all expected matches: search*", (boolean)requestor.checkValid());
    }

    /*
     * Exception decompiling
     */
    public void testSearchLocalVariable() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 196->200)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStructuredModel getStructuredModelForRead(IFile file) {
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            return modelManager.getModelForRead(file);
        }
        catch (IOException iOException) {
            System.out.println("couldn't open file:" + file);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    class TestJspSearchRequestor
    extends BasicJSPSearchRequestor {
        private List matches = new ArrayList();

        protected void addSearchMatch(IStructuredDocument jspDocument, IFile jspFile, int jspStart, int jspEnd, String jspText) {
            this.matches.remove(new TestSearchMatch(jspFile.getName(), jspStart, jspEnd));
        }

        public void beginReporting() {
        }

        public void endReporting() {
        }

        public void addCheckMatch(String filename, int jspStart, int jspEnd) {
            this.matches.add(new TestSearchMatch(filename, jspStart, jspEnd));
        }

        public boolean checkValid() {
            return this.matches.isEmpty();
        }

        public void clear() {
            this.matches.clear();
        }
    }

    class TestSearchMatch {
        public String filename = null;
        public int jspStart = -1;
        public int jspEnd = -1;

        public TestSearchMatch(String filename, int jspStart, int jspEnd) {
            this.filename = filename;
            this.jspStart = jspStart;
            this.jspEnd = jspEnd;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TestSearchMatch)) {
                return false;
            }
            TestSearchMatch possible = (TestSearchMatch)obj;
            return this.filename.equalsIgnoreCase(possible.filename) && this.jspStart == possible.jspStart && this.jspEnd == possible.jspEnd;
        }
    }
}

