/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests;

import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;

public class TraitValueHelperTests
extends ConfigurableTestCase {
    private final String uri = "http://org.eclipse.jsf/traithelpertest";
    private Entity entity;
    private Entity nlsEntity;

    protected void setUp() throws Exception {
        super.setUp();
        ITaglibDomainMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext(null, (String)"http://org.eclipse.jsf/traithelpertest");
        this.entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)context, (String)"tag/attr1");
        Assert.assertNotNull((Object)this.entity);
        this.nlsEntity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)context, (String)"NLS/NLS");
        Assert.assertNotNull((Object)this.nlsEntity);
    }

    public void testGetValueType() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)TraitValueHelper.getValueType((Trait)trait).getName());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)TraitValueHelper.getValueType((Trait)trait).getName());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"multivalStrings");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"ListOfValues", (String)TraitValueHelper.getValueType((Trait)trait).getName());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"multivalIntegers");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"ListOfValues", (String)TraitValueHelper.getValueType((Trait)trait).getName());
        Assert.assertNull((Object)TraitValueHelper.getValueType(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)TraitValueHelper.getValueType((Trait)trait));
        trait.setValue(val);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)TraitValueHelper.getValueType((Trait)trait).getName());
    }

    public void testGetValue() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AString", (String)((String)TraitValueHelper.getValue((Trait)trait)));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((int)1, (int)Integer.parseInt((String)TraitValueHelper.getValue((Trait)trait)));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"aTrueInt");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertTrue((boolean)(trait.getValue() instanceof SimpleAnyType));
        Assert.assertTrue((boolean)((SimpleAnyType)trait.getValue()).getInstanceType().getInstanceClassName().equals("int"));
        Assert.assertEquals((Object)"1", (Object)TraitValueHelper.getValue((Trait)trait));
        Assert.assertNull((Object)TraitValueHelper.getValue(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)TraitValueHelper.getValue((Trait)trait));
        trait.setValue(val);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNull((Object)TraitValueHelper.getValue((Trait)trait));
    }

    public void testGetValueAsString() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AString", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        Assert.assertNull((Object)TraitValueHelper.getValue(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)TraitValueHelper.getValue((Trait)trait));
        trait.setValue(val);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals(null, (String)TraitValueHelper.getValueAsString((Trait)trait));
    }

    public void testGetValueAsListOfStrings() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"multivalStrings");
        Assert.assertNotNull((Object)trait);
        Assert.assertTrue((boolean)(TraitValueHelper.getValueAsListOfStrings((Trait)trait) instanceof List));
        List vals = TraitValueHelper.getValueAsListOfStrings((Trait)trait);
        Assert.assertEquals((int)3, (int)vals.size());
        Assert.assertTrue((boolean)(vals.get(0) instanceof String));
        Assert.assertEquals((String)"A", (String)((String)vals.get(0)));
        Assert.assertEquals((String)"B", (String)((String)vals.get(1)));
        Assert.assertEquals((String)"C", (String)((String)vals.get(2)));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"multivalIntegers");
        Assert.assertNotNull((Object)trait);
        Assert.assertTrue((boolean)(TraitValueHelper.getValueAsListOfStrings((Trait)trait) instanceof List));
        vals = TraitValueHelper.getValueAsListOfStrings((Trait)trait);
        Assert.assertEquals((int)3, (int)vals.size());
        Assert.assertTrue((boolean)(vals.get(0) instanceof String));
        Assert.assertEquals((String)"1", (String)((String)vals.get(0)));
        Assert.assertEquals((String)"2", (String)((String)vals.get(1)));
        Assert.assertEquals((String)"3", (String)((String)vals.get(2)));
    }

    public void testGetNLSValue() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.nlsEntity, (String)"NLS");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((Object)"%NLS1", (Object)TraitValueHelper.getValue((Trait)trait));
        if (Locale.getDefault().getCountry().equalsIgnoreCase("us") && Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            Assert.assertEquals((String)"a day in the life(en_US)", (String)TraitValueHelper.getValueAsString((Trait)trait));
        }
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.nlsEntity, (String)"multivalNLS");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertTrue((boolean)(trait.getValue() instanceof ListOfValues));
        List vals = TraitValueHelper.getValueAsListOfStrings((Trait)trait);
        Assert.assertEquals((int)2, (int)vals.size());
        if (Locale.getDefault().getCountry().equalsIgnoreCase("us") && Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            Assert.assertEquals((Object)"a day in the life(en_US)", vals.get(0));
            Assert.assertEquals((Object)"another string(en_US)", vals.get(1));
        }
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals(null, (String)TraitValueHelper.getValueAsString((Trait)trait));
    }

    public void testGetValueAsBoolean() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"BooleanVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertEquals((boolean)true, (boolean)TraitValueHelper.getValueAsBoolean((Trait)trait));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.entity, (String)"NullBooleanVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertEquals((boolean)false, (boolean)TraitValueHelper.getValueAsBoolean((Trait)trait));
    }

    public void testStringValueType() {
        ITaglibDomainMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext(null, (String)"http://org.eclipse.jsf/traithelpertest");
        Model m = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)context);
        TraitValueHelperTests.assertNotNull((Object)m);
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)m, (String)"TraitId");
        TraitValueHelperTests.assertNotNull((Object)t);
        EObject obj = t.getValue();
        TraitValueHelperTests.assertEquals((String)"StringValue", (String)obj.eClass().getName());
        TraitValueHelperTests.assertEquals((String)"TraitValue", (String)TraitValueHelper.getValueAsString((Trait)t));
    }

    public void testBooleanValueType() {
        ITaglibDomainMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext(null, (String)"http://org.eclipse.jsf/traithelpertest");
        Model m = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)context);
        TraitValueHelperTests.assertNotNull((Object)m);
        Trait t2 = TaglibDomainMetaDataQueryHelper.getTrait((Entity)m, (String)"TraitId2");
        TraitValueHelperTests.assertNotNull((Object)t2);
        EObject obj2 = t2.getValue();
        TraitValueHelperTests.assertEquals((String)"BooleanValue", (String)obj2.eClass().getName());
        TraitValueHelperTests.assertEquals((boolean)true, (boolean)TraitValueHelper.getValueAsBoolean((Trait)t2));
        TraitValueHelperTests.assertEquals((String)"true", (String)TraitValueHelper.getValueAsString((Trait)t2));
        Trait t3 = TaglibDomainMetaDataQueryHelper.getTrait((Entity)m, (String)"TraitId3");
        TraitValueHelperTests.assertNotNull((Object)t3);
        EObject obj3 = t3.getValue();
        TraitValueHelperTests.assertEquals((String)"BooleanValue", (String)obj3.eClass().getName());
        TraitValueHelperTests.assertEquals((boolean)false, (boolean)TraitValueHelper.getValueAsBoolean((Trait)t3));
    }
}

