/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.tests.AbstractBaseMetaDataTestCase;

public class MergeTests
extends AbstractBaseMetaDataTestCase {
    private boolean _debugInfo = false;

    public void testIncludeMerge() {
        this.showDebugInfo(this._debugInfo);
        String uri = "TinyIncludeTest";
        this.startTime(uri);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(uri);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)0, (int)model.getTraits().size());
        MergeTests.assertEquals((int)1, (int)model.getChildEntities().size());
        Entity A_Entity = query.findTagEntity(model, "A");
        MergeTests.assertEquals((int)2, (int)A_Entity.getTraits().size());
        Trait t = query.findTrait(A_Entity, "T1");
        MergeTests.assertNotNull((Object)t);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)t));
        t = query.findTrait(A_Entity, "T2");
        MergeTests.assertNotNull((Object)t);
        MergeTests.assertEquals((String)"T2FromEG", (String)TraitValueHelper.getValueAsString((Trait)t));
        MergeTests.assertEquals((int)2, (int)A_Entity.getChildEntities().size());
        Entity a_Entity = query.findTagAttributeEntity(A_Entity, "a");
        MergeTests.assertNotNull((Object)a_Entity);
        MergeTests.assertEquals((int)1, (int)a_Entity.getTraits().size());
        MergeTests.assertEquals((int)2, (int)a_Entity.getChildEntities().size());
        Entity subA_Entity = query.getQueryHelper().getEntity(A_Entity, "sub-A");
        MergeTests.assertNotNull((Object)subA_Entity);
        Entity subSubA_Entity = query.getQueryHelper().getEntity(subA_Entity, "sub-sub-A");
        MergeTests.assertNotNull((Object)subSubA_Entity);
    }

    public void testMergeOfFileAandFileB() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://org.eclipse.jsf/mergetest1";
        this.startTime(uri);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(uri);
        MergeTests.assertNotNull((Object)model);
        this.endTime();
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)3, (int)model.getTraits().size());
        Trait trait = query.findTrait((Entity)model, "Dupe");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"dupe from A", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)5, (int)model.getChildEntities().size());
        Entity entity = query.findTagEntity(model, "A");
        MergeTests.assertNotNull((Object)entity);
        entity = query.findTagEntity(model, "B");
        MergeTests.assertNotNull((Object)entity);
        entity = query.findTagEntity(model, "Dupe");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromA", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = query.findTrait(entity, "B1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((int)2, (int)entity.getChildEntities().size());
        Entity secondEntity = query.findTagAttributeEntity(entity, "a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = query.findTrait(secondEntity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromA", (String)TraitValueHelper.getValueAsString((Trait)trait));
        entity = query.findTagEntity(model, "DupeWithInclude");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = query.findTrait(entity, "B");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"trait SHOULD appear in merge from eg2", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)2, (int)entity.getChildEntities().size());
        secondEntity = query.findTagAttributeEntity(entity, "a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        entity = query.findTagEntity(model, "DupeWithInclude2");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)1, (int)entity.getTraits().size());
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)1, (int)entity.getChildEntities().size());
        secondEntity = query.findTagAttributeEntity(entity, "a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = query.findTrait(entity, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
    }

    public void testIncludeExternalModel() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://org.eclipse.jsf/mergetest2";
        this.startTime(uri);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(uri);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)1, (int)model.getTraits().size());
        Trait trait = query.findTrait((Entity)model, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)1, (int)model.getChildEntities().size());
        Entity entity = query.findTagEntity(model, "a");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)0, (int)entity.getChildEntities().size());
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        uri = "http://org.eclipse.jsf/mergetest3";
        this.startTime(uri);
        model = query.findTagLibraryModel(uri);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)1, (int)model.getTraits().size());
        trait = query.findTrait((Entity)model, "A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)1, (int)model.getChildEntities().size());
        entity = query.findTagEntity(model, "a");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)0, (int)entity.getChildEntities().size());
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        model = query.getQueryHelper().getModel("http://org.eclipse.jsf/mergetest1");
        MergeTests.assertNotNull((Object)model);
        MergeTests.assertEquals((int)2, (int)model.getEntityGroups().size());
    }

    public void testLoadJSFCore() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://java.sun.com/jsf/core";
        this.startTime(uri);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(uri);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
    }

    public void testLoadJSFHTML() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://java.sun.com/jsf/html";
        this.startTime(uri);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(uri);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
    }
}

