/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.EmptyResultSet;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.AbstractMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataModelManagerContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.SearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.tests.updated.AbstractBaseMetaDataTestCase;
import org.eclipse.jst.jsf.metadata.tests.MetadataTestsPlugin;
import org.junit.Before;
import org.junit.Test;

public class MetaDataQueryHelperTests
extends AbstractBaseMetaDataTestCase {
    private IMetaDataQuery _query;
    private MetaDataQueryHelper _helper;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        this._query = MetaDataQueryFactory.getInstance().createQuery(context);
        MetaDataQueryHelperTests.assertNotNull((Object)this._query);
        this._helper = (MetaDataQueryHelper)this._query.getQueryHelper();
        MetaDataQueryHelperTests.assertNotNull((Object)this._helper);
    }

    public void testGetModel() {
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        MetaDataQueryHelperTests.assertNotNull((String)"http://org.eclipse.jsf/test model should not be null.", (Object)model);
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(null);
        IMetaDataQuery nullProjectQuery = MetaDataQueryFactory.getInstance().createQuery(context);
        model = nullProjectQuery.getQueryHelper().getModel("http://org.eclipse.jsf/test");
        MetaDataQueryHelperTests.assertNotNull((String)"http://org.eclipse.jsf/test model should not be null.", (Object)model);
        MetaDataQueryHelperTests.assertNotNull((Object)model.getId());
        MetaDataQueryHelperTests.assertEquals((String)"http://org.eclipse.jsf/test is not same as model.getId()", (String)"http://org.eclipse.jsf/test", (String)model.getId());
        context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        IMetaDataQuery badUriQuery = MetaDataQueryFactory.getInstance().createQuery(context);
        model = badUriQuery.getQueryHelper().getModel("blah");
        MetaDataQueryHelperTests.assertNull((Object)model);
        IMetaDataModelManagerContext badContext = new IMetaDataModelManagerContext(){

            public Object getAdapter(Class adapter) {
                if (adapter == IProject.class) {
                    return MetaDataQueryHelperTests.this.project;
                }
                return null;
            }

            public String getDomainId() {
                return "badDomainKey";
            }

            public IProject getProject() {
                return MetaDataQueryHelperTests.this.project;
            }
        };
        MetadataTestsPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.jst.jsf.metadata.tests", "***** UnsupportedOperationException about to occur because of Test ! *****"));
        IMetaDataQuery badDomainQuery = MetaDataQueryFactory.getInstance().createQuery((IMetaDataDomainContext)badContext);
        MetaDataQueryHelperTests.assertNull((Object)badDomainQuery);
    }

    public void testGetEntityIMetaDataModelContextString() {
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        Entity entity = this._helper.getEntity((Entity)model, "loaded");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = this._helper.getEntity((Entity)model, "loaded/att3");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = this._helper.getEntity((Entity)model, "doesnotexist");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    public void testGetEntitiesIMetaDataModelContextStringIEntityQueryVisitor() {
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet rs = this._helper.getEntities((Entity)model, "loaded", (IEntityQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        Entity entity = null;
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)1, (int)rs.getResults().size());
            entity = (Entity)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)entity);
            MetaDataQueryHelperTests.assertEquals((String)entity.getId(), (String)"loaded");
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
        visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(-1, 2));
        rs = this._helper.getEntities((Entity)model, "loaded", (IEntityQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            entity = (Entity)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)entity);
            MetaDataQueryHelperTests.assertEquals((String)entity.getId(), (String)"loaded");
            Entity secondentity = (Entity)rs.getResults().get(1);
            MetaDataQueryHelperTests.assertNotNull((Object)secondentity);
            MetaDataQueryHelperTests.assertEquals((String)"loaded", (String)secondentity.getId());
            MetaDataQueryHelperTests.assertFalse((secondentity == entity ? 1 : 0) != 0);
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetTraitEntityString() {
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        Entity entity = this._helper.getEntity((Entity)model, "loaded/att3");
        Trait trait = this._helper.getTrait(entity, "A3");
        MetaDataQueryHelperTests.assertNotNull((Object)trait);
        trait = this._helper.getTrait(entity, "Z3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
    }

    public void testGetTraits() {
        SimpleTraitQueryVisitorImpl visitor = new SimpleTraitQueryVisitorImpl(new SearchControl(1));
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        IResultSet rs = this._helper.getTraits((Entity)model, "model-trait", (ITraitQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        Trait trait = null;
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)1, (int)rs.getResults().size());
            trait = (Trait)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)trait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)trait.getId());
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
        visitor = new SimpleTraitQueryVisitorImpl(new SearchControl(-1));
        rs = this._helper.getTraits((Entity)model, "model-trait", (ITraitQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            trait = (Trait)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)trait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)trait.getId());
            Trait secondTrait = (Trait)rs.getResults().get(1);
            MetaDataQueryHelperTests.assertNotNull((Object)secondTrait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)secondTrait.getId());
            MetaDataQueryHelperTests.assertFalse((trait == secondTrait ? 1 : 0) != 0);
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetEntityEntityString() {
        Model model = this._helper.getModel("http://org.eclipse.jsf/test");
        Entity entity = this._helper.getEntity((Entity)model, "loaded");
        entity = this._helper.getEntity(entity, "att3");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = this._helper.getEntity(entity, "zzz");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    public void testGetEntitiesEntityStringIEntityQueryVisitor() {
        IResultSet rs = this._helper.getEntities("badURI", "foo", (IEntityQueryVisitor)new SimpleEntityQueryVisitorImpl());
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertEquals((int)0, (int)rs.getResults().size());
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetTraitIMetaDataModelContextStringString() {
        Trait trait = this._helper.getTrait("http://org.eclipse.jsf/test", "loaded/att3", "A3");
        MetaDataQueryHelperTests.assertNotNull((Object)trait);
        trait = this._helper.getTrait("http://org.eclipse.jsf/test", "loaded/att3", "zzz");
        MetaDataQueryHelperTests.assertNull((Object)trait);
        trait = this._helper.getTrait("http://org.eclipse.jsf/test", "doesnotexist", "A3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
        trait = this._helper.getTrait("badDomain", "doesnotexist", "A3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
    }

    public void testResultSets() {
        IResultSet rs = this._helper.getEntities("http://org.eclipse.jsf/test", "loaded", (IEntityQueryVisitor)new SimpleEntityQueryVisitorImpl());
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            MetaDataQueryHelperTests.assertFalse((boolean)rs.isClosed());
            rs.close();
            MetaDataQueryHelperTests.assertTrue((boolean)rs.isClosed());
        }
        catch (MetaDataException e1) {
            MetaDataQueryHelperTests.fail((String)e1.getMessage());
        }
        try {
            rs.getResults();
            MetaDataQueryHelperTests.fail((String)"Expected MetaDataException ");
        }
        catch (MetaDataException metaDataException) {}
    }

    public void testGetEntityBeyondMDDepth() {
        Entity entity = this._helper.getEntity("http://org.eclipse.jsf/test", "loaded/does_not_exist/nor_this");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    public void testGetEntityBadEntityKey() {
        Entity entity = this._helper.getEntity("http://org.eclipse.jsf/test", "");
        MetaDataQueryHelperTests.assertNull((Object)entity);
        entity = this._helper.getEntity("http://org.eclipse.jsf/test", null);
        MetaDataQueryHelperTests.assertNull((Object)entity);
        entity = this._helper.getEntity("http://org.eclipse.jsf/test", "/");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    @Test
    public void testSubclassability() {
        MyMetaDataQueryHelper myHelper = new MyMetaDataQueryHelper();
        this._query.setQueryHelper((IMetaDataQueryHelper)myHelper);
        MetaDataQueryHelperTests.assertSame((Object)this._query.getQueryHelper(), (Object)((Object)myHelper));
    }

    private class MyMetaDataQueryHelper
    extends MetaDataQueryHelper {
        MyMetaDataQueryHelper() {
            super(((AbstractMetaDataQuery)MetaDataQueryHelperTests.this._query).getManager(), ((AbstractMetaDataQuery)MetaDataQueryHelperTests.this._query).getDomainContext());
        }
    }
}

