/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.tests.AbstractBaseMetaDataTestCase;

public class MissingMDExtensionModelTests
extends AbstractBaseMetaDataTestCase {
    private ITaglibDomainMetaDataQuery _query;
    Model model;
    Trait trait;

    public void setUp() throws Exception {
        super.setUp();
        String uri = "http://org.eclipse.jsf/missingMDModelTest";
        LogListener logListener = new LogListener();
        try {
            JSFCommonPlugin.getPlugin().getLog().addLogListener((ILogListener)logListener);
            IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
            this._query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
            this.model = this._query.findTagLibraryModel(uri);
            MissingMDExtensionModelTests.assertNotNull((Object)this.model);
            if (JSFCommonPlugin.getPlugin().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsf.common/debug/metadataload")).booleanValue()) {
                MissingMDExtensionModelTests.assertTrue((logListener.getMessages().size() > 2 ? 1 : 0) != 0);
            }
        }
        finally {
            JSFCommonPlugin.getPlugin().getLog().removeLogListener((ILogListener)logListener);
        }
    }

    public void testModelLoadWithMissingECoreExtensionModel() {
        Entity entity = this._query.getQueryHelper().getEntity((Entity)this.model, "Tag/Attr1");
        MissingMDExtensionModelTests.assertNotNull((Object)entity);
        this.trait = this._query.findTrait(entity, "attribute-value-runtime-type");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait.getValue());
        MissingMDExtensionModelTests.assertEquals((String)"org.eclipse.jst.jsf.core.attributevalues.StringType", (String)TraitValueHelper.getValueAsString((Trait)this.trait));
        this.trait = this._query.findTrait(entity, "bogusTrait");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNull((Object)this.trait.getValue());
        this.trait = this._query.findTrait(entity, "reallybogusTrait");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNull((Object)this.trait.getValue());
        this.trait = this._query.findTrait(entity, "valid-values");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait.getValue());
        entity = this._query.getQueryHelper().getEntity((Entity)this.model, "Tag/DefaultAttr");
        MissingMDExtensionModelTests.assertNotNull((Object)entity);
        this.trait = this._query.findTrait(entity, "attribute-value-runtime-type");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait.getValue());
        MissingMDExtensionModelTests.assertEquals((String)"org.eclipse.jst.jsf.core.attributevalues.StringType", (String)TraitValueHelper.getValueAsString((Trait)this.trait));
        this.trait = this._query.findTrait(entity, "bogusTrait");
        MissingMDExtensionModelTests.assertNotNull((Object)this.trait);
        MissingMDExtensionModelTests.assertNull((Object)this.trait.getValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogListener
    implements ILogListener {
        private List<IStatus> statusMsgs = new ArrayList<IStatus>();

        public void logging(IStatus status, String plugin) {
            this.statusMsgs.add(status);
        }

        public List<IStatus> getMessages() {
            return this.statusMsgs;
        }
    }
}

