/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;

public class ProjectCreationTests
extends AbstractTests {
    private ProjectCreationTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Creation Tests");
        suite.addTest((Test)new ProjectCreationTests("testEARCreation"));
        suite.addTest((Test)new ProjectCreationTests("testWebCreation"));
        suite.addTest((Test)new ProjectCreationTests("testWebWithEARCreation"));
        suite.addTest((Test)new ProjectCreationTests("testEJBCreation"));
        suite.addTest((Test)new ProjectCreationTests("testEJBWithEARCreation"));
        suite.addTest((Test)new ProjectCreationTests("testUtilCreation"));
        suite.addTest((Test)new ProjectCreationTests("testUtilWithEARCreation"));
        return suite;
    }

    public void testEARCreation() throws Exception {
        ProjectUtil.createEARProject("TestEAR");
    }

    public void testWebCreation() throws Exception {
        ProjectUtil.createWebProject("TestWeb", null);
    }

    public void testWebWithEARCreation() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        DependencyVerificationUtil.verifyEARDependency(earProject, ProjectUtil.createWebProject("TestWeb", earProject.getName()), true);
    }

    public void testEJBCreation() throws Exception {
        ProjectUtil.createEJBProject("TestEJB", null);
    }

    public void testEJBWithEARCreation() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject ejbProject = ProjectUtil.createEJBProject("TestEJB", earProject.getName());
        DependencyVerificationUtil.verifyEARDependency(earProject, ejbProject, true);
        this.testEJBClient(ejbProject, earProject);
    }

    private void testEJBClient(IProject ejbProject, IProject earProject) throws Exception {
        IProject ejbClient = ProjectUtil.getProject(String.valueOf(ejbProject.getName()) + "Client");
        DependencyVerificationUtil.verifyProjectReference(earProject, ejbClient, true);
        DependencyVerificationUtil.verifyComponentReference(earProject, ejbClient, DependencyVerificationUtil.ROOT, true);
        DependencyVerificationUtil.verifyManifestReference(ejbProject, String.valueOf(ejbClient.getName()) + ".jar", true);
    }

    public void testUtilCreation() throws Exception {
        ProjectUtil.createUtilityProject("TestUtil", null);
    }

    public void testUtilWithEARCreation() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        DependencyVerificationUtil.verifyEARDependency(earProject, ProjectUtil.createUtilityProject("TestUtil", earProject.getName()), false);
    }
}

